/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.db.derby.core.services;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.db.derby.core.DerbyControlConnection;

public class DerbyConnectionService
extends ConnectionService {
    public IControlConnection createControlConnection(DatabaseIdentifier databaseIdentifier) throws SQLException {
        return new DerbyControlConnection(EditorCorePlugin.getControlConnectionManager(), databaseIdentifier);
    }

    public Connection createConnection(String profileName, String dbName) {
        try {
            Connection jdbcConn = ProfileUtil.getReusableConnection((DatabaseIdentifier)new DatabaseIdentifier(profileName, dbName));
            IConnectionProfile profile = ProfileUtil.getProfile((String)profileName);
            IManagedConnection managedConn = profile.getManagedConnection(ConnectionInfo.class.getName());
            IConnection iConn = managedConn.getConnection();
            ConnectionInfo connInfo = (ConnectionInfo)iConn.getRawConnection();
            if (jdbcConn == connInfo.getSharedConnection()) {
                return jdbcConn;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (NoSuchProfileException e) {
            e.printStackTrace();
        }
        return super.createConnection(profileName, dbName);
    }
}

