/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IParameterRowSet;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaBlob;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaClob;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaQuery;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSet;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaRowSet;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;

public class OdaAdvancedQuery
extends OdaQuery
implements IAdvancedQuery {
    private boolean m_calledExecuteQueryForExecute = false;
    private IResultSet m_resultSet;

    protected OdaAdvancedQuery(IAdvancedQuery statement, OdaConnection connection, String dataSetType, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((IQuery)statement, connection, dataSetType, switchContextClassloader, driverClassLoader);
        String context = "OdaAdvancedQuery.OdaAdvancedQuery( " + statement + ", " + connection + ", " + dataSetType + " )\t";
        this.logMethodExitWithReturn(context, this);
    }

    private IAdvancedQuery getAdvancedQuery() {
        return (IAdvancedQuery)this.getQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws OdaException {
        String context = "OdaAdvancedQuery.execute()\t";
        this.logMethodCalled("OdaAdvancedQuery.execute()\t");
        try {
            this.setContextClassloader();
            this.doExecute();
            this.logMethodExitWithReturn("OdaAdvancedQuery.execute()\t", this.isExecuted());
            boolean bl = this.isExecuted();
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IAdvancedQuery.execute()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private boolean doExecute() throws OdaException {
        this.resetExecuteStates();
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotExecuteBeforePrepare);
        }
        boolean supportsMultipleResultSets = this.getDSMetaData().checkSupportForMultipleResultSets();
        boolean supportsNamedResultSets = this.getDSMetaData().checkSupportForNamedResultSets();
        boolean isExecuted = false;
        if (supportsMultipleResultSets || supportsNamedResultSets) {
            isExecuted = this.getAdvancedQuery().execute();
        } else {
            this.m_resultSet = this.getQuery().executeQuery();
            this.m_calledExecuteQueryForExecute = true;
            isExecuted = true;
        }
        this.setIsExecuted(isExecuted);
        return isExecuted;
    }

    private boolean wasExecuteQueryCalledForExec() {
        return this.m_calledExecuteQueryForExecute;
    }

    protected void resetExecuteStates() {
        super.resetExecuteStates();
        this.m_calledExecuteQueryForExecute = false;
        this.m_resultSet = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultSet getResultSet() throws OdaException {
        String context = "OdaAdvancedQuery.getResultSet()\t";
        this.logMethodCalled("OdaAdvancedQuery.getResultSet()\t");
        try {
            this.setContextClassloader();
            OdaResultSet ret = null;
            if (this.m_calledExecuteQueryForExecute) {
                ret = this.m_resultSet == null ? null : this.newResultSetHelper(this.m_resultSet);
                this.m_resultSet = null;
            } else {
                IResultSet resultSet = this.getAdvancedQuery().getResultSet();
                ret = resultSet == null ? null : this.newResultSetHelper(resultSet);
            }
            this.logMethodExitWithReturn("OdaAdvancedQuery.getResultSet()\t", ret);
            OdaResultSet odaResultSet = ret;
            return odaResultSet;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getResultSet()");
            IResultSet iResultSet = null;
            return iResultSet;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IResultSet iResultSet = null;
            return iResultSet;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IResultSet iResultSet = null;
            return iResultSet;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults() throws OdaException {
        String context = "OdaAdvancedQuery.getMoreResults()\t";
        this.logMethodCalled("OdaAdvancedQuery.getMoreResults()\t");
        try {
            this.setContextClassloader();
            boolean ret = this.m_calledExecuteQueryForExecute ? false : this.getAdvancedQuery().getMoreResults();
            this.logMethodExitWithReturn("OdaAdvancedQuery.getMoreResults()\t", ret);
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IAdvancedQuery.getMoreResults()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultSetMetaData getMetaDataOf(String resultSetName) throws OdaException {
        String context = "OdaAdvancedQuery.getMetaDataOf( " + resultSetName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            IResultSetMetaData resultSetMetaData = this.getAdvancedQuery().getMetaDataOf(resultSetName);
            OdaResultSetMetaData ret = resultSetMetaData == null ? null : new OdaResultSetMetaData(resultSetMetaData, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
            this.logMethodExitWithReturn(context, ret);
            OdaResultSetMetaData odaResultSetMetaData = ret;
            return odaResultSetMetaData;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getMetaDataOf( String resultSetName )");
            IResultSetMetaData iResultSetMetaData = null;
            return iResultSetMetaData;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IResultSetMetaData iResultSetMetaData = null;
            return iResultSetMetaData;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IResultSetMetaData iResultSetMetaData = null;
            return iResultSetMetaData;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getResultSetNames() throws OdaException {
        String context = "OdaAdvancedQuery.getResultSetNames()\t";
        this.logMethodCalled("OdaAdvancedQuery.getResultSetNames()\t");
        try {
            this.setContextClassloader();
            String[] ret = this.getAdvancedQuery().getResultSetNames();
            this.logMethodExitWithReturn("OdaAdvancedQuery.getResultSetNames()\t", ret);
            String[] stringArray = ret;
            return stringArray;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getResultSetNames()");
            String[] stringArray = null;
            return stringArray;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            String[] stringArray = null;
            return stringArray;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultSet getResultSet(String resultSetName) throws OdaException {
        String context = "OdaAdvancedQuery.getResultSet( " + resultSetName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            if (this.wasExecuteQueryCalledForExec()) {
                throw this.newOdaException(Messages.helper_cannotGetNamedResultsAfterExecuteQuery);
            }
            IResultSet resultSet = this.getAdvancedQuery().getResultSet(resultSetName);
            OdaResultSet ret = null;
            ret = resultSet == null ? null : this.newResultSetHelper(resultSet);
            this.logMethodExitWithReturn(context, ret);
            OdaResultSet odaResultSet = ret;
            return odaResultSet;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getResultSet( String resultSetName )");
            IResultSet iResultSet = null;
            return iResultSet;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IResultSet iResultSet = null;
            return iResultSet;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IResultSet iResultSet = null;
            return iResultSet;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParameterRowSet setNewRow(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.setNewRow( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            IParameterRowSet rowSet = this.getAdvancedQuery().setNewRow(parameterName);
            OdaRowSet ret = this.createFactoryRow(rowSet);
            this.logMethodExitWithReturn(context, ret);
            OdaRowSet odaRowSet = ret;
            return odaRowSet;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.setNewRow( String parameterName )");
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParameterRowSet setNewRow(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.setNewRow( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            IParameterRowSet rowSet = this.getAdvancedQuery().setNewRow(parameterId);
            OdaRowSet ret = this.createFactoryRow(rowSet);
            this.logMethodExitWithReturn(context, ret);
            OdaRowSet odaRowSet = ret;
            return odaRowSet;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.setNewRow( int parameterId )");
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParameterRowSet setNewRowSet(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.setNewRowSet( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            IParameterRowSet rowSet = this.getAdvancedQuery().setNewRowSet(parameterName);
            OdaRowSet ret = rowSet == null ? null : new OdaRowSet(rowSet, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
            this.logMethodExitWithReturn(context, ret);
            OdaRowSet odaRowSet = ret;
            return odaRowSet;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.setNewRowSet( String parameterName )");
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParameterRowSet setNewRowSet(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.setNewRowSet( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfSetParamBeforePrepare();
            IParameterRowSet rowSet = this.getAdvancedQuery().setNewRowSet(parameterId);
            OdaRowSet ret = rowSet == null ? null : new OdaRowSet(rowSet, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
            this.logMethodExitWithReturn(context, ret);
            OdaRowSet odaRowSet = ret;
            return odaRowSet;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.setNewRowSet( int parameterId )");
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getInt( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            int ret = 0;
            if (this.getDSMetaData().checkSupportForNamedParameters()) {
                ret = this.getAdvancedQuery().getInt(parameterName);
            } else {
                int index = this.getAdvancedQuery().findOutParameter(parameterName);
                ret = this.getAdvancedQuery().getInt(index);
            }
            this.logMethodExitWithReturn(context, ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IAdvancedQuery.getInt( String parameterName )");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getInt( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            int ret = this.getAdvancedQuery().getInt(parameterId);
            this.logMethodExitWithReturn(context, ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IAdvancedQuery.getInt( int parameterId )");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getDouble( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            double ret = 0.0;
            if (this.getDSMetaData().checkSupportForNamedParameters()) {
                ret = this.getAdvancedQuery().getDouble(parameterName);
            } else {
                int index = this.getAdvancedQuery().findOutParameter(parameterName);
                ret = this.getAdvancedQuery().getDouble(index);
            }
            this.logMethodExitWithReturn(context, ret);
            double d = ret;
            return d;
        }
        catch (UnsupportedOperationException uoException) {
            double d = this.handleUnsupportedOpAndRetZero(uoException, "IAdvancedQuery.getDouble( String parameterName )");
            return d;
        }
        catch (RuntimeException rtException) {
            double d = this.handleErrorAndReturnZero(rtException);
            return d;
        }
        catch (OdaException odaException) {
            double d = this.handleErrorAndReturnZero(odaException);
            return d;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getDouble( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            double ret = this.getAdvancedQuery().getDouble(parameterId);
            this.logMethodExitWithReturn(context, ret);
            double d = ret;
            return d;
        }
        catch (UnsupportedOperationException uoException) {
            double d = this.handleUnsupportedOpAndRetZero(uoException, "IAdvancedQuery.getDouble( int parameterId )");
            return d;
        }
        catch (RuntimeException rtException) {
            double d = this.handleErrorAndReturnZero(rtException);
            return d;
        }
        catch (OdaException odaException) {
            double d = this.handleErrorAndReturnZero(odaException);
            return d;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getBigDecimal( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            BigDecimal ret = null;
            if (this.getDSMetaData().checkSupportForNamedParameters()) {
                ret = this.getAdvancedQuery().getBigDecimal(parameterName);
            } else {
                int index = this.getAdvancedQuery().findOutParameter(parameterName);
                ret = this.getAdvancedQuery().getBigDecimal(index);
            }
            this.logMethodExitWithReturn(context, ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBigDecimal( String parameterName )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getBigDecimal( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            BigDecimal ret = this.getAdvancedQuery().getBigDecimal(parameterId);
            this.logMethodExitWithReturn(context, ret);
            BigDecimal bigDecimal = ret;
            return bigDecimal;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBigDecimal( int parameterId )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getString( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            String ret = null;
            if (this.getDSMetaData().checkSupportForNamedParameters()) {
                ret = this.getAdvancedQuery().getString(parameterName);
            } else {
                int index = this.getAdvancedQuery().findOutParameter(parameterName);
                ret = this.getAdvancedQuery().getString(index);
            }
            this.logMethodExitWithReturn(context, ret);
            String string = ret;
            return string;
        }
        catch (UnsupportedOperationException uoException) {
            String string = this.handleUnsupportedOpAndRetEmptyString(uoException, "IAdvancedQuery.getString( String parameterName )");
            return string;
        }
        catch (RuntimeException rtException) {
            String string = this.handleErrorAndReturnEmptyString(rtException);
            return string;
        }
        catch (OdaException odaException) {
            String string = this.handleErrorAndReturnEmptyString(odaException);
            return string;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getString( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            String ret = this.getAdvancedQuery().getString(parameterId);
            this.logMethodExitWithReturn(context, ret);
            String string = ret;
            return string;
        }
        catch (UnsupportedOperationException uoException) {
            String string = this.handleUnsupportedOpAndRetEmptyString(uoException, "IAdvancedQuery.getString( int parameterId )");
            return string;
        }
        catch (RuntimeException rtException) {
            String string = this.handleErrorAndReturnEmptyString(rtException);
            return string;
        }
        catch (OdaException odaException) {
            String string = this.handleErrorAndReturnEmptyString(odaException);
            return string;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getDate( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            Date ret = null;
            if (this.getDSMetaData().checkSupportForNamedParameters()) {
                ret = this.getAdvancedQuery().getDate(parameterName);
            } else {
                int index = this.getAdvancedQuery().findOutParameter(parameterName);
                ret = this.getAdvancedQuery().getDate(index);
            }
            this.logMethodExitWithReturn(context, ret);
            Date date = ret;
            return date;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getDate( String parameterName )");
            Date date = null;
            return date;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Date date = null;
            return date;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Date date = null;
            return date;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getDate( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            Date ret = this.getAdvancedQuery().getDate(parameterId);
            this.logMethodExitWithReturn(context, ret);
            Date date = ret;
            return date;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getDate( int parameterId )");
            Date date = null;
            return date;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Date date = null;
            return date;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Date date = null;
            return date;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getTime( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            Time ret = null;
            if (this.getDSMetaData().checkSupportForNamedParameters()) {
                ret = this.getAdvancedQuery().getTime(parameterName);
            } else {
                int index = this.getAdvancedQuery().findOutParameter(parameterName);
                ret = this.getAdvancedQuery().getTime(index);
            }
            this.logMethodExitWithReturn(context, ret);
            Time time = ret;
            return time;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getTime( String parameterName )");
            Time time = null;
            return time;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Time time = null;
            return time;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Time time = null;
            return time;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getTime( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            Time ret = this.getAdvancedQuery().getTime(parameterId);
            this.logMethodExitWithReturn(context, ret);
            Time time = ret;
            return time;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getTime( int parameterId )");
            Time time = null;
            return time;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Time time = null;
            return time;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Time time = null;
            return time;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getTimestamp( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            Timestamp ret = null;
            if (this.getDSMetaData().checkSupportForNamedParameters()) {
                ret = this.getAdvancedQuery().getTimestamp(parameterName);
            } else {
                int index = this.getAdvancedQuery().findOutParameter(parameterName);
                ret = this.getAdvancedQuery().getTimestamp(index);
            }
            this.logMethodExitWithReturn(context, ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getTimestamp( String parameterName )");
            Timestamp timestamp = null;
            return timestamp;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Timestamp timestamp = null;
            return timestamp;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Timestamp timestamp = null;
            return timestamp;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getTimestamp( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            Timestamp ret = this.getAdvancedQuery().getTimestamp(parameterId);
            this.logMethodExitWithReturn(context, ret);
            Timestamp timestamp = ret;
            return timestamp;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getTimestamp( int parameterId )");
            Timestamp timestamp = null;
            return timestamp;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Timestamp timestamp = null;
            return timestamp;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Timestamp timestamp = null;
            return timestamp;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBlob getBlob(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getBlob( " + parameterName + " )\t";
        String unsupportedOpContext = "IAdvancedQuery.getBlob( String parameterName )";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            IBlob driverBlob = null;
            if (this.getDSMetaData().checkSupportForNamedParameters()) {
                driverBlob = this.getAdvancedQuery().getBlob(parameterName);
            } else {
                int index = this.getAdvancedQuery().findOutParameter(parameterName);
                driverBlob = this.getAdvancedQuery().getBlob(index);
            }
            IBlob ret = this.createBlobWrapper(driverBlob);
            this.logMethodExitWithReturn(context, ret);
            IBlob iBlob = ret;
            return iBlob;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBlob( String parameterName )");
            IBlob iBlob = null;
            return iBlob;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IBlob iBlob = null;
            return iBlob;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IBlob iBlob = null;
            return iBlob;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBlob getBlob(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getBlob( " + parameterId + " )\t";
        String unsupportedOpContext = "IAdvancedQuery.getBlob( int parameterId )";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            IBlob driverBlob = this.getAdvancedQuery().getBlob(parameterId);
            IBlob ret = this.createBlobWrapper(driverBlob);
            this.logMethodExitWithReturn(context, ret);
            IBlob iBlob = ret;
            return iBlob;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBlob( int parameterId )");
            IBlob iBlob = null;
            return iBlob;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IBlob iBlob = null;
            return iBlob;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IBlob iBlob = null;
            return iBlob;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private IBlob createBlobWrapper(IBlob driverBlob) {
        return driverBlob == null ? null : new OdaBlob(driverBlob, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClob getClob(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getClob( " + parameterName + " )\t";
        String unsupportedOpContext = "IAdvancedQuery.getClob( String parameterName )";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            IClob driverClob = null;
            if (this.getDSMetaData().checkSupportForNamedParameters()) {
                driverClob = this.getAdvancedQuery().getClob(parameterName);
            } else {
                int index = this.getAdvancedQuery().findOutParameter(parameterName);
                driverClob = this.getAdvancedQuery().getClob(index);
            }
            IClob ret = this.createClobWrapper(driverClob);
            this.logMethodExitWithReturn(context, ret);
            IClob iClob = ret;
            return iClob;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getClob( String parameterName )");
            IClob iClob = null;
            return iClob;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IClob iClob = null;
            return iClob;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IClob iClob = null;
            return iClob;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClob getClob(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getClob( " + parameterId + " )\t";
        String unsupportedOpContext = "IAdvancedQuery.getClob( int parameterId )";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            IClob driverClob = this.getAdvancedQuery().getClob(parameterId);
            IClob ret = this.createClobWrapper(driverClob);
            this.logMethodExitWithReturn(context, ret);
            IClob iClob = ret;
            return iClob;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getClob( int parameterId )");
            IClob iClob = null;
            return iClob;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IClob iClob = null;
            return iClob;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IClob iClob = null;
            return iClob;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private IClob createClobWrapper(IClob driverClob) {
        return driverClob == null ? null : new OdaClob(driverClob, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getBoolean( " + parameterName + " )\t";
        String unsupportedOpContext = "IAdvancedQuery.getBoolean( String )";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            boolean ret = false;
            if (this.getDSMetaData().checkSupportForNamedParameters()) {
                ret = this.getAdvancedQuery().getBoolean(parameterName);
            } else {
                int n = this.getAdvancedQuery().findOutParameter(parameterName);
                ret = this.getAdvancedQuery().getBoolean(n);
            }
            this.logMethodExitWithReturn(context, ret);
            boolean bl = ret;
            return bl;
        }
        catch (AbstractMethodError err) {
            String string = this.formatMethodNotImplementedMsg("IAdvancedQuery.getBoolean( String )");
            this.log(context, string);
            this.handleUnsupportedOp(new UnsupportedOperationException(string), string);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBoolean( String )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getBoolean( " + parameterId + " )\t";
        String unsupportedOpContext = "IAdvancedQuery.getBoolean( int )";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            boolean ret = this.getAdvancedQuery().getBoolean(parameterId);
            this.logMethodExitWithReturn(context, ret);
            boolean bl = ret;
            return bl;
        }
        catch (AbstractMethodError err) {
            String msg = this.formatMethodNotImplementedMsg("IAdvancedQuery.getBoolean( int )");
            this.log(context, msg);
            this.handleUnsupportedOp(new UnsupportedOperationException(msg), msg);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBoolean( int )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParameterRowSet getRow(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getRow( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            OdaRowSet ret = null;
            if (this.getDSMetaData().checkSupportForNamedParameters()) {
                IParameterRowSet rowSet = this.getAdvancedQuery().getRow(parameterName);
                ret = this.createFactoryRow(rowSet);
            } else {
                int index = this.getAdvancedQuery().findOutParameter(parameterName);
                ret = this.doGetRow(index);
            }
            this.logMethodExitWithReturn(context, ret);
            OdaRowSet odaRowSet = ret;
            return odaRowSet;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getRow( String parameterName )");
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParameterRowSet getRow(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getRow( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            this.throwIfNotExecuted();
            OdaRowSet ret = this.doGetRow(parameterId);
            this.logMethodExitWithReturn(context, ret);
            OdaRowSet odaRowSet = ret;
            return odaRowSet;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getRow( int parameterId )");
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            IParameterRowSet iParameterRowSet = null;
            return iParameterRowSet;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    private OdaRowSet doGetRow(int parameterId) throws OdaException {
        IParameterRowSet rowSet = this.getAdvancedQuery().getRow(parameterId);
        return this.createFactoryRow(rowSet);
    }

    private OdaRowSet createFactoryRow(IParameterRowSet driverRow) throws OdaException {
        OdaRowSet retSet = driverRow == null ? null : new OdaRowSet(driverRow, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
        return retSet != null && driverRow.absolute(1) ? retSet : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findOutParameter(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.findOutParameter( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            if (!this.isPreparedSuccessfully()) {
                throw this.newOdaException(Messages.helper_cannotGetParamMdBeforePrepare);
            }
            int ret = this.getAdvancedQuery().findOutParameter(parameterName);
            this.logMethodExitWithReturn(context, ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IAdvancedQuery.findOutParameter( String parameterName )");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnZero(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnZero(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws OdaException {
        String context = "OdaAdvancedQuery.wasNull()\t";
        this.logMethodCalled("OdaAdvancedQuery.wasNull()\t");
        try {
            this.setContextClassloader();
            if (!this.isExecuted()) {
                this.logMethodExit("OdaAdvancedQuery.wasNull()\t");
                boolean bl = true;
                return bl;
            }
            boolean ret = this.getAdvancedQuery().wasNull();
            this.logMethodExitWithReturn("OdaAdvancedQuery.wasNull()\t", ret);
            boolean bl = ret;
            return bl;
        }
        catch (UnsupportedOperationException uoException) {
            boolean bl = this.handleUnsupportedOpAndRetFalse(uoException, "IAdvancedQuery.wasNull()");
            return bl;
        }
        catch (RuntimeException rtException) {
            boolean bl = this.handleErrorAndReturnFalse(rtException);
            return bl;
        }
        catch (OdaException odaException) {
            boolean bl = this.handleErrorAndReturnFalse(odaException);
            return bl;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSortSpec(String resultSetName, SortSpec sortBy) throws OdaException {
        String context = "OdaAdvancedQuery.setSortSpec( " + resultSetName + ", " + sortBy + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            if (!this.isPreparedSuccessfully()) {
                throw this.newOdaException(Messages.helper_cannotSetSortSpecBeforePrepare);
            }
            this.getAdvancedQuery().setSortSpec(resultSetName, sortBy);
            this.logMethodExit(context);
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.setSortSpec( String resultSetName, SortSpec sortBy )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortSpec getSortSpec(String resultSetName) throws OdaException {
        String context = "OdaAdvancedQuery.getSortSpec( " + resultSetName + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            SortSpec sortSpec = this.getAdvancedQuery().getSortSpec(resultSetName);
            this.logMethodExitWithReturn(context, sortSpec);
            SortSpec sortSpec2 = sortSpec;
            return sortSpec2;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IAdvancedQuery.getSortSpec( String resultSetName )");
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
        }
        finally {
            this.resetContextClassloader();
        }
        return null;
    }

    public String getBigDecimalAsString(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getBigDecimalAsString( " + parameterName + " )\t";
        this.logMethodCalled(context);
        BigDecimal decimal = this.getBigDecimal(parameterName);
        String ret = decimal == null ? null : decimal.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getBigDecimalAsString(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getBigDecimalAsString( " + parameterId + " )\t";
        this.logMethodCalled(context);
        BigDecimal decimal = this.getBigDecimal(parameterId);
        String ret = decimal == null ? null : decimal.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getDateAsString(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getDateAsString( " + parameterName + " )\t";
        this.logMethodCalled(context);
        Date date = this.getDate(parameterName);
        String ret = date == null ? null : date.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getDateAsString(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getDateAsString( " + parameterId + " )\t";
        this.logMethodCalled(context);
        Date date = this.getDate(parameterId);
        String ret = date == null ? null : date.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimeAsString(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getTimeAsString( " + parameterName + " )\t";
        this.logMethodCalled(context);
        Time time = this.getTime(parameterName);
        String ret = time == null ? null : time.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimeAsString(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getTimeAsString( " + parameterId + " )\t";
        this.logMethodCalled(context);
        Time time = this.getTime(parameterId);
        String ret = time == null ? null : time.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimestampAsString(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getTimestampAsString( " + parameterName + " )\t";
        this.logMethodCalled(context);
        Timestamp timestamp = this.getTimestamp(parameterName);
        String ret = timestamp == null ? null : timestamp.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimestampAsString(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getTimestampAsString( " + parameterId + " )\t";
        this.logMethodCalled(context);
        Timestamp timestamp = this.getTimestamp(parameterId);
        String ret = timestamp == null ? null : timestamp.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getClobAsString(String columnName) throws OdaException {
        String context = "OdaAdvancedQuery.getClobAsString( " + columnName + " )\t";
        this.logMethodCalled(context);
        String ret = this.getClobAsStringImpl(this.getClob(columnName), context);
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getClobAsString(int index) throws OdaException {
        String context = "OdaAdvancedQuery.getClobAsString( " + index + " )\t";
        this.logMethodCalled(context);
        String ret = this.getClobAsStringImpl(this.getClob(index), context);
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getInterfaceName() {
        return IAdvancedQuery.class.getName();
    }

    private void throwIfNotExecuted() throws OdaException {
        if (!this.isExecuted()) {
            throw this.newOdaException(Messages.helper_cannotGetParamBeforeExecute);
        }
    }

    private void throwIfSetParamBeforePrepare() throws OdaException {
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotSetParamBeforePrepare);
        }
    }
}

