/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui.editor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.core.DataCorePlugin;
import org.eclipse.datatools.sqltools.data.internal.core.common.Output;
import org.eclipse.datatools.sqltools.data.internal.core.editor.IRowData;
import org.eclipse.datatools.sqltools.data.internal.core.editor.ITableData;
import org.eclipse.datatools.sqltools.data.internal.core.editor.TableDataImpl;
import org.eclipse.datatools.sqltools.data.internal.ui.DataUIPlugin;
import org.eclipse.datatools.sqltools.data.internal.ui.OutputItemAdapter;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.Messages;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataCellEditor;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataCellModifier;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataContentProvider;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataEditorActionBarContributor;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataEditorInput;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataEditorSelectionProvider;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataLabelProvider;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataTableCursor;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataTableCursorExternalEditingSupport;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class TableDataEditor
extends EditorPart {
    protected TableViewer tableViewer;
    protected ITableData tableData;
    protected Table sqlTable;
    protected boolean dirty = false;
    protected TableDataTableCursor cursor;
    protected TableDataEditorSelectionProvider selectionProvider;
    private boolean askConfirmation;
    private Set dirtyBackgroundSet = new HashSet();

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof TableDataEditorInput)) {
            throw new PartInitException("Invalid Input: Must be TableEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.sqlTable = ((TableDataEditorInput)input).getTable();
        this.setPartName(this.sqlTable.getName());
    }

    public void createPartControl(Composite parent) {
        this.tableViewer = new TableViewer(parent, 32768);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableDataLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new TableDataContentProvider());
        try {
            this.tableData = new TableDataImpl(this.sqlTable);
            this.configureTable();
            this.tableViewer.setInput((Object)this.tableData);
        }
        catch (CoreException core) {
            String title = Messages.getString("TableDataEditor.ErrorInitializingEditor");
            ErrorDialog.openError((Shell)this.tableViewer.getControl().getShell(), (String)title, null, (IStatus)core.getStatus());
        }
        catch (Exception ex) {
            DataUIPlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            this.displayException(Messages.getString("TableDataEditor.ErrorInitializingEditor"), ex);
        }
        this.cursor = new TableDataTableCursorExternalEditingSupport(this.tableViewer, this);
        if (this.tableViewer.getTable().getItemCount() > 0) {
            this.cursor.setSelection(0, 0);
        }
        this.selectionProvider = new TableDataEditorSelectionProvider(this);
        this.createContextMenu();
    }

    public void dispose() {
        if (this.tableData != null) {
            this.tableData.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        boolean okay;
        if (this.askConfirmation && !(okay = MessageDialog.openQuestion((Shell)this.tableViewer.getControl().getShell(), (String)Messages.getString("TableDataEditor.RemoveRowsConfirmation.title"), (String)Messages.getString("TableDataEditor.RemoveRowsConfirmation.message", new Object[]{String.valueOf(this.sqlTable.getSchema().getName()) + "." + this.sqlTable.getName()})))) {
            return;
        }
        OperationCommand item = this.initDbOutputItem();
        try {
            ResultsViewAPI resultsView = ResultsViewAPI.getInstance();
            resultsView.createNewInstance(item, null);
            resultsView.updateStatus(item, 1);
            int ret = this.tableData.save((Output)new OutputItemAdapter(item));
            resultsView.updateStatus(item, ret);
            if (ret == 3 || ret == 4) {
                this.setDirty(false);
                this.revertToOriginalBackground();
            } else {
                monitor.setCanceled(true);
            }
        }
        catch (Exception ex) {
            ResultsViewAPI.getInstance().updateStatus(item, 7);
            DataUIPlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            this.displayException(Messages.getString("TableDataEditor.ErrorWhileSaving"), ex);
            monitor.setCanceled(true);
        }
    }

    protected OperationCommand initDbOutputItem() {
        String qualifiedTableName = DataCorePlugin.getQualifiedTableName((Table)this.sqlTable);
        int actionType = 6;
        String displayStr = qualifiedTableName;
        String consumerName = null;
        Database database = this.sqlTable.getSchema().getCatalog() != null ? this.sqlTable.getSchema().getCatalog().getDatabase() : this.sqlTable.getSchema().getDatabase();
        ConnectionInfo connInfo = DatabaseConnectionRegistry.getConnectionForDatabase((Database)database);
        String connectionProfieName = ((ConnectionInfoImpl)connInfo).getConnectionProfile().getName();
        String databaseName = database.getName();
        OperationCommand oCommand = new OperationCommand(actionType, displayStr, consumerName, connectionProfieName, databaseName);
        return oCommand;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean value) {
        this.dirty = value;
        this.firePropertyChange(257);
    }

    public void doRevert() {
        this.tableData.revert();
        this.tableViewer.refresh();
        this.cursor.redraw();
        this.setDirty(false);
        this.revertToOriginalBackground();
    }

    public void doRefresh() {
        if (this.getEditorSite().getPage().saveEditor((IEditorPart)this, true)) {
            try {
                this.tableData = new TableDataImpl(this.sqlTable);
                this.tableViewer.setInput((Object)this.tableData);
                this.cursor.redraw();
                this.setDirty(false);
            }
            catch (Exception ex) {
                DataUIPlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
                this.displayException(Messages.getString("TableDataEditor.ErrorRefreshing"), ex);
            }
        }
    }

    protected IRowData getRow() {
        Object row = this.cursor.getRow().getData();
        if (row instanceof IRowData) {
            return (IRowData)row;
        }
        return null;
    }

    public IRowData getOrCreateRow() {
        IRowData row = this.getRow();
        if (row == null) {
            IRowData newRow = this.tableData.insertRow();
            this.tableViewer.insert((Object)newRow, this.tableViewer.getTable().getItemCount() - 1);
            this.cursor.setSelection(this.tableViewer.getTable().getItemCount() - 2, this.cursor.getColumn());
            this.cursor.redraw();
            return newRow;
        }
        return row;
    }

    public void doInsertRow() {
        this.cursor.setSelection(this.tableViewer.getTable().getItemCount() - 1, 0);
        this.doUpdateValue();
    }

    public void doUpdateValue() {
        this.cursor.edit();
    }

    public void doSetNull() {
        IRowData row = this.getOrCreateRow();
        row.updateValue(this.cursor.getColumn(), null);
        this.tableViewer.refresh((Object)row);
        this.cursor.redraw();
        this.setDirty(true);
    }

    public void doDelete() {
        IRowData row = this.getRow();
        if (row != null) {
            this.tableData.deleteRow(row);
            this.tableViewer.remove((Object)row);
            this.setDirty(true);
            this.askConfirmation = true;
        }
    }

    protected void createContextMenu() {
        final TableDataEditorActionBarContributor contributor = DataUIPlugin.getDefault().getTableDataEditorContributor();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)contributor.revertAction);
                mgr.add((IAction)contributor.refreshAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)contributor.updateAction);
                mgr.add((IAction)contributor.setNullAction);
                mgr.add((IAction)contributor.insertAction);
                mgr.add((IAction)contributor.deleteAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add((IContributionItem)new GroupMarker("additions"));
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)contributor.saveAction);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
        this.cursor.setMenu(menu);
        this.getEditorSite().registerContextMenu(menuMgr, (ISelectionProvider)this.selectionProvider);
    }

    public void setFocus() {
        this.cursor.setFocus();
    }

    protected void configureTable() {
        TableDataCellEditor textEditor = new TableDataCellEditor(this, (Composite)this.tableViewer.getTable());
        CellEditor[] editors = new CellEditor[this.tableData.getColumnCount()];
        String[] properties = new String[this.tableData.getColumnCount()];
        int i = 0;
        while (i < this.tableData.getColumnCount()) {
            TableColumn col = new TableColumn(this.tableViewer.getTable(), 0);
            col.setWidth(100);
            col.setText(this.tableData.getColumnHeader(i));
            col.pack();
            editors[i] = textEditor;
            properties[i] = this.tableData.getColumnName(i);
            ++i;
        }
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setColumnProperties(properties);
        this.tableViewer.setCellModifier((ICellModifier)new TableDataCellModifier(this, this.tableViewer));
        this.tableViewer.getTable().pack();
    }

    public ITableData getTableData() {
        return this.tableData;
    }

    public Table getSqlTable() {
        return this.sqlTable;
    }

    public TableDataTableCursor getCursor() {
        return this.cursor;
    }

    public boolean isReadonly() {
        return this.tableData.isReadonly();
    }

    protected void displayException(String msg, Exception ex) {
        Status warning = new Status(4, "org.eclipse.datatools.sqltools.data.ui", 1, ex.toString(), (Throwable)ex);
        ErrorDialog.openError((Shell)this.tableViewer.getControl().getShell(), (String)msg, null, (IStatus)warning);
    }

    public TableDataEditorSelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void setDirtyBackground(int columnIndex, TableItem item) {
        int itemCount = this.tableViewer.getTable().getItemCount();
        if (item != null) {
            if (this.tableViewer.getTable().indexOf(item) == itemCount - 1) {
                item = this.tableViewer.getTable().getItem(itemCount - 2);
            }
            Display display = Display.getCurrent();
            item.setBackground(columnIndex, display.getSystemColor(7));
            this.dirtyBackgroundSet.add(item);
        }
    }

    protected void revertToOriginalBackground() {
        Display display = Display.getCurrent();
        int columns = this.tableViewer.getTable().getColumnCount();
        Iterator iter = this.dirtyBackgroundSet.iterator();
        while (iter.hasNext()) {
            TableItem item = (TableItem)iter.next();
            int i = 0;
            while (i < columns) {
                item.setBackground(i, display.getSystemColor(1));
                ++i;
            }
        }
        this.dirtyBackgroundSet.clear();
    }

    public void removeDirtyBackground(int columnIndex, TableItem item) {
        if (item != null) {
            Display display = Display.getCurrent();
            item.setBackground(columnIndex, display.getSystemColor(1));
            this.dirtyBackgroundSet.remove(item);
        }
    }
}

