/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.derby.internal.ui.explorer.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.derby.internal.ui.util.ResourceLoader;
import org.eclipse.datatools.connectivity.derby.ui.explorer.providers.virtual.ISynonymFolder;
import org.eclipse.datatools.connectivity.derby.ui.explorer.providers.virtual.IVirtualNodeServiceFactory;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogSchema;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.containment.ContainmentService;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class ServerExplorerContentProvider
implements ICommonContentProvider {
    private static final ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
    private static final IVirtualNodeServiceFactory factory = IVirtualNodeServiceFactory.INSTANCE;
    private static final Object[] EMPTY_ELEMENT_ARRAY = new Object[0];
    private static final String SYNONYM_FOLDER = ResourceLoader.INSTANCE.queryString("DATATOOLS.DERBY.UI.SYNONYMS");

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof DerbyCatalogSchema) {
            return new Object[]{factory.makeSynonymFolder(SYNONYM_FOLDER, SYNONYM_FOLDER, parentElement)};
        }
        if (parentElement instanceof ISynonymFolder) {
            Schema owningSchema = (Schema)((ISynonymFolder)parentElement).getParent();
            ArrayList<EObject> list = new ArrayList<EObject>(owningSchema.getTables().size());
            Iterator iterator = owningSchema.getTables().iterator();
            while (iterator.hasNext()) {
                EObject child = (EObject)iterator.next();
                if (!((ISynonymFolder)parentElement).getGroupID().equals(containmentService.getGroupId(child))) continue;
                list.add(child);
            }
            return this.getArrays(parentElement, list);
        }
        return EMPTY_ELEMENT_ARRAY;
    }

    protected Object[] getArrays(Object parent, Collection collection) {
        if (collection.isEmpty()) {
            return EMPTY_ELEMENT_ARRAY;
        }
        if (parent instanceof IVirtualNode) {
            if (((IVirtualNode)parent).hasChildren()) {
                return ((IVirtualNode)parent).getChildrenArray();
            }
            ((IVirtualNode)parent).addChildren(collection);
        }
        return collection.toArray(new Object[collection.size()]);
    }

    public Object getParent(Object element) {
        if (element instanceof IVirtualNode) {
            return ((IVirtualNode)element).getParent();
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }
}

