/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection;

import org.eclipse.core.resources.IFile;
import org.eclipse.datatools.sqltools.common.ui.util.TableLayoutComposite;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.ConnectionInfoDialog;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.Messages;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FilesConnectionInfoDialog
extends ConnectionInfoDialog {
    private IFile[] _files = null;
    private Object[] _results = null;
    private CheckboxTableViewer fTableViewer = null;

    public FilesConnectionInfoDialog(Shell parentShell, ISQLEditorConnectionInfo connInfo, boolean overridePrompt, IFile[] files, String title) {
        super(parentShell, connInfo, overridePrompt, title);
        this._files = files;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createOuterArea(parent);
        this.createFilesArea(composite);
        this.createConnectionArea(composite);
        return composite;
    }

    protected void createFilesArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.ConnectionInfoDialog_file_conn_info);
        TableLayoutComposite tableComposite = new TableLayoutComposite(composite, 0);
        GridData data = new GridData(1808);
        data.widthHint = 500;
        data.heightHint = this.convertHeightInCharsToPixels(15);
        tableComposite.setLayoutData((Object)data);
        Table table = new Table((Composite)tableComposite, 68386);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.FilesConnectionInfoDialog_column_name);
        int minWidth = this.computeMinimumColumnWidth(gc, Messages.FilesConnectionInfoDialog_column_name);
        tableComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.FilesConnectionInfoDialog_column_type);
        minWidth = this.computeMinimumColumnWidth(gc, Messages.FilesConnectionInfoDialog_column_type);
        tableComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(Messages.FilesConnectionInfoDialog_column_profile);
        minWidth = this.computeMinimumColumnWidth(gc, Messages.FilesConnectionInfoDialog_column_profile);
        tableComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        TableColumn column4 = new TableColumn(table, 0);
        column4.setAlignment(0x1000000);
        column4.setText(Messages.FilesConnectionInfoDialog_column_database);
        minWidth = this.computeMinimumColumnWidth(gc, Messages.FilesConnectionInfoDialog_column_database);
        tableComposite.addColumnData((ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        gc.dispose();
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new FileConnectionInfoLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new FileConnectionInfoContentProvider());
        this.fTableViewer.setComparator(null);
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FilesConnectionInfoDialog.this.checkOK();
            }
        });
        this.fTableViewer.setInput((Object)this._files);
        this.fTableViewer.setAllChecked(true);
        this.fTableViewer.getControl().addMouseTrackListener((MouseTrackListener)new TooltipPresenter());
        this.addSelectionButtons(composite);
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(buttonComposite, 18, Messages.SELECT_ALL_TITLE, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilesConnectionInfoDialog.this.fTableViewer.setAllChecked(true);
                FilesConnectionInfoDialog.this.checkOK();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, Messages.DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilesConnectionInfoDialog.this.fTableViewer.setAllChecked(false);
                FilesConnectionInfoDialog.this.checkOK();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected boolean checkOK() {
        boolean enabled;
        boolean bl = enabled = this._group.canFinish() && this.fTableViewer.getCheckedElements() != null && this.fTableViewer.getCheckedElements().length > 0;
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(enabled);
        }
        return enabled;
    }

    private int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    protected void okPressed() {
        this._results = this.fTableViewer.getCheckedElements();
        super.okPressed();
    }

    public Object[] getCheckedFiles() {
        return this._results;
    }

    private class FileConnectionInfoContentProvider
    implements IStructuredContentProvider {
        private FileConnectionInfoContentProvider() {
        }

        public Object[] getElements(Object input) {
            return (Object[])input;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class FileConnectionInfoLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FileConnectionInfoLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IFile file = (IFile)element;
            ISQLEditorConnectionInfo connInfo = SQLFileUtil.getConnectionInfo(file);
            switch (columnIndex) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return connInfo.getDatabaseVendorDefinitionId().toString();
                }
                case 2: {
                    return connInfo.getConnectionProfileName();
                }
                case 3: {
                    return connInfo.getDatabaseName();
                }
            }
            return "";
        }
    }

    private class TooltipPresenter
    extends MouseTrackAdapter {
        private TooltipPresenter() {
        }

        public void mouseHover(MouseEvent e) {
            if (FilesConnectionInfoDialog.this.fTableViewer != null && !FilesConnectionInfoDialog.this.fTableViewer.getControl().isDisposed()) {
                Table table = (Table)e.widget;
                TableItem item = table.getItem(new Point(e.x, e.y));
                if (item != null && item.getData() != null) {
                    String tooltip = ((IFile)item.getData()).getFullPath().makeRelative().toString();
                    table.setToolTipText(tooltip);
                } else {
                    table.setToolTipText(null);
                }
            }
        }
    }
}

