/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.sqltools.common.ui.resource.WizardNewFileCreationPage;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.ConnectionInfoGroup;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.SQLScrapbookEditorInput;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.ExceptionHandler;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewSQLScrapbookFileWizardPage
extends WizardNewFileCreationPage {
    private static final String fgDefaultExtension = ".sql";
    private ConnectionInfoGroup _group = null;

    public NewSQLScrapbookFileWizardPage(IStructuredSelection selection) {
        super("createScrapBookPage", selection);
        this.setTitle(SqlscrapbookPlugin.getResourceString("NewSQLScrapbookFileWizardPage.title"));
    }

    public boolean finish() {
        String fileName = this.getFileName();
        if (fileName != null && !fileName.endsWith(fgDefaultExtension)) {
            this.setFileName(fileName + fgDefaultExtension);
        }
        boolean retValue = super.validatePage();
        final IFile file = this.createNewFile();
        if (retValue && file != null) {
            Shell shell = this.getShell();
            IWorkbenchPage page = SqlscrapbookPlugin.getActivePage();
            if (shell == null || page == null) {
                return true;
            }
            final IWorkbenchPart focusPart = page.getActivePart();
            if (focusPart instanceof ISetSelectionTarget) {
                shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        StructuredSelection selection = new StructuredSelection((Object)file);
                        ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                    }
                });
            }
            try {
                this._group.finish();
                SQLScrapbookEditorInput editorInput = new SQLScrapbookEditorInput(file, this._group.getConnectionInfo());
                SqlscrapbookPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "org.eclipse.datatools.sqltools.sqlscrapbook.SQLScrapbookEditor");
                return true;
            }
            catch (PartInitException e) {
                ExceptionHandler.handle((CoreException)((Object)e), shell, SqlscrapbookPlugin.getResourceString("NewSQLScrapbookFileWizardPage.open_error.message"), e.getMessage());
            }
        }
        return false;
    }

    protected boolean validatePage() {
        boolean valid = super.validatePage();
        if (!valid) {
            return false;
        }
        IWorkspaceRoot workspaceRoot = SqlscrapbookPlugin.getWorkspace().getRoot();
        String fileName = this.getFileName();
        if (fileName != null && !fileName.endsWith(fgDefaultExtension)) {
            fileName = fileName + fgDefaultExtension;
            IPath path = this.getContainerFullPath();
            if (path != null && workspaceRoot.exists(path.append(fileName))) {
                this.setErrorMessage(SqlscrapbookPlugin.getResourceString("NewSQLScrapbookFileWizardPage.error.AlreadyExists"));
                return false;
            }
        }
        if (valid && this._group != null && !this._group.canFinish()) {
            this.setMessage(SqlscrapbookPlugin.getResourceString("NewFileWithProfilePage.error.profile"));
            this.setErrorMessage(null);
            valid = false;
        }
        if (valid && this._group != null && this._group.getWarning() != null) {
            this.setMessage(this._group.getWarning());
            this.setErrorMessage(null);
        }
        return valid;
    }

    public void createPageControl(Composite parent) {
        super.createPageControl(parent);
        ISQLEditorConnectionInfo connInfo = SQLFileUtil.getConnectionInfoFromPreference();
        this._group = new ConnectionInfoGroup(parent, (Listener)this, connInfo, false, false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.datatools.sqltools.sqleditor.new_sql_file");
    }
}

