/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.core;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.debugger.core.IControlConnectionExtension;
import org.eclipse.datatools.sqltools.debugger.core.IDebuggerControlConnection;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class AutoAttachUtil {
    public static Connection createConnection(IControlConnection controlcon, boolean autoattach, String[] connid) throws SQLException, CoreException, NoSuchProfileException {
        IControlConnectionExtension extension = (IControlConnectionExtension)controlcon.getAdapter(IControlConnectionExtension.class);
        if (extension != null) {
            return extension.createConnection(autoattach, connid);
        }
        if (controlcon instanceof IDebuggerControlConnection) {
            return ((IDebuggerControlConnection)controlcon).createConnection(connid);
        }
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)controlcon.getDatabaseIdentifier().getProfileName());
        ConnectionService conService = f.getConnectionService();
        return conService.createConnection(controlcon.getDatabaseIdentifier().getProfileName(), controlcon.getDatabaseIdentifier().getDBname());
    }

    public static void enableAutoAttach(final IControlConnection controlCon) {
        IControlConnectionExtension extension = (IControlConnectionExtension)controlCon.getAdapter(IControlConnectionExtension.class);
        if (extension != null) {
            if (extension.getAutoAttachEnabled()) {
                return;
            }
            extension.setAutoAttachEnabled(true);
            DebuggerCorePlugin.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)DebuggerCorePlugin.getActiveWorkbenchShell(), (String)DebuggerMessages.AutoAttachUtil_information, (String)(DebuggerMessages.AutoAttachUtil_auto_attach_for_profile + controlCon.getDatabaseIdentifier() + DebuggerMessages.AutoAttachUtil_enabled_by_system));
                }
            });
        }
    }
}

