/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.model;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifierImpl;
import org.eclipse.datatools.sqltools.debugger.breakpoint.SPLineBreakpoint;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;

public class SPDebugModelUtil {
    public static String getModelIdentifier() {
        return DebuggerCorePlugin.PLUGIN_ID + ".debugModelPresentation";
    }

    public static SPLineBreakpoint createLineBreakpoint(ProcIdentifier procid, int lineNumber, boolean register) throws CoreException {
        SPLineBreakpoint bp = new SPLineBreakpoint(procid, lineNumber, true);
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)bp);
        }
        return bp;
    }

    public static SPLineBreakpoint findLineBreakpoint(ProcIdentifier procid, int lineNumber) {
        String modelId = SPDebugModelUtil.getModelIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        for (int i = 0; i < breakpoints.length; ++i) {
            SPLineBreakpoint breakpoint;
            IMarker marker;
            if (!(breakpoints[i] instanceof SPLineBreakpoint) || (marker = (breakpoint = (SPLineBreakpoint)breakpoints[i]).getMarker()) == null || !marker.exists()) continue;
            try {
                ProcIdentifier pi = breakpoint.getProcIdentifier();
                if (!procid.equals(pi) || breakpoint.getLineNumber() != lineNumber) continue;
                return breakpoint;
            }
            catch (CoreException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public static List findAllLineBreakpoint(ProcIdentifier procid, int lineNumber) {
        ArrayList<SPLineBreakpoint> ret = new ArrayList<SPLineBreakpoint>();
        String modelId = SPDebugModelUtil.getModelIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        for (int i = 0; i < breakpoints.length; ++i) {
            SPLineBreakpoint breakpoint;
            IMarker marker;
            if (!(breakpoints[i] instanceof SPLineBreakpoint) || (marker = (breakpoint = (SPLineBreakpoint)breakpoints[i]).getMarker()) == null || !marker.exists()) continue;
            try {
                ProcIdentifier pi = breakpoint.getProcIdentifier();
                if (!procid.equals(pi) || breakpoint.getLineNumber() != lineNumber) continue;
                ret.add(breakpoint);
                continue;
            }
            catch (CoreException ex) {
                // empty catch block
            }
        }
        return ret;
    }

    public static boolean isSPBreakpointMarker(IMarker marker, ProcIdentifier proc) {
        try {
            String type = marker.getType();
            if (SPLineBreakpoint.MARKER_TYPE.equals(type)) {
                String str = marker.getAttribute(SPLineBreakpoint.ATTR_PROCIDENTIFIER, "");
                try {
                    ProcIdentifier id = ProcIdentifierImpl.decode((String)str);
                    return proc.equals(id);
                }
                catch (ParseException ex) {
                    DebuggerCorePlugin.getDefault().log(ex);
                    return false;
                }
            }
            return false;
        }
        catch (CoreException ex) {
            DebuggerCorePlugin.getDefault().log(ex);
            return false;
        }
    }

    public static boolean isSPBreakpointMarkerDelta(IMarkerDelta markerDelta, ProcIdentifier identifier) {
        String type = markerDelta.getType();
        if (SPLineBreakpoint.MARKER_TYPE.equals(type)) {
            String str = markerDelta.getAttribute(SPLineBreakpoint.ATTR_PROCIDENTIFIER, "");
            try {
                ProcIdentifier id = ProcIdentifierImpl.decode((String)str);
                return identifier.equals(id);
            }
            catch (ParseException ex) {
                DebuggerCorePlugin.getDefault().log(ex);
                return false;
            }
        }
        return false;
    }

    public static boolean supportCondition(SPLineBreakpoint bp) throws CoreException {
        return false;
    }

    public static List findAllSPLineBreakpointForSP(ProcIdentifier procid) {
        ArrayList<SPLineBreakpoint> ret = new ArrayList<SPLineBreakpoint>();
        String modelId = SPDebugModelUtil.getModelIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        for (int i = 0; i < breakpoints.length; ++i) {
            if (!(breakpoints[i] instanceof SPLineBreakpoint)) continue;
            SPLineBreakpoint breakpoint = (SPLineBreakpoint)breakpoints[i];
            try {
                ProcIdentifier pi = breakpoint.getProcIdentifier();
                if (!procid.equals(pi)) continue;
                ret.add(breakpoint);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return ret;
    }

    public static void removeAllBreakpointForSP(ProcIdentifier procid) {
        List list = SPDebugModelUtil.findAllSPLineBreakpointForSP(procid);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            IBreakpoint bp = (IBreakpoint)list.get(i);
            try {
                bp.delete();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

