/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;

public class SQLEditorStorage
implements IEncodedStorage {
    private InputStream fContents;
    private String fName;
    private String contentsString;

    public SQLEditorStorage(String source) {
        this(SQLEditorResources.SQLEditorStorage_default_name, source);
    }

    public SQLEditorStorage(String name, String source) {
        this.setName(name);
        try {
            this.setContents(new ByteArrayInputStream(source.getBytes(this.getCharset())));
        }
        catch (UnsupportedEncodingException e) {
            this.setContents(new ByteArrayInputStream(source.getBytes()));
        }
    }

    public Object getAdapter(Class key) {
        return null;
    }

    public InputStream getContents() {
        return this.fContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getContentsString() {
        if (this.contentsString != null) return this.contentsString;
        this.contentsString = "";
        InputStream contentsStream = this.getContents();
        Reader in = null;
        in = new BufferedReader(new InputStreamReader(contentsStream, this.getCharset()));
        StringBuffer buffer = new StringBuffer();
        char[] readBuffer = new char[2048];
        int n = in.read(readBuffer);
        while (n > 0) {
            buffer.append(readBuffer, 0, n);
            n = in.read(readBuffer);
        }
        this.contentsString = buffer.toString();
        Object var7_7 = null;
        if (in == null) return this.contentsString;
        try {
            in.close();
            return this.contentsString;
        }
        catch (IOException x) {}
        return this.contentsString;
        {
            catch (Exception exception) {
                Object var7_8 = null;
                if (in == null) return this.contentsString;
                try {
                    in.close();
                    return this.contentsString;
                }
                catch (IOException x) {}
                return this.contentsString;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException x) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public IPath getFullPath() {
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setContents(InputStream contents) {
        this.fContents = contents;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getCharset() {
        return ResourcesPlugin.getEncoding();
    }
}

