/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.plan;

import java.util.HashMap;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.plan.BaseExplainAction;
import org.eclipse.datatools.sqltools.sqleditor.plan.Images;
import org.eclipse.datatools.sqltools.sqleditor.plan.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class ExplainSQLActionDelegate
extends BaseExplainAction
implements ISelectionChangedListener,
IUpdate {
    protected SQLEditor _sqlEditor;

    public ExplainSQLActionDelegate(SQLEditor targetEditor) {
        this.setText(Messages.getString("ExplainSQLActionDelegate.action_title"));
        this.setToolTipText(Messages.getString("ExplainSQLActionDelegate.action_tooltip"));
        this.setImageDescriptor(Images.DESC_EXPLAIN_SQL);
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.ExplainSQLAction");
        this.setActiveEditor(targetEditor);
        targetEditor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.datatools.sqltools.sqleditor.get_execution_plan_action");
    }

    public void setActiveEditor(SQLEditor targetEditor) {
        this._sqlEditor = targetEditor;
    }

    public void update() {
        this.setEnabled(this._sqlEditor != null && this._sqlEditor.isConnected() && super.canBeEnabled());
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._sqlEditor == null ? null : this._sqlEditor.getDatabaseIdentifier();
    }

    public String getSQLStatements() {
        String orignalSql = this._sqlEditor == null ? null : this._sqlEditor.getTargetText();
        return orignalSql;
    }

    public Runnable getPostRun() {
        Runnable postRun = new Runnable(){

            public void run() {
                ExplainSQLActionDelegate.this._sqlEditor.getEditorSite().getPage().activate((IWorkbenchPart)ExplainSQLActionDelegate.this._sqlEditor);
            }
        };
        return postRun;
    }

    protected HashMap getVariableDeclarations() {
        ITextSelection _selection = (ITextSelection)this._sqlEditor.getSelectionProvider().getSelection();
        int start = 0;
        int length = 0;
        if (_selection == null) {
            _selection = (ITextSelection)this._sqlEditor.getSelectionProvider().getSelection();
        }
        if (_selection != null && !_selection.isEmpty()) {
            start = _selection.getOffset();
            length = _selection.getLength();
            if (length < 0) {
                length = -length;
                start -= length;
            }
        }
        int offset = length > 0 ? start + 1 : start;
        IDocument document = this._sqlEditor.getDocumentProvider().getDocument((Object)this._sqlEditor.getEditorInput());
        ParsingResult result = this._sqlEditor.getParsingResult();
        HashMap variables = new HashMap();
        if (result != null) {
            variables = result.getVariables(document, offset);
            HashMap sp_params = result.getParameters(document, offset);
            variables.putAll(sp_params);
        }
        return variables;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof ITextSelection) {
            this.update();
        }
    }
}

