/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.result;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ISqlDataValidator;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.Parameter;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.parameter.ParameterInOutWrapper;
import org.eclipse.datatools.sqltools.routineeditor.result.Messages;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.LaunchUI;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.datatools.sqltools.sqleditor.result.ResultSupportRunnable;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CallableSQLResultRunnable
extends ResultSupportRunnable {
    protected Connection _connection;
    protected String _sql;
    protected String _detailSql;
    protected boolean _closeCon;
    protected IConnectionTracker _tracker;
    protected ILaunchConfiguration _configuration;
    protected ParameterInOutWrapper[] _pws;
    protected String _procName;
    protected OperationCommand _operationCommand;

    public CallableSQLResultRunnable(Connection con, ILaunchConfiguration configuration, boolean closeCon, IConnectionTracker tracker, DatabaseIdentifier databaseIdentifier) throws CoreException, SQLException, NoSuchProfileException {
        super(null, null, databaseIdentifier);
        this._connection = con;
        this._configuration = configuration;
        this._sql = LaunchHelper.constructFinalCallSQLString(configuration);
        this._detailSql = LaunchHelper.constructFinalCallDetailSQLString(configuration);
        this._closeCon = closeCon;
        this._tracker = tracker;
    }

    protected Connection getConnection() {
        return this._connection;
    }

    protected OperationCommand getOperationCommand() {
        if (this._operationCommand == null) {
            this._operationCommand = new OperationCommand(1, this._detailSql, "Routine Editor", this._databaseIdentifier.getProfileName(), this._databaseIdentifier.getDBname());
        }
        return this._operationCommand;
    }

    protected void getStatementOutParam(Statement stmt, ParameterInOutWrapper[] pws) {
        if (!(stmt instanceof CallableStatement)) {
            return;
        }
        CallableStatement cstmt = (CallableStatement)stmt;
        if (cstmt == null || pws == null) {
            return;
        }
        int j = 0;
        for (int i = 0; i < pws.length; ++i) {
            int sqlType = pws[i].getParameterDescriptor().getSqlDataType();
            int paramType = pws[i].getParameterDescriptor().getParmType();
            String name = pws[i].getParameterDescriptor().getName();
            if (paramType == 0) {
                ++j;
                continue;
            }
            if (paramType != 1 && paramType != 2) continue;
            if (name.equals(this._procName)) {
                pws[i].setOutValue(pws[0].getOutValue());
                continue;
            }
            ++j;
            try {
                String outValue = "0x";
                Object o = cstmt.getObject(j);
                if (o != null) {
                    if (o instanceof byte[]) {
                        byte[] os = (byte[])o;
                        outValue = SQLUtil.toHexString((byte[])os);
                    } else {
                        outValue = o.toString();
                    }
                }
                pws[i].setOutValue(outValue);
                continue;
            }
            catch (SQLException e1) {
                RoutineEditorActivator.getDefault().log(Messages.CallableSQLResultRunnable_getStatementOutParam_debug, e1);
                continue;
            }
            catch (NumberFormatException e1) {
                RoutineEditorActivator.getDefault().log(Messages.CallableSQLResultRunnable_getStatementOutParam_debug, e1);
            }
        }
    }

    protected void registerOutParameter(Statement stmt, ParameterInOutWrapper[] pws) throws SQLException {
        if (!(stmt instanceof CallableStatement)) {
            return;
        }
        CallableStatement cstmt = (CallableStatement)stmt;
        if (cstmt == null || pws == null) {
            return;
        }
        int j = 0;
        for (int i = 0; i < pws.length; ++i) {
            int sqlType = pws[i].getParameterDescriptor().getSqlDataType();
            String sqlTypeName = pws[i].getParameterDescriptor().getTypeName();
            int paramType = pws[i].getParameterDescriptor().getParmType();
            String paramTypeName = pws[i].getParameterDescriptor().getParamTypeAsString();
            String name = pws[i].getParameterDescriptor().getName();
            if (paramType == 0) {
                ++j;
                continue;
            }
            if (paramType != 1 && paramType != 2 || name.equals(this._procName)) continue;
            cstmt.registerOutParameter(++j, sqlType);
        }
    }

    protected void setInParameter(Statement stmt, ParameterInOutWrapper[] pws) throws SQLException {
        if (!(stmt instanceof CallableStatement)) {
            return;
        }
        CallableStatement cstmt = (CallableStatement)stmt;
        if (cstmt == null || pws == null) {
            return;
        }
        int j = 0;
        int k = 0;
        List values = null;
        try {
            values = LaunchHelper.readParameterList(this._configuration);
        }
        catch (CoreException e) {
            RoutineEditorActivator.getDefault().log(e);
        }
        DBHelper helper = SQLToolsFacade.getConfiguration((DatabaseIdentifier)this.getDatabaseIdentifier(), null).getDBHelper();
        for (int i = 0; i < pws.length; ++i) {
            int sqlType = pws[i].getParameterDescriptor().getSqlDataType();
            int paramType = pws[i].getParameterDescriptor().getParmType();
            if (helper != null) {
                paramType = helper.getCorrectParamType(paramType);
            }
            String paramTypeName = pws[i].getParameterDescriptor().getParamTypeAsString();
            String name = pws[i].getParameterDescriptor().getName();
            if (paramType == 1) {
                ++j;
                continue;
            }
            if (paramType != 0 && paramType != 2) continue;
            ++j;
            String value = null;
            if (values != null && k < values.size()) {
                value = (String)values.get(k++);
            }
            pws[i].setInValue(value);
            if (value == null) {
                cstmt.setNull(j, sqlType);
                continue;
            }
            Object v = null;
            try {
                ISqlDataValidator validator = SQLToolsFacade.getConfiguration((DatabaseIdentifier)this.getDatabaseIdentifier(), null).getSQLDataService().getSQLDataValidator(this.getDatabaseIdentifier());
                v = validator.convert(pws[i].getParameterDescriptor().getTypeName(), value, this.getDatabaseIdentifier());
            }
            catch (Exception e1) {
                v = value;
            }
            try {
                cstmt.setObject(j, v, sqlType);
                continue;
            }
            catch (Exception e) {
                cstmt.setObject(j, v);
            }
        }
    }

    protected Statement prepareStatement(Connection connection) throws SQLException {
        CallableStatement cstmt = connection.prepareCall(this._sql);
        if (this._configuration != null) {
            try {
                ProcIdentifier proc = LaunchHelper.readProcIdentifier(this._configuration);
                if (proc != null) {
                    this._procName = proc.getProcName();
                    this._pws = LaunchUI.getAllParameterWrappersByOrder(proc);
                    this.setInParameter(cstmt, this._pws);
                    this.registerOutParameter(cstmt, this._pws);
                }
            }
            catch (NoSuchProfileException e1) {
                RoutineEditorActivator.getDefault().log(Messages.CallableSQLResultRunnable_prepareStatement, e1);
            }
            catch (CoreException e) {
                RoutineEditorActivator.getDefault().log(Messages.CallableSQLResultRunnable_prepareStatement, e);
            }
        }
        return cstmt;
    }

    protected boolean runStatement(Statement stmt) throws SQLException {
        if (stmt != null && stmt instanceof CallableStatement) {
            CallableStatement cstmt = (CallableStatement)stmt;
            return cstmt.execute();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleSuccess(boolean moreResult) {
        if (this.isTerminated() || this.isCanceled()) {
            return false;
        }
        this.getStatementOutParam(this._stmt, this._pws);
        OperationCommand operationCommand = this.getOperationCommand();
        synchronized (operationCommand) {
            this.resultsViewAPI.showParameters(this.getOperationCommand(), this.convert(this._pws));
        }
        return super.handleSuccess(moreResult);
    }

    private List convert(ParameterInOutWrapper[] pws) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (int i = 0; i < pws.length; ++i) {
            ParameterDescriptor pd = pws[i].getParameterDescriptor();
            Parameter param = new Parameter(pd.getName(), pd.getParamTypeAsString(), pws[i].getInValue(), pd.getTypeName());
            params.add(param);
        }
        return params;
    }

    protected void handleEnd(Connection connection, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (connection != null && !this.isTerminated() && !this.isCanceled() && this._closeCon) {
                ProfileUtil.closeConnection((String)this._databaseIdentifier.getProfileName(), (String)this._databaseIdentifier.getDBname(), (Connection)connection);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._closeCon && this._tracker != null) {
            this._tracker.connectionClosed();
        }
    }

    public static char byteToChar(byte[] b) {
        int s = 0;
        s = b[0] > 0 ? (s += b[0]) : (s += 256 + b[0]);
        s *= 256;
        s = b[1] > 0 ? (s += b[1]) : (s += 256 + b[1]);
        char ch = (char)s;
        return ch;
    }

    public ILaunchConfiguration getConfiguration() {
        return this._configuration;
    }
}

