/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;

public class RoutineUtil {
    public static String getCallableStatementPrefix(int type) {
        String prefix = "";
        switch (type) {
            case 0: {
                prefix = "call ";
                break;
            }
            case 1: {
                prefix = "select ";
                break;
            }
            case 2: {
                prefix = "TRIGGER EVENT ";
            }
        }
        return prefix;
    }

    public static String constructCALLSPUDFString(ProcIdentifier proc, List values, ParameterDescriptor[] pds, boolean quoted_id) {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("{?=");
        int type = proc == null ? 0 : proc.getType();
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName((String)proc.getDatabaseIdentifier().getProfileName());
        buffer.append(config.getExecutionService().getCallableStatementPrefix(proc.getType()));
        String procName = null;
        if (proc != null) {
            buffer.append(proc.getCallableString(quoted_id));
            procName = proc.getProcName();
        }
        if (pds != null && pds.length > 0) {
            if (type == 1 || type == 0) {
                buffer.append("(");
            }
            int j = 0;
            for (int i = 0; i < pds.length; ++i) {
                String name = pds[i].getName();
                if (name.equals(procName)) continue;
                if (j != 0) {
                    buffer.append(",?");
                } else {
                    buffer.append("?");
                }
                ++j;
            }
            if (type == 1 || type == 0) {
                buffer.append(")");
            }
        } else {
            buffer.append("()");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static String constructDetailCALLSPUDFString(ProcIdentifier proc, List values, ParameterDescriptor[] pds, boolean quoted_id) {
        StringBuffer buffer = new StringBuffer(20);
        int type = proc == null ? 0 : proc.getType();
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName((String)proc.getDatabaseIdentifier().getProfileName());
        buffer.append(config.getExecutionService().getCallableStatementPrefix(proc.getType()));
        String LINESEPARATOR = System.getProperty("line.separator");
        String procName = null;
        if (proc != null) {
            buffer.append(proc.getCallableString(quoted_id));
            procName = proc.getProcName();
        }
        if (pds != null && pds.length > 0) {
            if (type == 1 || type == 0) {
                buffer.append("(");
            }
            int j = 0;
            int k = 0;
            for (int i = 0; i < pds.length; ++i) {
                String name = pds[i].getName();
                String prefix = "";
                if (pds[i].getParmType() == 0 || pds[i].getParmType() == 2) {
                    String value = null;
                    if (values != null && values.size() >= k + 1) {
                        value = (String)values.get(k++);
                    }
                    if (name.equals(procName)) continue;
                    if (value != null && pds[i].isStringType() && SQLUtil.findQuotes((String)value) == 0) {
                        value = SQLUtil.quote((String)value, (char)'\'');
                    }
                    prefix = j != 0 ? "," : "";
                    buffer.append(prefix + LINESEPARATOR + "     " + pds[i].getName() + "=" + value + " " + pds[i].getTypeName() + " " + pds[i].getParamTypeAsString());
                    ++j;
                }
                if (pds[i].getParmType() != 1 || name.equals(procName)) continue;
                String paramType = "OUT";
                prefix = j != 0 ? "," : "";
                buffer.append(prefix + LINESEPARATOR + "     " + pds[i].getName() + " " + pds[i].getTypeName() + " " + paramType);
                ++j;
            }
            if (type == 1 || type == 0) {
                buffer.append(")");
            }
        }
        return buffer.toString();
    }

    public static String constructSPUDFString(ProcIdentifier proc, List values, ParameterDescriptor[] pds, boolean quoted_id) {
        StringBuffer buffer = new StringBuffer(20);
        int type = proc == null ? 0 : proc.getType();
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName((String)proc.getDatabaseIdentifier().getProfileName());
        buffer.append(config.getExecutionService().getCallableStatementPrefix(proc.getType()));
        if (proc != null) {
            buffer.append(proc.getCallableString(quoted_id));
        }
        buffer.append(" ");
        if (type == 1) {
            buffer.append("(");
        }
        if (pds != null && pds.length > 0) {
            for (int i = 0; i < pds.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                if (values == null || values.size() <= i || values.get(i) == null) {
                    buffer.append("null");
                    continue;
                }
                if (pds[i].isStringType() && SQLUtil.findQuotes((String)values.get(i).toString()) == 0) {
                    buffer.append(SQLUtil.quote((String)((String)values.get(i)), (char)'\''));
                    continue;
                }
                buffer.append(values.get(i));
            }
        }
        if (type == 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static String constructTriggerEventString(ProcIdentifier proc, Map values, boolean quoted_id) {
        StringBuffer sb = new StringBuffer("TRIGGER EVENT ");
        if (proc != null) {
            if (quoted_id) {
                sb.append(SQLUtil.quote((String)proc.getProcName(), (char)'\"'));
            } else {
                sb.append(proc.getProcName());
            }
        }
        if (values != null && values.size() > 0) {
            sb.append("(");
            Iterator iter = values.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String value = (String)values.get(name);
                sb.append("\"" + name + "\"").append("=").append("'" + value + "'").append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        }
        return sb.toString();
    }
}

