/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.core.IResultManagerListener;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.model.ResultInstance;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;

public class ResultManager
implements IResultManager {
    private static final long serialVersionUID = -344302636933874156L;
    private transient ListenerList _listeners = new ListenerList();
    private HashMap _maps = new HashMap();
    private List _results = new ArrayList();

    public void addResultManagerListener(IResultManagerListener listener) {
        this._listeners.add((Object)listener);
    }

    public void newSubResultCreated(OperationCommand operation, IResultInstance instance) {
        this._maps.put(operation, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultInstance createNewResultInstance(OperationCommand operation, Runnable terminateHandler) {
        ResultInstance instance = new ResultInstance(this, operation, terminateHandler);
        List list = this._results;
        synchronized (list) {
            this._results.add(instance);
            this._maps.put(operation, instance);
        }
        this.fireAdded(instance);
        return instance;
    }

    protected void fireAdded(IResultInstance instance) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).resultInstanceCreated(instance);
            ++i;
        }
    }

    protected void fireAllRemoved() {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).allResultInstancesRemoved();
            ++i;
        }
    }

    public void fireAppended(IResultInstance instance, ResultItem r, int index) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).resultInstanceAppended(instance, r, index);
            ++i;
        }
    }

    public void fireInstanceReset(IResultInstance instance) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).resultInstanceReset(instance);
            ++i;
        }
    }

    public void fireParametersShow(IResultInstance instance, List params) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).parametersShow(instance, params);
            ++i;
        }
    }

    protected void fireRemoved(IResultInstance instance) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).resultInstanceRemoved(instance);
            ++i;
        }
    }

    protected void fireRemoved(IResultInstance[] instances) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).resultInstancesRemoved(instances);
            ++i;
        }
    }

    public void fireStatusUpdated(IResultInstance instance) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).resultInstanceStatusUpdated(instance);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResultInstance[] getAllResults() {
        List list = this._results;
        synchronized (list) {
            return this._results.toArray(new IResultInstance[this._results.size()]);
        }
    }

    public IResultInstance getInstance(OperationCommand cmd) {
        return (IResultInstance)this._maps.get(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllFinished() {
        boolean removed = false;
        List list = this._results;
        synchronized (list) {
            this._maps.clear();
            Iterator iter = this._results.iterator();
            while (iter.hasNext()) {
                IResultInstance instance = (IResultInstance)iter.next();
                if (!instance.isFinished()) continue;
                iter.remove();
                removed = true;
                instance.dispose();
            }
        }
        if (removed) {
            this.fireAllRemoved();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultInstance(IResultInstance instance) {
        boolean removed;
        List list = this._results;
        synchronized (list) {
            removed = this._results.remove(instance);
            this._maps.remove(instance.getOperationCommand());
            instance.dispose();
        }
        if (removed) {
            this.fireRemoved(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultInstances(IResultInstance[] instances) {
        if (instances != null) {
            boolean removed = false;
            List list = this._results;
            synchronized (list) {
                int i = 0;
                while (i < instances.length) {
                    if (instances[i] != null) {
                        boolean succeeded = this._results.remove(instances[i]);
                        instances[i].dispose();
                        this._maps.remove(instances[i].getOperationCommand());
                        if (succeeded && !removed) {
                            removed = true;
                        }
                    }
                    ++i;
                }
            }
            if (removed) {
                this.fireRemoved(instances);
            }
        }
    }

    public void removeResultManagerListener(IResultManagerListener listener) {
        this._listeners.remove((Object)listener);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this._listeners = new ListenerList();
    }
}

