/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.viewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.ui.viewer.CommonAction;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class TextResultViewer {
    private SourceViewer _viewer;
    private IUndoManager _undoMgr;
    private static final int UNDO_LEVEL = 15;
    private Map _actions = new HashMap();
    private static final String GROUP_SELECT = "select_group";
    private static final String GROUP_HOOKED = "hook_group";
    private static final String FONT_STYLE = "Courier New";
    private static final String FIND_REPLACE_ACTION_PREFIX = "find_replace_action_";
    private static final int FONT_SIZE = 10;
    private MenuManager _contextMenuMgr;
    private ArrayList _hookedItems;
    private Action _undo;
    private Action _redo;
    private boolean _isFindReplaceActionAdded = false;

    public TextResultViewer(Composite parent, int style, ArrayList hookedActions) {
        this._hookedItems = hookedActions;
        this._undoMgr = new DefaultUndoManager(15);
        IVerticalRuler ruler = null;
        this._viewer = new SourceViewer(parent, ruler, style);
        this.configureViewer();
    }

    public void initializeCommonActions() {
        CommonAction action = new CommonAction(this._viewer.getTextOperationTarget(), 3, Messages.CommonTextViewer_action_cut);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        this._actions.put(ITextEditorActionConstants.CUT, action);
        action = new CommonAction(this._viewer.getTextOperationTarget(), 4, Messages.CommonTextViewer_action_copy);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this._actions.put(ITextEditorActionConstants.COPY, action);
        action = new CommonAction(this._viewer.getTextOperationTarget(), 5, Messages.CommonTextViewer_action_paste);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this._actions.put(ITextEditorActionConstants.PASTE, action);
        action = new CommonAction(this._viewer.getTextOperationTarget(), 6, Messages.CommonTextViewer_action_delete);
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this._actions.put(ITextEditorActionConstants.DELETE, action);
        action = new CommonAction(this._viewer.getTextOperationTarget(), 7, Messages.CommonTextViewer_action_selectall);
        this._actions.put(ITextEditorActionConstants.SELECT_ALL, action);
        this._undoMgr.connect((ITextViewer)this._viewer);
        this._undo = new UndoAction(this._undoMgr);
        this._redo = new RedoAction(this._undoMgr);
        this._actions.put(ITextEditorActionConstants.UNDO, this._undo);
        this._actions.put(ITextEditorActionConstants.REDO, this._redo);
    }

    public void configureViewer() {
        this._viewer.getTextWidget().setWordWrap(false);
        FontData fd = new FontData(FONT_STYLE, 10, 0);
        final Font font = new Font((Device)this._viewer.getTextWidget().getDisplay(), fd);
        this._viewer.getTextWidget().setFont(font);
        this._viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (font != null & !font.isDisposed()) {
                    font.dispose();
                }
            }
        });
        this._viewer.getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!TextResultViewer.this._isFindReplaceActionAdded) {
                    IViewPart view = ResultsViewPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.datatools.sqltools.result.resultView");
                    FindReplaceAction action = new FindReplaceAction(ResourceBundle.getBundle("org.eclipse.datatools.sqltools.result.internal.PluginResources"), TextResultViewer.FIND_REPLACE_ACTION_PREFIX, (IWorkbenchPart)view);
                    action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
                    TextResultViewer.this._actions.put(ITextEditorActionConstants.FIND, action);
                    TextResultViewer.this._contextMenuMgr.appendToGroup("group.find", (IAction)TextResultViewer.this._actions.get(ITextEditorActionConstants.FIND));
                    TextResultViewer.this._isFindReplaceActionAdded = true;
                }
            }
        });
        this._viewer.configure(new SourceViewerConfiguration(){});
        this.addContextMenu();
    }

    private void addContextMenu() {
        this.initializeCommonActions();
        this._contextMenuMgr = new MenuManager("#contextMenu");
        Menu contextMenu = this._contextMenuMgr.createContextMenu((Control)this._viewer.getTextWidget());
        this._contextMenuMgr.add((IAction)this._undo);
        this._contextMenuMgr.add((IAction)this._redo);
        this._contextMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                Iterator iter = TextResultViewer.this._actions.values().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof IUpdate)) continue;
                    IUpdate action = (IUpdate)obj;
                    action.update();
                }
            }
        });
        this._contextMenuMgr.add((IContributionItem)new Separator("group.edit"));
        this._contextMenuMgr.appendToGroup("group.edit", (IAction)this._actions.get(ITextEditorActionConstants.CUT));
        this._contextMenuMgr.appendToGroup("group.edit", (IAction)this._actions.get(ITextEditorActionConstants.COPY));
        this._contextMenuMgr.appendToGroup("group.edit", (IAction)this._actions.get(ITextEditorActionConstants.PASTE));
        this._contextMenuMgr.appendToGroup("group.edit", (IAction)this._actions.get(ITextEditorActionConstants.DELETE));
        this._contextMenuMgr.add((IContributionItem)new Separator(GROUP_SELECT));
        this._contextMenuMgr.appendToGroup(GROUP_SELECT, (IAction)this._actions.get(ITextEditorActionConstants.SELECT_ALL));
        this._contextMenuMgr.add((IContributionItem)new Separator("group.find"));
        this.addHookedContextMenuItems();
        this._viewer.getTextWidget().setMenu(contextMenu);
        this._viewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                CommonAction action;
                if (event.keyCode == 122 && (event.stateMask & 0x40000) != 0) {
                    TextResultViewer.this._undo.run();
                }
                if (event.keyCode == 121 && (event.stateMask & 0x40000) != 0) {
                    TextResultViewer.this._redo.run();
                }
                if (event.keyCode == 97 && (event.stateMask & 0x40000) != 0 && (action = (CommonAction)((Object)TextResultViewer.this._actions.get(ITextEditorActionConstants.SELECT_ALL))) != null) {
                    action.run();
                }
                if (event.keyCode == 102 && (event.stateMask & 0x40000) != 0 && (action = (IAction)TextResultViewer.this._actions.get(ITextEditorActionConstants.FIND)) != null) {
                    if (action instanceof IUpdate) {
                        ((IUpdate)action).update();
                    }
                    action.run();
                }
            }
        });
    }

    public SourceViewer getViewer() {
        return this._viewer;
    }

    public void resetUndoMgr() {
        this._undoMgr.reset();
    }

    public void addHookedContextMenuItems() {
        if (this._hookedItems != null) {
            if (this._hookedItems.size() > 0) {
                this._contextMenuMgr.add((IContributionItem)new Separator(GROUP_HOOKED));
            }
            Iterator iter = this._hookedItems.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof IAction) {
                    IAction action = (IAction)obj;
                    this._contextMenuMgr.appendToGroup(GROUP_HOOKED, action);
                    continue;
                }
                if (!(obj instanceof IContributionItem)) continue;
                IContributionItem item = (IContributionItem)obj;
                this._contextMenuMgr.appendToGroup(GROUP_HOOKED, item);
            }
        }
    }

    public class RedoAction
    extends Action
    implements IUpdate {
        private IUndoManager _manager;

        public RedoAction(IUndoManager manager) {
            this.setText(Messages.RedoAction_title);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
            this._manager = manager;
        }

        public void run() {
            this._manager.redo();
        }

        public void update() {
            if (this._manager.redoable()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    public class UndoAction
    extends Action
    implements IUpdate {
        private IUndoManager _manager;

        public UndoAction(IUndoManager manager) {
            this.setText(Messages.UndoAction_title);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO"));
            this._manager = manager;
        }

        public void run() {
            this._manager.undo();
        }

        public void update() {
            if (this._manager.undoable()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

