/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.Arrays;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingElement;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.DataTypeUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ColumnMappingDialog
extends TrayDialog {
    private String title;
    private Combo typeCombo;
    private String columnName;
    private String xpath;
    private String type;
    private Text columnNameText;
    private Text xPathExpressionText;
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString("datatypes.dateTime"), Messages.getString("datatypes.decimal"), Messages.getString("datatypes.float"), Messages.getString("datatypes.integer"), Messages.getString("datatypes.date"), Messages.getString("datatypes.time"), Messages.getString("datatypes.string"), Messages.getString("datatypes.boolean")};

    public ColumnMappingDialog(Shell parent, String title, String selectedItem, String xpath, int dataType) {
        super(parent);
        this.title = title;
        this.columnName = selectedItem == null ? "" : selectedItem;
        this.xpath = xpath == null ? "" : xpath;
        this.type = DataTypeUtil.getDataTypeDisplayName(dataType);
        Arrays.sort(dataTypeDisplayNames);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("ColumnMappingDialog.info.columnName"));
        this.columnNameText = new Text(composite, 2048);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.widthHint = 300;
        this.columnNameText.setLayoutData((Object)data);
        this.columnNameText.setText(this.columnName);
        Label label2 = new Label(composite, 0);
        label2.setText(Messages.getString("ColumnMappingDialog.info.xPath"));
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.xPathExpressionText = new Text(composite, 2048);
        this.xPathExpressionText.setLayoutData((Object)data);
        this.xPathExpressionText.setText(this.xpath);
        Label label3 = new Label(composite, 0);
        label3.setText(Messages.getString("ColumnMappingDialog.info.dataType"));
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.typeCombo = new Combo(composite, 12);
        int typeIndex = -1;
        int stringIndex = -1;
        int i = 0;
        while (i < dataTypeDisplayNames.length) {
            this.typeCombo.add(dataTypeDisplayNames[i]);
            if (dataTypeDisplayNames[i].equals(this.type)) {
                typeIndex = i;
            } else if (dataTypeDisplayNames[i].equals(Messages.getString("datatypes.string"))) {
                stringIndex = i;
            }
            ++i;
        }
        if (typeIndex == -1) {
            typeIndex = stringIndex;
        }
        this.typeCombo.setLayoutData((Object)data);
        this.typeCombo.select(typeIndex);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ColumnMappingDialog.this.typeCombo.getSelectionIndex();
                ColumnMappingDialog.this.columnName = ColumnMappingDialog.this.typeCombo.getItem(index);
            }
        });
        XMLRelationInfoUtil.setSystemHelp((Control)composite, "org.eclipse.datatools.oda.cshelp.Dialog_ColumnMapping_ID");
        return composite;
    }

    ColumnMappingElement getColumnMapping() {
        ColumnMappingElement columnEle = new ColumnMappingElement();
        columnEle.setColumnName(this.columnName);
        columnEle.setXPath(this.xpath);
        columnEle.setType(this.type);
        return columnEle;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.columnName = this.columnNameText.getText();
            this.xpath = this.xPathExpressionText.getText();
            this.type = this.typeCombo.getItem(this.typeCombo.getSelectionIndex());
        }
        super.buttonPressed(buttonId);
    }
}

