/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCSchemaLoader;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseDBSpace;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseEvent;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseGroup;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBasePreDefinedType;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseSchema;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseUser;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseWebService;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.EncryptionInfo;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.JavaSupportType;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDBSpace;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseEvent;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseGroup;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseUser;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASAWebService;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseasabasesqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class SybaseASABaseDatabaseLoader {
    protected ICatalogObject catalogObject;
    protected SybaseASABaseDatabase database;
    private SoftReference schemaLoaderRef;

    public SybaseASABaseDatabaseLoader(SybaseASABaseDatabase catalogDatabase) {
        this.catalogObject = (ICatalogObject)catalogDatabase;
        this.database = catalogDatabase;
    }

    protected JDBCSchemaLoader createSchemaLoader() {
        return new ASABaseSchemaLoader(this.catalogObject);
    }

    protected SybaseASABaseDBSpace createCatalogDBSpace() {
        return new SybaseASACatalogBaseDBSpace();
    }

    protected SybaseASABaseGroup createCatalogGroup() {
        return new SybaseASACatalogBaseGroup(this.catalogObject);
    }

    protected SybaseASABaseUser createCatalogUser() {
        return new SybaseASACatalogBaseUser(this.catalogObject);
    }

    protected SybaseASABaseEvent createCatalogEvent() {
        return new SybaseASACatalogBaseEvent();
    }

    public final void loadSchemas(EList schemaConstainmentList) {
        try {
            boolean deliver = this.database.eDeliver();
            this.database.eSetDeliver(false);
            ArrayList existingSchemas = new ArrayList(schemaConstainmentList.size());
            existingSchemas.addAll(schemaConstainmentList);
            this.getSchemaLoader().clearSchemas((List)schemaConstainmentList);
            this.getSchemaLoader().loadSchemas((List)schemaConstainmentList, existingSchemas);
            this.database.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    private JDBCSchemaLoader getSchemaLoader() {
        if (this.schemaLoaderRef == null || this.schemaLoaderRef.get() == null) {
            this.schemaLoaderRef = new SoftReference<JDBCSchemaLoader>(this.createSchemaLoader());
        }
        return (JDBCSchemaLoader)this.schemaLoaderRef.get();
    }

    public void loadWebServices(EList webserviceConstraintmentList) {
        boolean deliver = this.database.eDeliver();
        this.database.eSetDeliver(false);
        webserviceConstraintmentList.clear();
        try {
            ResultSet r = this.getWSs();
            if (r != null) {
                while (r.next()) {
                    long serviceId = r.getLong("service_id");
                    String serviceName = r.getString("service_name");
                    String serviceType = r.getString("service_type");
                    String authRequired = r.getString("auth_required");
                    String secureRequired = r.getString("secure_required");
                    String urlPath = r.getString("url_path");
                    String userName = r.getString("User");
                    String parameter = r.getString("parameter");
                    String statement = r.getString("statement");
                    String remarks = r.getString("remarks");
                    SybaseASACatalogBaseWebService ws = new SybaseASACatalogBaseWebService();
                    if (serviceName != null) {
                        ws.setName(serviceName);
                    }
                    ws.setService_id(serviceId);
                    if (serviceType != null) {
                        ws.setService_type(serviceType);
                    }
                    if (authRequired != null) {
                        ws.setAuth_required(authRequired);
                    }
                    if (secureRequired != null) {
                        ws.setSecure_required(secureRequired);
                    }
                    if (urlPath != null) {
                        ws.setUrl_path(urlPath);
                    }
                    if (userName != null) {
                        ws.setUser_name(userName);
                    }
                    if (parameter != null) {
                        ws.setParameter(parameter);
                    }
                    if (statement != null) {
                        ws.setStatement(statement);
                    }
                    if (remarks != null) {
                        ws.getComments().add((Object)remarks);
                    }
                    if (this.hasWS(webserviceConstraintmentList, serviceId)) continue;
                    if (ws.eIsProxy()) {
                        EcoreUtil.resolve((EObject)ws, (EObject)this.database);
                    }
                    webserviceConstraintmentList.add((Object)ws);
                }
            }
            if (r != null) {
                r.close();
            }
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        this.database.eSetDeliver(deliver);
    }

    private boolean hasWS(EList list, long serviceID) {
        boolean result = false;
        int i = 0;
        while (i < list.size()) {
            SybaseASAWebService ws = (SybaseASAWebService)list.get(i);
            if (ws.getService_id() == serviceID) {
                return true;
            }
            ++i;
        }
        return result;
    }

    private ResultSet getWSs() {
        Connection connection = this.catalogObject.getConnection();
        try {
            String query = "select service_id, service_name, service_type,auth_required,secure_required, url_path, User_name(user_id)'User',parameter, statement, remarks  from syswebservice where service_type = 'SOAP' and statement like 'call%' order by service_id";
            Statement s = connection.createStatement();
            ResultSet r2 = s.executeQuery(query);
            return r2;
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
            return null;
        }
    }

    public final void loadDataTypes(EList datatypeConstainmentList) {
        boolean deliver = this.database.eDeliver();
        this.database.eSetDeliver(false);
        datatypeConstainmentList.clear();
        try {
            List list = SybaseASACatalogUtils.getDBDatatypes(this.database.getName(), this.catalogObject.getConnection());
            int i = 0;
            while (i < list.size()) {
                String typename = (String)list.get(i);
                SybaseASACatalogBasePreDefinedType datatype = new SybaseASACatalogBasePreDefinedType();
                datatype.setName(typename);
                datatypeConstainmentList.add((Object)datatype);
                ++i;
            }
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
        this.database.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void loadEvents(EList eventContainmentList) {
        boolean deliver = this.database.eDeliver();
        this.database.eSetDeliver(false);
        ArrayList existingEvents = new ArrayList(eventContainmentList.size());
        existingEvents.addAll(eventContainmentList);
        eventContainmentList.clear();
        Connection conn = this.catalogObject.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("SELECT TRIM(event_name) as event_name,TRIM(user_name) as user_name from sys.sysevent as evt, sysuserperms as up where evt.creator = up.user_id ORDER BY event_name");
                while (rs.next()) {
                    String eventName = rs.getString("event_name");
                    String creator = rs.getString("user_name");
                    Object element = SybaseASACatalogUtils.findElement(existingEvents, eventName);
                    Schema schema = (Schema)SybaseASACatalogUtils.findElement((Collection)this.database.getSchemas(), creator);
                    if (element != null) {
                        eventContainmentList.add(element);
                        ((SybaseASABaseEvent)element).setEventCreator(schema);
                        ((ICatalogObject)element).refresh();
                        continue;
                    }
                    SybaseASABaseEvent event = this.createCatalogEvent();
                    event.setName(eventName);
                    event.setEventCreator(schema);
                    eventContainmentList.add((Object)event);
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.database.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void loadAuthIds(EList authIdContainmentList) {
        boolean deliver = this.database.eDeliver();
        this.database.eSetDeliver(false);
        ArrayList existingAuths = new ArrayList(authIdContainmentList.size());
        existingAuths.addAll(authIdContainmentList);
        authIdContainmentList.clear();
        Connection conn = this.catalogObject.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("SELECT TRIM(user_name) as user_name, user_group from SYS.SYSUSERPERMS ORDER BY user_name");
                while (rs.next()) {
                    EClass clazz;
                    String authIdName = rs.getString(1);
                    boolean isGroup = rs.getString(2).equals("Y");
                    SybaseASABaseGroup id = null;
                    if (isGroup) {
                        clazz = SQLAccessControlPackage.eINSTANCE.getGroup();
                        id = (SybaseASABaseGroup)SybaseASACatalogUtils.findElement(existingAuths, authIdName, clazz);
                        if (id == null) {
                            id = this.createCatalogGroup();
                            id.setName(authIdName);
                            id.setSqlContainer((SQLObject)this.database);
                            authIdContainmentList.add((Object)id);
                            continue;
                        }
                        authIdContainmentList.add((Object)id);
                        ((ICatalogObject)id).refresh();
                        continue;
                    }
                    clazz = SQLAccessControlPackage.eINSTANCE.getUser();
                    id = (SybaseASABaseUser)SybaseASACatalogUtils.findElement(existingAuths, authIdName, clazz);
                    if (id == null) {
                        id = this.createCatalogUser();
                        id.setName(authIdName);
                        id.setSqlContainer((SQLObject)this.database);
                        authIdContainmentList.add((Object)id);
                        continue;
                    }
                    authIdContainmentList.add((Object)id);
                    ((ICatalogObject)id).refresh();
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.database.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadDbSpaces(EList dbspaceContainmentList) {
        boolean deliver = this.database.eDeliver();
        this.database.eSetDeliver(false);
        ArrayList existingDBSpaces = new ArrayList(dbspaceContainmentList.size());
        existingDBSpaces.addAll(dbspaceContainmentList);
        dbspaceContainmentList.clear();
        Connection conn = this.catalogObject.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("SELECT TRIM(dbspace_name) as dbspace_name FROM SYS.SYSFILE ORDER BY dbspace_name");
                while (rs.next()) {
                    String dbSpaceName = rs.getString(1);
                    SybaseASABaseDBSpace dbSpace = (SybaseASABaseDBSpace)SybaseASACatalogUtils.findElement(existingDBSpaces, dbSpaceName);
                    if (dbSpace == null) {
                        dbSpace = this.createCatalogDBSpace();
                        dbSpace.setName(dbSpaceName);
                        dbspaceContainmentList.add((Object)dbSpace);
                        continue;
                    }
                    dbspaceContainmentList.add((Object)dbSpace);
                    ((ICatalogObject)dbSpace).refresh();
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.database.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void loadDbInfo1() {
        boolean deliver = this.database.eDeliver();
        this.database.eSetDeliver(false);
        Connection conn = this.catalogObject.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                rs = this.createDbInfo1ResultSet(conn);
                stmt = rs.getStatement();
                while (rs.next()) {
                    this.processDbInfo1ResultSet(rs);
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.database.eSetDeliver(deliver);
    }

    protected ResultSet createDbInfo1ResultSet(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        return stmt.executeQuery("SELECT db_property('File'), db_property('LogName'), db_property('LogMirrorName'), db_property( 'PageSize'), db_property( 'Encryption'), db_property( 'CaseSensitive'), db_property( 'BlankPadding'), db_property( 'Collation' ), db_property( 'CheckSum' ), db_property( 'CaseSensitivePasswords' )");
    }

    protected void processDbInfo1ResultSet(ResultSet rs) throws SQLException {
        String fileName = rs.getString(1);
        String logFileName = rs.getString(2);
        String mirrorLogFileName = rs.getString(3);
        int pageSize = rs.getInt(4);
        String encryptionSpec = rs.getString(5);
        boolean isCaseSensitive = rs.getString(6).equalsIgnoreCase("ON");
        boolean hasBlankPadding = rs.getString(7).equalsIgnoreCase("ON");
        String collationLabel = rs.getString(8);
        boolean isCheckSum = rs.getString(9).equalsIgnoreCase("ON");
        Boolean isPasswordSensitive = null;
        if (!this.database.isBaseOnASA10()) {
            isPasswordSensitive = rs.getString(10).equalsIgnoreCase("ON");
        }
        this.database.setDatabaseFileName(fileName);
        this.database.setLogFileName(logFileName);
        this.database.setMirrorFileName(mirrorLogFileName);
        this.database.setPageSize(pageSize);
        this.database.setCaseSensitive(isCaseSensitive);
        this.database.setBlankPaddingOn(hasBlankPadding);
        this.database.setCollation(collationLabel);
        this.database.setCheckSumOn(isCheckSum);
        this.database.setPasswordCaseSensitive(isPasswordSensitive);
        EncryptionInfo encryInfo = SybaseasabasesqlmodelFactory.eINSTANCE.createEncryptionInfo();
        if (encryptionSpec == null || encryptionSpec.length() == 0 || encryptionSpec.equalsIgnoreCase("None")) {
            encryInfo = null;
        } else if (encryptionSpec.equalsIgnoreCase("Simple")) {
            encryInfo.setAlgorithm(null);
        } else if (encryptionSpec.equalsIgnoreCase("AES")) {
            encryInfo.setAlgorithm("AES");
        } else if (encryptionSpec.equalsIgnoreCase("AES_FIPS")) {
            encryInfo.setAlgorithm("AES_FIPS");
        } else if (encryptionSpec.equalsIgnoreCase("MDSR")) {
            encryInfo.setAlgorithm("MDSR");
        }
        this.database.setEncryptionInfo(encryInfo);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void loadDbInfo2() {
        boolean deliver = this.database.eDeliver();
        this.database.eSetDeliver(false);
        Connection conn = this.catalogObject.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                rs = this.createDbInfo2ResultSet(conn);
                stmt = rs.getStatement();
                while (rs.next()) {
                    this.processDbInfo2ResutSet(rs);
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.database.eSetDeliver(deliver);
    }

    protected ResultSet createDbInfo2ResultSet(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        return stmt.executeQuery("SELECT db_property( 'JDKVersion' ), IF EXISTS( SELECT jar_file FROM SYS.SYSJAR WHERE jar_name = 'ASASystem' ) THEN 'Y' ELSE 'N' ENDIF, IF EXISTS( SELECT OBJECT_ID('dbo.sp_mda')) THEN 'Y' ELSE 'N' ENDIF, IF EXISTS( SELECT OBJECT_ID('SYS.SYSCOLUMNS')) THEN 'N' ELSE 'Y' ENDIF");
    }

    protected void processDbInfo2ResutSet(ResultSet rs) throws SQLException {
        String jdkVersion1 = rs.getString(1);
        boolean isJarSupport = rs.getString(2).equalsIgnoreCase("Y");
        boolean isJconnectSupport = rs.getString(3).equalsIgnoreCase("Y");
        JavaSupportType jst = null;
        jst = jdkVersion1 != null || isJarSupport ? ("1.3".equals(jdkVersion1) ? JavaSupportType.JDK13_LITERAL : ("1.18".equals(jdkVersion1) ? JavaSupportType.JDK118_LITERAL : JavaSupportType.ON_LITERAL)) : JavaSupportType.OFF_LITERAL;
        this.database.setJavaSupport(jst);
        this.database.setJConnectOn(isJconnectSupport);
    }

    public static class ASABaseSchemaLoader
    extends JDBCSchemaLoader {
        public ASABaseSchemaLoader(ICatalogObject catalogObject) {
            super(catalogObject, null);
        }

        protected Schema createSchema() {
            return new SybaseASACatalogBaseSchema();
        }
    }
}

