/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import java.util.Comparator;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.ISQLCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;

public class SQLCompletionProposalComparator
implements Comparator {
    private static SQLCompletionProposalComparator _instance = new SQLCompletionProposalComparator();
    private boolean _orderAlphabetically = false;

    public static SQLCompletionProposalComparator getInstance() {
        return _instance;
    }

    public void setOrderAlphabetically(boolean orderAlphabetically) {
        this._orderAlphabetically = orderAlphabetically;
    }

    public int compare(Object o1, Object o2) {
        ICompletionProposal p1 = (ICompletionProposal)o1;
        ICompletionProposal p2 = (ICompletionProposal)o2;
        if (!this._orderAlphabetically) {
            int r1 = this.getRelevance(p1);
            int r2 = this.getRelevance(p2);
            int relevanceDif = r2 - r1;
            if (relevanceDif != 0) {
                return relevanceDif;
            }
        }
        return p1.getDisplayString().compareToIgnoreCase(p2.getDisplayString());
    }

    private int getRelevance(ICompletionProposal obj) {
        if (obj instanceof ISQLCompletionProposal) {
            ISQLCompletionProposal scp = (ISQLCompletionProposal)obj;
            return scp.getRelevance();
        }
        if (obj instanceof TemplateProposal) {
            TemplateProposal tp = (TemplateProposal)obj;
            return tp.getRelevance();
        }
        return 0;
    }
}

