/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.result;

import java.sql.Connection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.result.Messages;
import org.eclipse.datatools.sqltools.sqleditor.result.ResultSupportRunnable;
import org.eclipse.datatools.sqltools.sqleditor.result.SimpleSQLResultRunnable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GroupSQLResultRunnable
extends SimpleSQLResultRunnable {
    private Runnable _postRun;
    private String[] _groups;
    private Runnable _currentJob = null;
    private boolean _promptVar = false;
    private HashMap _varDefs = null;
    private String _parentDisplayName;

    public GroupSQLResultRunnable(Connection con, String[] groups, IConnectionTracker tracker, Runnable postRun, DatabaseIdentifier databaseIdentifier, boolean promptVar, HashMap varDefs) {
        super(con, "", false, tracker, null, databaseIdentifier, null);
        this._postRun = postRun;
        this._groups = groups;
        this._promptVar = promptVar;
        this._varDefs = varDefs;
    }

    public GroupSQLResultRunnable(Connection con, String[] groups, IConnectionTracker tracker, Runnable postRun, DatabaseIdentifier databaseIdentifier, boolean promptVar, HashMap varDefs, String parentDisplayName, String consumerName) {
        this(con, groups, tracker, postRun, databaseIdentifier, promptVar, varDefs);
        this._parentDisplayName = parentDisplayName;
        this._consumerName = consumerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        ResultsViewAPI resultsViewAPI;
        boolean allSucceeded;
        block33: {
            block32: {
                IStatus iStatus2;
                block31: {
                    IStatus iStatus3;
                    block30: {
                        IStatus e2;
                        block29: {
                            block28: {
                                allSucceeded = true;
                                resultsViewAPI = ResultsViewAPI.getInstance();
                                IJobManager manager = Platform.getJobManager();
                                if (monitor == null) {
                                    monitor = manager.createProgressGroup();
                                }
                                String task = Messages.GroupSQLResultRunnable_name;
                                if (this._groups.length > 1) {
                                    task = task + NLS.bind((String)"GroupSQLResultRunnable.groups", (Object[])new Object[]{"" + this._groups.length});
                                }
                                monitor.beginTask(task, this._groups.length);
                                try {
                                    try {
                                        if (this.getConnection() == null) {
                                            SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)this._databaseIdentifier.getProfileName());
                                            ConnectionService conService = f.getConnectionService();
                                            Connection conn = conService.createConnection(this._databaseIdentifier, true);
                                            this.setConnection(conn);
                                        }
                                        if (this._groups.length > 1) {
                                            resultsViewAPI.createNewInstance(this.getOperationCommand(), null);
                                        }
                                        for (int i = 0; i < this._groups.length; ++i) {
                                            OperationCommand parentCommand;
                                            OperationCommand operationCommand = parentCommand = this._groups.length > 1 ? this.getOperationCommand() : null;
                                            if (this._groups.length > 1) {
                                                resultsViewAPI.appendStatusMessage(this.getOperationCommand(), this._groups[i]);
                                                monitor.subTask(NLS.bind((String)"GroupSQLResultRunnable.group", (Object[])new Object[]{"" + i}));
                                            }
                                            SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)this._databaseIdentifier.getProfileName());
                                            this._currentJob = f.getExecutionService().createAdHocScriptRunnable(this.getConnection(), this._groups[i], false, this._tracker, monitor, this.getDatabaseIdentifier(), null, null);
                                            if (this._currentJob == null) {
                                                this._currentJob = new SimpleSQLResultRunnable(this.getConnection(), this._groups[i], false, this._tracker, monitor, this.getDatabaseIdentifier(), null);
                                            }
                                            if (!(this._currentJob instanceof ResultSupportRunnable)) continue;
                                            ResultSupportRunnable resultSupportRunnable = (ResultSupportRunnable)this._currentJob;
                                            resultSupportRunnable.setParentOperCommand(parentCommand);
                                            resultSupportRunnable.setProgressGroup(monitor, 1);
                                            resultSupportRunnable.schedule();
                                            if (this._groups.length == 1) {
                                                this._operationCommand = resultSupportRunnable.getOperationCommand();
                                            }
                                            try {
                                                resultSupportRunnable.join();
                                            }
                                            catch (InterruptedException e2) {
                                                resultsViewAPI.appendThrowable(this.getOperationCommand(), (Throwable)e2);
                                                OperationCommand operationCommand2 = resultSupportRunnable.getOperationCommand();
                                                synchronized (operationCommand2) {
                                                    resultsViewAPI.appendStatusMessage(resultSupportRunnable.getOperationCommand(), e2.getLocalizedMessage());
                                                    resultsViewAPI.updateStatus(resultSupportRunnable.getOperationCommand(), 6);
                                                }
                                            }
                                            monitor.worked(1);
                                            if (resultsViewAPI.getCurrentStatus(resultSupportRunnable.getOperationCommand()) != 3) {
                                                allSucceeded = false;
                                            }
                                            if (monitor.isCanceled()) {
                                                resultSupportRunnable.terminateExecution();
                                                resultsViewAPI.updateStatus(this.getOperationCommand(), resultsViewAPI.calculateStatus(this.getOperationCommand()));
                                                e2 = Status.CANCEL_STATUS;
                                                Object var15_16 = null;
                                                break block28;
                                            }
                                            if (resultsViewAPI.getCurrentStatus(resultSupportRunnable.getOperationCommand()) == 3 || i >= this._groups.length - 1) continue;
                                            if (resultsViewAPI.getCurrentStatus(resultSupportRunnable.getOperationCommand()) == 5) {
                                                resultsViewAPI.updateStatus(this.getOperationCommand(), resultsViewAPI.calculateStatus(this.getOperationCommand()));
                                                e2 = Status.CANCEL_STATUS;
                                                break block29;
                                            }
                                            IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
                                            String errorpm = store.getString("PreferenceConstants.EXECUTE_SQL_ERROR_MODE");
                                            if (errorpm == null || errorpm.equals("") || "PreferenceConstants.PROMPT_MODE_PROMPT".equals(errorpm)) {
                                                final ConfirmAction run = new ConfirmAction();
                                                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                                    public void run() {
                                                        run.run();
                                                    }
                                                });
                                                if (run._goon) continue;
                                                resultsViewAPI.updateStatus(this.getOperationCommand(), resultsViewAPI.calculateStatus(this.getOperationCommand()));
                                                iStatus3 = Status.CANCEL_STATUS;
                                                break block30;
                                            }
                                            if ("PreferenceConstants.PROMPT_MODE_ALWAYS".equals(errorpm)) continue;
                                            iStatus2 = Status.CANCEL_STATUS;
                                            break block31;
                                        }
                                        break block32;
                                    }
                                    catch (Exception e3) {
                                        SQLEditorPlugin.getDefault().log(e3);
                                        Object var15_21 = null;
                                        monitor.done();
                                        if (this._postRun != null) {
                                            PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
                                        }
                                        ProfileUtil.closeConnection((String)this._databaseIdentifier.getProfileName(), (String)this._databaseIdentifier.getDBname(), (Connection)this.getConnection());
                                        break block33;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var15_22 = null;
                                    monitor.done();
                                    if (this._postRun != null) {
                                        PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
                                    }
                                    ProfileUtil.closeConnection((String)this._databaseIdentifier.getProfileName(), (String)this._databaseIdentifier.getDBname(), (Connection)this.getConnection());
                                    throw throwable;
                                }
                            }
                            monitor.done();
                            if (this._postRun != null) {
                                PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
                            }
                            ProfileUtil.closeConnection((String)this._databaseIdentifier.getProfileName(), (String)this._databaseIdentifier.getDBname(), (Connection)this.getConnection());
                            return e2;
                        }
                        Object var15_17 = null;
                        monitor.done();
                        if (this._postRun != null) {
                            PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
                        }
                        ProfileUtil.closeConnection((String)this._databaseIdentifier.getProfileName(), (String)this._databaseIdentifier.getDBname(), (Connection)this.getConnection());
                        return e2;
                    }
                    Object var15_18 = null;
                    monitor.done();
                    if (this._postRun != null) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
                    }
                    ProfileUtil.closeConnection((String)this._databaseIdentifier.getProfileName(), (String)this._databaseIdentifier.getDBname(), (Connection)this.getConnection());
                    return iStatus3;
                }
                Object var15_19 = null;
                monitor.done();
                if (this._postRun != null) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
                }
                ProfileUtil.closeConnection((String)this._databaseIdentifier.getProfileName(), (String)this._databaseIdentifier.getDBname(), (Connection)this.getConnection());
                return iStatus2;
            }
            Object var15_20 = null;
            monitor.done();
            if (this._postRun != null) {
                PlatformUI.getWorkbench().getDisplay().syncExec(this._postRun);
            }
            ProfileUtil.closeConnection((String)this._databaseIdentifier.getProfileName(), (String)this._databaseIdentifier.getDBname(), (Connection)this.getConnection());
        }
        resultsViewAPI.updateStatus(this.getOperationCommand(), resultsViewAPI.calculateStatus(this.getOperationCommand()));
        if (allSucceeded) {
            iStatus = Status.OK_STATUS;
            return iStatus;
        }
        iStatus = Status.CANCEL_STATUS;
        return iStatus;
    }

    public void run() {
        this.run(null);
    }

    public OperationCommand getOperationCommand() {
        if (this._operationCommand == null) {
            String parentDspName = this._parentDisplayName == null ? Messages.GroupSQLResultRunnable_group_exec : this._parentDisplayName;
            this._operationCommand = new OperationCommand(this.getActionType(), parentDspName, this.getConsumerName(), this._databaseIdentifier.getProfileName(), this._databaseIdentifier.getDBname());
        }
        return this._operationCommand;
    }

    private final class ConfirmAction
    extends Action {
        boolean _goon = false;

        private ConfirmAction() {
        }

        public void run() {
            IPreferenceStore store = SQLEditorPlugin.getDefault().getPreferenceStore();
            MessageDialogWithToggle dlg = MessageDialogWithToggle.openYesNoQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.GroupSQLResultRunnable_title, (String)Messages.GroupSQLResultRunnable_message, null, (boolean)false, (IPreferenceStore)store, (String)"PreferenceConstants.EXECUTE_SQL_ERROR_MODE");
            int result = dlg.getReturnCode();
            if (dlg.getToggleState()) {
                String preferenceValue = result == 2 ? "PreferenceConstants.PROMPT_MODE_ALWAYS" : "PreferenceConstants.PROMPT_MODE_NEVER";
                store.setValue("PreferenceConstants.EXECUTE_SQL_ERROR_MODE", preferenceValue);
            }
            this._goon = result == 2;
        }
    }
}

