/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ICatalogTable;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASETriggerImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementsPackage;
import org.eclipse.datatools.modelbase.sql.statements.impl.SQLStatementsFactoryImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogTrigger
extends SybaseASETriggerImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 3976740254881363508L;
    protected Boolean sourceLoaded = Boolean.FALSE;
    protected Boolean triggerInfoLoaded = Boolean.FALSE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.sourceLoaded;
        synchronized (bl) {
            if (this.sourceLoaded.booleanValue()) {
                this.sourceLoaded = Boolean.FALSE;
                super.getActionStatement().clear();
            }
        }
        bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (this.triggerInfoLoaded.booleanValue()) {
                this.triggerInfoLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public Connection getConnection() {
        ICatalogObject database = (ICatalogObject)this.getCatalogDatabase();
        return database.getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSubjectTable().getSchema().getCatalog().getDatabase();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 9: {
                this.getActionStatement();
                break;
            }
            case 17: {
                this.isDeleteType();
                break;
            }
            case 15: {
                this.isUpdateType();
                break;
            }
            case 16: {
                this.isInsertType();
                break;
            }
            case 7: {
                this.getSchema();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getActionStatement() {
        Boolean bl = this.sourceLoaded;
        synchronized (bl) {
            if (!this.sourceLoaded.booleanValue()) {
                this.loadCode();
            }
        }
        return super.getActionStatement();
    }

    protected void loadCode() {
        if (this.sourceLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList actions = super.getActionStatement();
        actions.clear();
        String body = SybaseASECatalogUtils.getCompiledObjectText((SQLObject)this, this.getConnection(), this.getSubjectTable().getSchema().getCatalog().getName());
        SQLStatement sql = (SQLStatement)SQLStatementsFactoryImpl.eINSTANCE.create(SQLStatementsPackage.eINSTANCE.getSQLStatementDefault());
        sql.setSQL(body);
        actions.add((Object)sql);
        this.sourceLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeleteType() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
            }
        }
        return super.isDeleteType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdateType() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
            }
        }
        return super.isUpdateType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInsertType() {
        Boolean bl = this.triggerInfoLoaded;
        synchronized (bl) {
            if (!this.triggerInfoLoaded.booleanValue()) {
                this.loadTriggerInfo();
            }
        }
        return super.isInsertType();
    }

    private void loadTriggerInfo() {
        boolean deliver;
        block7: {
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            Connection conn = this.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getSubjectTable().getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT o.sysstat2, deltrig = CASE when o1.deltrig = o.id then 1 else 0 end, updtrig = CASE when o1.updtrig = o.id then 1 else 0 end, instrig = CASE when o1.instrig = o.id then 1 else 0 end , o.id FROM sysobjects o, sysobjects o1 WHERE o.name = ? and o.type='TR' and o.deltrig = o1.id and o1.id = ?");
                    stmt.setString(1, this.getName());
                    stmt.setInt(2, ((ICatalogTable)this.getSubjectTable()).getTableId());
                    rs = stmt.executeQuery();
                    boolean delTrigger = false;
                    boolean updTrigger = false;
                    boolean insTrigger = false;
                    long triggerId = 0L;
                    while (rs.next()) {
                        delTrigger = rs.getInt(2) == 1;
                        updTrigger = rs.getInt(3) == 1;
                        insTrigger = rs.getInt(4) == 1;
                        triggerId = rs.getLong(5);
                    }
                    stmt = conn.prepareStatement("select 1 from dbo.sysobjects trig, dbo.sysobjects tab where trig.id = ? and trig.deltrig = tab.id and ((trig.id = tab.deltrig and tab.sysstat2 & 2097152 <> 0) or (trig.id = tab.updtrig and tab.sysstat2 & 4194304 <> 0) or (trig.id = tab.instrig and tab.sysstat2 & 1048576 <> 0))");
                    stmt.setLong(1, triggerId);
                    rs = stmt.executeQuery();
                    boolean enableTrigger = true;
                    while (rs.next()) {
                        boolean bl = enableTrigger = rs.getInt(1) != 1;
                    }
                    super.setDeleteType(delTrigger);
                    super.setUpdateType(updTrigger);
                    super.setInsertType(insTrigger);
                    super.setEnabled(enableTrigger);
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        this.eSetDeliver(deliver);
        this.triggerInfoLoaded = Boolean.TRUE;
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

