/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionResponse;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.DataSetWizardBase;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.DataSetWizardPageCore;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class DataSetEditorPageCore
extends PropertyPage {
    private DataSetWizardPageCore m_wizardPage;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected DataSetEditorPageCore(DataSetWizardPageCore page) {
        if (page.getWizard() instanceof DataSetWizardBase) {
            DataSetDesign editDataSetDesign = page.getOdaWizard().getEditingDataSet();
            if (!$assertionsDisabled && !(editDataSetDesign instanceof IAdaptable)) {
                throw new AssertionError();
            }
            this.setElement((IAdaptable)editDataSetDesign);
        }
        this.m_wizardPage = page;
    }

    DataSetEditorPageCore() {
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.getCustomPage().createControl(parent);
        Control wrappedControl = this.getCustomPage().getControl();
        this.setHelpContext(wrappedControl);
        return wrappedControl;
    }

    private void setHelpContext(Control wrappedControl) {
        if (wrappedControl == null) {
            return;
        }
        Object wrappedPageHelpContextId = wrappedControl.getData("org.eclipse.ui.help");
        if (wrappedPageHelpContextId != null && wrappedPageHelpContextId instanceof String) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), (String)wrappedPageHelpContextId);
        }
    }

    public void setContainer(IPreferencePageContainer container) {
        super.setContainer(container);
        this.getCustomPage().setEditorContainer(container);
    }

    public String getTitle() {
        return this.getCustomPage().getTitle();
    }

    public String getMessage() {
        return this.getCustomPage().getMessage();
    }

    public int getMessageType() {
        return this.getCustomPage().getMessageType();
    }

    public boolean okToLeave() {
        return super.okToLeave() && this.getCustomPage().canLeave();
    }

    public void performHelp() {
        this.getCustomPage().performHelp();
    }

    public String getPageId() {
        return this.getCustomPage().getName();
    }

    public String getPagePath() {
        return this.getCustomPage().getPagePath();
    }

    public String getIconFilePath() {
        return this.getCustomPage().getIconFilePath();
    }

    public ImageDescriptor getIconDescriptor() {
        return this.getCustomPage().getIconDescriptor();
    }

    public boolean hasInitialFocus() {
        return this.getCustomPage().hasInitialFocus();
    }

    protected DataSetDesign getEditingDataSet() {
        DataSetDesign changedDataSetDesign = this.getChangedDataSet();
        if (changedDataSetDesign == null) {
            return (DataSetDesign)this.getElement();
        }
        if (!$assertionsDisabled && !(changedDataSetDesign instanceof IAdaptable)) {
            throw new AssertionError();
        }
        this.setElement((IAdaptable)changedDataSetDesign);
        return changedDataSetDesign;
    }

    private DataSetDesign getChangedDataSet() {
        IAdaptable element = this.getElement();
        if (!$assertionsDisabled && !(element instanceof DataSetDesign)) {
            throw new AssertionError();
        }
        DataSetDesign myDesign = (DataSetDesign)element;
        DataSetDesign editedDataSetDesign = this.getCustomPage().getOdaWizard().getEditingDataSet();
        if (myDesign != editedDataSetDesign && !EcoreUtil.equals((EObject)myDesign, (EObject)editedDataSetDesign)) {
            return editedDataSetDesign;
        }
        return null;
    }

    public DesignSessionResponse collectPageResponse() {
        DataSetDesign updatedDesign = this.collectDataSetDesign();
        boolean isSessionOk = updatedDesign != null;
        OdaDesignSession nestedSession = DesignFactory.eINSTANCE.createOdaDesignSession();
        nestedSession.setNewResponse(isSessionOk, updatedDesign);
        DesignSessionResponse pageResponse = nestedSession.getResponse();
        this.getCustomPage().getOdaWizard().updateResponseWithState(pageResponse);
        return pageResponse;
    }

    private DataSetDesign collectDataSetDesign() {
        this.getCustomPage().getOdaWizard().collectDataSetDesignFromPage(this.getCustomPage());
        return this.getEditingDataSet();
    }

    public void refresh() {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.refresh(this.getEditingDataSet());
        }
    }

    public void dispose() {
        super.dispose();
        this.m_wizardPage = null;
    }

    protected DataSetWizardPageCore getCustomPage() {
        if (this.m_wizardPage == null) {
            throw new IllegalStateException(Messages.common_notInDesignSession);
        }
        return this.m_wizardPage;
    }

    static {
        $assertionsDisabled = !DataSetEditorPageCore.class.desiredAssertionStatus();
    }
}

