/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.classpath.internal;

import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.internal.ui.DriverListCombo;
import org.eclipse.datatools.enablement.jdt.classpath.DriverClasspathContainer;
import org.eclipse.datatools.enablement.jdt.classpath.internal.DriverClasspathMessages;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DriverClasspathContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private DriverListCombo combo;
    private Set fUsedPaths = new HashSet();
    private String initialSelectName = null;
    private boolean fIsExported;
    private IClasspathEntry fEditResult = null;
    private IJavaProject fProject = null;

    public DriverClasspathContainerPage() {
        this(DriverClasspathMessages.getString("DriverClasspathContainerPage.name"));
        this.setTitle(DriverClasspathMessages.getString("DriverClasspathContainerPage.title"));
        this.setMessage(DriverClasspathMessages.getString("DriverClasspathContainerPage.msg"));
    }

    public DriverClasspathContainerPage(String pageName) {
        super(pageName);
    }

    public DriverClasspathContainerPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        if (this.fEditResult != null) {
            return JavaCore.newContainerEntry((IPath)this.fEditResult.getPath(), (boolean)this.fIsExported);
        }
        return null;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        boolean bl = this.fIsExported = containerEntry != null && containerEntry.isExported();
        if (containerEntry != null) {
            this.fUsedPaths.remove(containerEntry.getPath());
            IPath path = containerEntry.getPath();
            if (this.isDriverContainer(path)) {
                this.initialSelectName = path.segment(1);
            }
        }
    }

    private boolean isDriverContainer(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.eclipse.datatools.connectivity.jdt.DRIVERLIBRARY".equals(path.segment(0));
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.fProject = project;
        int i = 0;
        while (i < currentEntries.length) {
            IClasspathEntry curr = currentEntries[i];
            if (curr.getEntryKind() == 5) {
                this.fUsedPaths.add(curr.getPath());
            }
            ++i;
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setFont(parent.getFont());
        this.combo = new DriverListCombo();
        this.combo.setLabelText(DriverClasspathMessages.getString("DriverClasspathContainerPage.combo.title"));
        this.combo.createContents(composite);
        this.combo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
        this.combo.setSelection(this.initialSelectName);
        this.combo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                DriverClasspathContainerPage.this.update(DriverClasspathContainerPage.this.combo.getSelectedDriverInstance());
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    private void update(DriverInstance di) {
        if (di != null) {
            DriverClasspathContainer container = new DriverClasspathContainer(di.getName());
            try {
                IClasspathEntry entry;
                JavaCore.setClasspathContainer((IPath)container.getPath(), (IJavaProject[])new IJavaProject[]{this.fProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
                this.fEditResult = entry = JavaCore.newContainerEntry((IPath)container.getPath());
            }
            catch (JavaModelException javaModelException) {
                this.fEditResult = null;
            }
        } else {
            this.fEditResult = null;
        }
    }
}

