/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.query.helper;

import org.eclipse.datatools.modelbase.sql.datatypes.IntegerDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesFactory;

public class DataTypeHelper {
    public static final String TYPENAME_DOUBLE_PRECISION = "DOUBLE PRECISION";
    public static final String TYPENAME_BIGINT = "BIGINT";
    public static final String TYPENAME_BLOB = "BLOB";
    public static final String TYPENAME_CHAR = "CHAR";
    public static final String TYPENAME_DBCLOB = "DBCLOB";
    public static final String TYPENAME_CHARACTER = "CHARACTER";
    public static final String TYPENAME_CHARACTER_VARYING = "CHARACTER VARYING";
    public static final String TYPENAME_CLOB = "CLOB";
    public static final String TYPENAME_DATALINK = "DATALINK";
    public static final String TYPENAME_DATE = "DATE";
    public static final String TYPENAME_DECIMAL = "DECIMAL";
    public static final String TYPENAME_DOUBLE = "DOUBLE";
    public static final String TYPENAME_GRAPHIC = "GRAPHIC";
    public static final String TYPENAME_INT = "INT";
    public static final String TYPENAME_INTEGER = "INTEGER";
    public static final String TYPENAME_LONGVARG = "LONGVARG";
    public static final String TYPENAME_LONGVARN = "LONGVARN";
    public static final String TYPENAME_LONGVARCHAR = "LONGVARCHAR";
    public static final String TYPENAME_LONG_VARGRAPHIC = "LONG VARGRAPHIC";
    public static final String TYPENAME_LONG_VARCHAR = "LONG VARCHAR";
    public static final String TYPENAME_REAL = "REAL";
    public static final String TYPENAME_SMALLINT = "SMALLINT";
    public static final String TYPENAME_TIMESTAMP = "TIMESTAMP";
    public static final String TYPENAME_TIME = "TIME";
    public static final String TYPENAME_NUMERIC = "NUMERIC";
    public static final String TYPENAME_VARBINARY = "VARBINARY";
    public static final String TYPENAME_VARCHAR = "VARCHAR";
    public static final String TYPENAME_VARGRAPHIC = "VARGRAPHIC";
    public static final String TYPENAME_CHARACTER_LARGE_OBJECT = "CLOB";
    public static final String TYPENAME_NATIONAL_CHARACTER = "NATIONAL CHARACTER";
    public static final String TYPENAME_NATIONAL_CHARACTER_VARYING = "NATIONAL CHARACTER VARYING";
    public static final String TYPENAME_NATIONAL_CHARACTER_LARGE_OBJECT = "DBCLOB";
    public static final String TYPENAME_BINARY = "BINARY";
    public static final String TYPENAME_BINARY_VARYING = "BINARY VARYING";
    public static final String TYPENAME_BINARY_LARGE_OBJECT = "BLOB";
    public static final String TYPENAME_FLOAT = "FLOAT";
    public static final String TYPENAME_BOOLEAN = "BOOLEAN";
    public static final String TYPENAME_INTERVAL = "INTERVAL";
    public static final String TYPENAME_XML_TYPE = "XML";

    public static int getJDBCTypeForNamedType(String aTypeName) {
        int jdbcTypeID = 0;
        if (aTypeName.equalsIgnoreCase(TYPENAME_INTEGER) || aTypeName.equalsIgnoreCase(TYPENAME_INT)) {
            jdbcTypeID = 4;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_DECIMAL) || aTypeName.equalsIgnoreCase("DEC") || aTypeName.equalsIgnoreCase(TYPENAME_NUMERIC) || aTypeName.equalsIgnoreCase("NUM")) {
            jdbcTypeID = 3;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_VARCHAR) || aTypeName.equalsIgnoreCase(TYPENAME_CHARACTER_VARYING) || aTypeName.equalsIgnoreCase("CHAR VARYING")) {
            jdbcTypeID = 12;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_DOUBLE) || aTypeName.equalsIgnoreCase(TYPENAME_DOUBLE_PRECISION)) {
            jdbcTypeID = 8;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_CHARACTER) || aTypeName.equalsIgnoreCase(TYPENAME_CHAR)) {
            jdbcTypeID = 1;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_SMALLINT)) {
            jdbcTypeID = 5;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_BIGINT)) {
            jdbcTypeID = -5;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_REAL)) {
            jdbcTypeID = 7;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_DATE)) {
            jdbcTypeID = 91;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_TIME)) {
            jdbcTypeID = 92;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_TIMESTAMP)) {
            jdbcTypeID = 93;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_LONG_VARCHAR)) {
            jdbcTypeID = -1;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_GRAPHIC)) {
            jdbcTypeID = 1;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_VARGRAPHIC)) {
            jdbcTypeID = 12;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_LONG_VARGRAPHIC)) {
            jdbcTypeID = -1;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_VARBINARY)) {
            jdbcTypeID = -3;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_DATALINK)) {
            jdbcTypeID = 70;
        } else if (aTypeName.equalsIgnoreCase("BLOB")) {
            jdbcTypeID = 2004;
        } else if (aTypeName.equalsIgnoreCase("CLOB")) {
            jdbcTypeID = 2005;
        } else if (aTypeName.equalsIgnoreCase("DBCLOB")) {
            jdbcTypeID = 2005;
        }
        return jdbcTypeID;
    }

    public static int getPrimitiveTypeForNamedType(String aTypeName) {
        int typeEnum = 0;
        if (aTypeName.equalsIgnoreCase(TYPENAME_BIGINT)) {
            typeEnum = 12;
        } else if (aTypeName.equalsIgnoreCase("BLOB")) {
            typeEnum = 8;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_CHAR)) {
            typeEnum = 0;
        } else if (aTypeName.equalsIgnoreCase("CLOB")) {
            typeEnum = 2;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_DATE)) {
            typeEnum = 18;
        } else if (aTypeName.equalsIgnoreCase("DBCLOB")) {
            typeEnum = 5;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_DECIMAL)) {
            typeEnum = 10;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_DOUBLE)) {
            typeEnum = 16;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_GRAPHIC)) {
            typeEnum = 3;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_INTEGER)) {
            typeEnum = 12;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_LONGVARCHAR)) {
            typeEnum = 2;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_LONGVARG)) {
            typeEnum = 5;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_LONGVARN)) {
            typeEnum = 5;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_REAL)) {
            typeEnum = 15;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_SMALLINT)) {
            typeEnum = 11;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_TIME)) {
            typeEnum = 19;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_TIMESTAMP)) {
            typeEnum = 20;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_VARCHAR)) {
            typeEnum = 1;
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_VARGRAPHIC)) {
            typeEnum = 4;
        }
        return typeEnum;
    }

    public static PredefinedDataType getPredefinedDataTypeForNamedType(String aTypeName) {
        PrimitiveType primitive = null;
        IntegerDataType dataType = null;
        SQLDataTypesFactory dataTypesFactory = SQLDataTypesFactory.eINSTANCE;
        if (aTypeName.equalsIgnoreCase(TYPENAME_BIGINT)) {
            primitive = PrimitiveType.INTEGER_LITERAL;
            dataType = dataTypesFactory.createIntegerDataType();
        } else if (aTypeName.equalsIgnoreCase("BLOB")) {
            primitive = PrimitiveType.BINARY_LARGE_OBJECT_LITERAL;
            dataType = dataTypesFactory.createBinaryStringDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_CHAR)) {
            primitive = PrimitiveType.CHARACTER_LITERAL;
            dataType = dataTypesFactory.createCharacterStringDataType();
        } else if (aTypeName.equalsIgnoreCase("CLOB")) {
            primitive = PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL;
            dataType = dataTypesFactory.createCharacterStringDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_DATE)) {
            primitive = PrimitiveType.DATE_LITERAL;
            dataType = dataTypesFactory.createDateDataType();
        } else if (aTypeName.equalsIgnoreCase("DBCLOB")) {
            primitive = PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL;
            dataType = dataTypesFactory.createCharacterStringDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_DECIMAL)) {
            primitive = PrimitiveType.DECIMAL_LITERAL;
            dataType = dataTypesFactory.createFixedPrecisionDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_DOUBLE)) {
            primitive = PrimitiveType.DOUBLE_PRECISION_LITERAL;
            dataType = dataTypesFactory.createApproximateNumericDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_GRAPHIC)) {
            primitive = PrimitiveType.NATIONAL_CHARACTER_LITERAL;
            dataType = dataTypesFactory.createCharacterStringDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_NATIONAL_CHARACTER)) {
            primitive = PrimitiveType.NATIONAL_CHARACTER_LITERAL;
            dataType = dataTypesFactory.createCharacterStringDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_INTEGER)) {
            primitive = PrimitiveType.INTEGER_LITERAL;
            dataType = dataTypesFactory.createIntegerDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_LONGVARCHAR)) {
            primitive = PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL;
            dataType = dataTypesFactory.createCharacterStringDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_LONGVARG)) {
            primitive = PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL;
            dataType = dataTypesFactory.createCharacterStringDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_LONGVARN)) {
            primitive = PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL;
            dataType = dataTypesFactory.createCharacterStringDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_REAL)) {
            primitive = PrimitiveType.REAL_LITERAL;
            dataType = dataTypesFactory.createFixedPrecisionDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_SMALLINT)) {
            primitive = PrimitiveType.SMALLINT_LITERAL;
            dataType = dataTypesFactory.createIntegerDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_TIME)) {
            primitive = PrimitiveType.TIME_LITERAL;
            dataType = dataTypesFactory.createTimeDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_TIMESTAMP)) {
            primitive = PrimitiveType.TIMESTAMP_LITERAL;
            dataType = dataTypesFactory.createTimeDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_VARCHAR)) {
            primitive = PrimitiveType.CHARACTER_VARYING_LITERAL;
            dataType = dataTypesFactory.createCharacterStringDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_VARGRAPHIC)) {
            primitive = PrimitiveType.NATIONAL_CHARACTER_VARYING_LITERAL;
            dataType = dataTypesFactory.createCharacterStringDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_NATIONAL_CHARACTER_VARYING)) {
            primitive = PrimitiveType.NATIONAL_CHARACTER_VARYING_LITERAL;
            dataType = dataTypesFactory.createCharacterStringDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_NUMERIC)) {
            primitive = PrimitiveType.NUMERIC_LITERAL;
            dataType = dataTypesFactory.createFixedPrecisionDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_FLOAT)) {
            primitive = PrimitiveType.FLOAT_LITERAL;
            dataType = dataTypesFactory.createApproximateNumericDataType();
        } else if (aTypeName.equalsIgnoreCase(TYPENAME_DATALINK)) {
            primitive = PrimitiveType.DATALINK_LITERAL;
            dataType = dataTypesFactory.createDataLinkDataType();
        }
        if (dataType != null) {
            dataType.setPrimitiveType(primitive);
        }
        return dataType;
    }

    public static String getPrimitiveTypeName(PrimitiveType primitiveType) {
        if (primitiveType == PrimitiveType.CHARACTER_LITERAL) {
            return TYPENAME_CHARACTER;
        }
        if (primitiveType == PrimitiveType.CHARACTER_VARYING_LITERAL) {
            return TYPENAME_VARCHAR;
        }
        if (primitiveType == PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL) {
            return "CLOB";
        }
        if (primitiveType == PrimitiveType.NATIONAL_CHARACTER_LITERAL) {
            return TYPENAME_NATIONAL_CHARACTER;
        }
        if (primitiveType == PrimitiveType.NATIONAL_CHARACTER_VARYING_LITERAL) {
            return TYPENAME_VARGRAPHIC;
        }
        if (primitiveType == PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL) {
            return "DBCLOB";
        }
        if (primitiveType == PrimitiveType.BINARY_LITERAL) {
            return TYPENAME_BINARY;
        }
        if (primitiveType == PrimitiveType.BINARY_VARYING_LITERAL) {
            return TYPENAME_BINARY_VARYING;
        }
        if (primitiveType == PrimitiveType.BINARY_LARGE_OBJECT_LITERAL) {
            return "BLOB";
        }
        if (primitiveType == PrimitiveType.NUMERIC_LITERAL) {
            return TYPENAME_NUMERIC;
        }
        if (primitiveType == PrimitiveType.DECIMAL_LITERAL) {
            return TYPENAME_DECIMAL;
        }
        if (primitiveType == PrimitiveType.SMALLINT_LITERAL) {
            return TYPENAME_SMALLINT;
        }
        if (primitiveType == PrimitiveType.INTEGER_LITERAL) {
            return TYPENAME_INTEGER;
        }
        if (primitiveType == PrimitiveType.BIGINT_LITERAL) {
            return TYPENAME_BIGINT;
        }
        if (primitiveType == PrimitiveType.FLOAT_LITERAL) {
            return TYPENAME_FLOAT;
        }
        if (primitiveType == PrimitiveType.REAL_LITERAL) {
            return TYPENAME_REAL;
        }
        if (primitiveType == PrimitiveType.DOUBLE_PRECISION_LITERAL) {
            return TYPENAME_DOUBLE_PRECISION;
        }
        if (primitiveType == PrimitiveType.BOOLEAN_LITERAL) {
            return TYPENAME_BOOLEAN;
        }
        if (primitiveType == PrimitiveType.DATE_LITERAL) {
            return TYPENAME_DATE;
        }
        if (primitiveType == PrimitiveType.TIME_LITERAL) {
            return TYPENAME_TIME;
        }
        if (primitiveType == PrimitiveType.TIMESTAMP_LITERAL) {
            return TYPENAME_TIMESTAMP;
        }
        if (primitiveType == PrimitiveType.INTERVAL_LITERAL) {
            return TYPENAME_INTERVAL;
        }
        if (primitiveType == PrimitiveType.DATALINK_LITERAL) {
            return TYPENAME_DATALINK;
        }
        if (primitiveType == PrimitiveType.XML_TYPE_LITERAL) {
            return TYPENAME_XML_TYPE;
        }
        return primitiveType.getName();
    }
}

