/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.CommonConstants;
import org.eclipse.datatools.connectivity.oda.flatfile.FlatFileQuery;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.flatfile.ResultSetMetaDataHelper;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;

public class FlatFileDataReader {
    private String homeDir;
    private String currentTableName;
    private char delimiter;
    private boolean hasColumnNames = true;
    private boolean hasTypeLine = true;
    private String charSet;
    private FlatFileQuery.FlatFileBufferedReader flatFileBufferedReader = null;
    private IResultSetMetaData rsmd;
    private ResultSetMetaDataHelper rsmdHelper;
    private int statementMaxRows = 0;
    private int resultSetMaxRows = 0;
    private int maxRowsToRead = 0;
    private String[] originalColumnNames;
    private boolean isFirstTimeToReadSourceData = true;
    private boolean isFirstTimeToCallReadLine = true;
    private int fetchCounter = 0;
    public static final int MAX_ROWS_PER_FETCH = 20000;

    public FlatFileDataReader(Properties connProperties, String currentTableName, int statementMaxRows, IResultSetMetaData rsmd, ResultSetMetaDataHelper rsmdHelper) throws OdaException {
        this.rsmd = rsmd;
        this.rsmdHelper = rsmdHelper;
        this.statementMaxRows = statementMaxRows;
        this.currentTableName = currentTableName;
        Properties properties = this.getCopyOfConnectionProperties(connProperties);
        this.populateHomeDir(properties);
        this.populateDelimiter(properties);
        this.populateCharSet(properties);
        this.populateHasColumnNames(properties);
        this.populateHasTypeLine(properties);
    }

    private Properties getCopyOfConnectionProperties(Properties connProperties) {
        Properties copyConnProperites = new Properties();
        copyConnProperites.setProperty("CHARSET", connProperties.getProperty("CHARSET"));
        copyConnProperites.setProperty("DELIMTYPE", connProperties.getProperty("DELIMTYPE"));
        copyConnProperites.setProperty("HOME", connProperties.getProperty("HOME"));
        copyConnProperites.setProperty("INCLCOLUMNNAME", connProperties.getProperty("INCLCOLUMNNAME"));
        copyConnProperites.setProperty("INCLTYPELINE", connProperties.getProperty("INCLTYPELINE"));
        return copyConnProperites;
    }

    private void populateDelimiter(Properties connProperties) throws OdaException {
        this.delimiter = CommonConstants.getDelimiterValue(connProperties.getProperty("DELIMTYPE") != null ? connProperties.getProperty("DELIMTYPE") : "COMMA").charAt(0);
    }

    private void populateHomeDir(Properties connProperties) throws OdaException {
        this.homeDir = connProperties.getProperty("HOME");
        File file = new File(this.homeDir);
        if (!file.exists()) {
            throw new OdaException(String.valueOf(Messages.getString("connection_CANNOT_OPEN_FLAT_FILE_DB_DIR")) + this.homeDir);
        }
    }

    private void populateCharSet(Properties connProperties) {
        this.charSet = connProperties.getProperty("CHARSET");
    }

    private void populateHasColumnNames(Properties connProperties) {
        this.hasColumnNames = !connProperties.getProperty("INCLCOLUMNNAME").equalsIgnoreCase("NO");
    }

    private void populateHasTypeLine(Properties connProperties) {
        this.hasTypeLine = !connProperties.getProperty("INCLTYPELINE").equalsIgnoreCase("NO");
    }

    public String[][] getSourceData() throws OdaException {
        this.createBufferedReader();
        Vector v = this.fetchQueriedDataFromFileToVector();
        return this.copyDataFromVectorToTwoDimensionArray(v);
    }

    public String readLine() throws OdaException, IOException {
        if (this.isFirstTimeToCallReadLine) {
            this.createBufferedReader();
            this.isFirstTimeToCallReadLine = false;
        }
        return this.flatFileBufferedReader.readLine();
    }

    private void createBufferedReader() throws OdaException {
        try {
            if (this.flatFileBufferedReader == null) {
                String dataFilePath = this.findDataFileAbsolutePath();
                if (this.charSet == null || this.charSet.trim().length() == 0) {
                    this.examCharset(dataFilePath);
                }
                this.flatFileBufferedReader = new FlatFileQuery.FlatFileBufferedReader(new InputStreamReader((InputStream)new FileInputStream(dataFilePath), this.charSet));
            }
        }
        catch (IOException e) {
            throw new OdaException(e.getMessage());
        }
    }

    public int getMaxRowsToRead(int resultSetMaxRows) {
        this.resultSetMaxRows = resultSetMaxRows;
        this.maxRowsToRead = this.statementMaxRows != 0 && this.statementMaxRows < this.resultSetMaxRows || this.resultSetMaxRows == 0 ? this.statementMaxRows : this.resultSetMaxRows;
        return this.maxRowsToRead;
    }

    public void clearBufferedReader() {
        try {
            if (this.flatFileBufferedReader != null) {
                this.flatFileBufferedReader.close();
            }
        }
        catch (IOException iOException) {}
        this.flatFileBufferedReader = null;
    }

    public void finalize() {
        this.clearBufferedReader();
    }

    private void examCharset(String filepath) throws OdaException, IOException {
        if (this.charSet != null && this.charSet.length() > 0) {
            return;
        }
        FileInputStream fis = new FileInputStream(filepath);
        byte[] byteMarker = new byte[2];
        fis.read(byteMarker);
        this.charSet = byteMarker[0] == -1 && byteMarker[1] == -2 ? "UTF-16LE" : (byteMarker[0] == -2 && byteMarker[1] == -1 ? "UTF-16BE" : "UTF-8");
        fis.close();
    }

    public int getColumnCount() throws OdaException {
        int count;
        try {
            String columeLine;
            String dataFilePath = this.findDataFileAbsolutePath();
            this.examCharset(dataFilePath);
            FileInputStream fis = new FileInputStream(dataFilePath);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, this.charSet);
            FlatFileQuery.FlatFileBufferedReader br = new FlatFileQuery.FlatFileBufferedReader(isr);
            while (FlatFileDataReader.isEmptyRow(columeLine = br.readLine())) {
            }
            count = this.splitDoubleQuotedString(columeLine).size();
            br.close();
            isr.close();
            fis.close();
        }
        catch (IOException iOException) {
            throw new OdaException(String.valueOf(Messages.getString("query_IO_EXCEPTION")) + this.findDataFileAbsolutePath());
        }
        return count;
    }

    private Vector splitDoubleQuotedString(String aRow) throws OdaException {
        Vector<String> result = new Vector<String>();
        if (aRow.endsWith("\r")) {
            aRow = aRow.substring(0, aRow.length() - 1);
        }
        char[] chars = aRow.toCharArray();
        boolean startDoubleQuote = false;
        boolean finishAnElement = false;
        boolean hasConsectiveTwoDoubleQuotes = false;
        String currentString = "";
        int i = 0;
        while (i < chars.length) {
            if (i < chars.length - 1) {
                if (chars[i] == '\"') {
                    if (chars[i + 1] == '\"') {
                        if (startDoubleQuote) {
                            currentString = String.valueOf(currentString) + '\"';
                            ++i;
                        } else if (i < chars.length - 2 && chars[i + 2] == '\"') {
                            currentString = String.valueOf(currentString) + '\"';
                            i += 2;
                            startDoubleQuote = !startDoubleQuote;
                        } else {
                            hasConsectiveTwoDoubleQuotes = true;
                            if (++i == chars.length - 1 && currentString.trim().length() == 0) {
                                result.add(currentString);
                            }
                        }
                    } else {
                        boolean bl = startDoubleQuote = !startDoubleQuote;
                        if (!startDoubleQuote) {
                            finishAnElement = true;
                        }
                    }
                } else if (chars[i] == this.delimiter && !startDoubleQuote) {
                    if (hasConsectiveTwoDoubleQuotes) {
                        if (currentString.trim().length() != 0) {
                            throw new OdaException(Messages.getString("invalid_flatfile_format"));
                        }
                        hasConsectiveTwoDoubleQuotes = false;
                    }
                    result.add(currentString);
                    currentString = "";
                    finishAnElement = false;
                } else {
                    if (finishAnElement && chars[i] != ' ') {
                        throw new OdaException(Messages.getString("invalid_flatfile_format"));
                    }
                    currentString = String.valueOf(currentString) + chars[i];
                }
            } else if (chars[i] == '\"') {
                if (!startDoubleQuote) {
                    throw new OdaException(Messages.getString("invalid_flatfile_format"));
                }
                result.add(currentString);
                startDoubleQuote = !startDoubleQuote;
                finishAnElement = true;
            } else if (chars[i] == this.delimiter) {
                result.add(currentString);
                result.add("");
                finishAnElement = false;
            } else {
                currentString = String.valueOf(currentString) + chars[i];
                result.add(currentString);
                finishAnElement = false;
            }
            ++i;
        }
        if ((hasConsectiveTwoDoubleQuotes || startDoubleQuote && !finishAnElement) && currentString.trim().length() != 0) {
            throw new OdaException(Messages.getString("invalid_flatfile_format"));
        }
        return result;
    }

    public String findDataFileAbsolutePath() throws OdaException {
        File file = new File(String.valueOf(this.homeDir) + File.separator + this.currentTableName.trim());
        if (!file.exists()) {
            throw new OdaException(String.valueOf(Messages.getString("query_invalidTableName")) + this.currentTableName);
        }
        return file.getAbsolutePath();
    }

    private boolean isUTF8BOMFormat(byte[] bytecodes) {
        int[] UTF8Prefix = new int[]{-17, -69, -65};
        if (bytecodes.length < UTF8Prefix.length) {
            return false;
        }
        int i = 0;
        while (i < UTF8Prefix.length) {
            if (bytecodes[i] != UTF8Prefix[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEmptyRow(String row) throws OdaException {
        if (row == null) {
            throw new OdaException(Messages.getString("query_INVALID_FLAT_FILE"));
        }
        return row.trim().length() <= 0;
    }

    private Vector fetchQueriedDataFromFileToVector() throws OdaException {
        Vector<String[]> result = new Vector<String[]>();
        String aLine = null;
        try {
            if (this.isFirstTimeToReadSourceData) {
                if (this.hasColumnNames) {
                    String columeNameLine;
                    while (FlatFileDataReader.isEmptyRow(columeNameLine = this.flatFileBufferedReader.readLine())) {
                    }
                    this.originalColumnNames = this.getColumnNameArray(columeNameLine, true);
                }
                if (this.hasTypeLine) {
                    while (FlatFileDataReader.isEmptyRow(this.flatFileBufferedReader.readLine())) {
                    }
                }
                aLine = this.flatFileBufferedReader.readLine();
                if (!this.hasColumnNames) {
                    this.originalColumnNames = this.createTempColumnNames(aLine);
                }
                this.isFirstTimeToReadSourceData = false;
            } else {
                aLine = this.flatFileBufferedReader.readLine();
            }
            int counterLimitPerFetch = this.fetchCounter + 20000;
            while ((this.maxRowsToRead <= 0 || this.fetchCounter < this.maxRowsToRead) && this.fetchCounter < counterLimitPerFetch && aLine != null) {
                if (!FlatFileDataReader.isEmptyRow(aLine)) {
                    ++this.fetchCounter;
                    result.add(this.fetchQueriedDataFromRow(aLine, this.originalColumnNames));
                }
                aLine = this.flatFileBufferedReader.readLine();
            }
            return result;
        }
        catch (IOException e) {
            throw new OdaException(e.getMessage());
        }
    }

    public String[] getColumnNameArray(String line, boolean isFirstLine) throws OdaException {
        if (line == null) {
            throw new OdaException(Messages.getString("common_CANNOT_FIND_COLUMN"));
        }
        String[] result = null;
        if (isFirstLine) {
            try {
                byte[] firstLineByteCodes;
                if ("UTF-8".equals(this.charSet) && this.isUTF8BOMFormat(firstLineByteCodes = line.getBytes(this.charSet))) {
                    line = line.substring(1);
                }
                result = FlatFileDataReader.getStringArrayFromVector(this.splitDoubleQuotedString(line));
            }
            catch (UnsupportedEncodingException e) {
                throw new OdaException((Throwable)e);
            }
        } else {
            result = FlatFileDataReader.getStringArrayFromVector(this.splitDoubleQuotedString(line));
        }
        return result;
    }

    public static String[] getStringArrayFromVector(Vector vector) {
        String[] array = null;
        if (vector != null) {
            array = new String[vector.size()];
            int i = 0;
            while (i < vector.size()) {
                array[i] = (String)vector.get(i);
                ++i;
            }
        }
        return array;
    }

    private String[][] copyDataFromVectorToTwoDimensionArray(Vector v) throws OdaException {
        String[][] rowSet = new String[v.size()][this.rsmd.getColumnCount()];
        int i = 0;
        while (i < v.size()) {
            String[] temp = (String[])v.elementAt(i);
            int j = 0;
            while (j < temp.length) {
                if (temp[j] == null) {
                    throw new OdaException(Messages.getString("data_read_error"));
                }
                rowSet[i][j] = temp[j].trim();
                ++j;
            }
            ++i;
        }
        return rowSet;
    }

    private String[] createTempColumnNames(String aRow) throws OdaException {
        Vector vTemp = this.splitDoubleQuotedString(aRow);
        String[] tempColumnNames = new String[vTemp.size()];
        int i = 0;
        while (i < vTemp.size()) {
            tempColumnNames[i] = "COLUMN_" + (i + 1);
            ++i;
        }
        return tempColumnNames;
    }

    private String[] fetchQueriedDataFromRow(String aRow, String[] originalColumnNames) throws OdaException {
        String[] sArray = new String[this.rsmd.getColumnCount()];
        Vector vTemp = this.splitDoubleQuotedString(aRow);
        ResultSetMetaData metadata = (ResultSetMetaData)this.rsmd;
        int i = 0;
        while (i < sArray.length) {
            int location = this.findLocationOfValueInStringArray(this.rsmdHelper.getOriginalColumnName(metadata.getColumnName(i + 1)), originalColumnNames);
            if (location != -1) {
                if (location >= vTemp.size()) {
                    throw new OdaException(Messages.getString("query_INVALID_FLAT_FILE"));
                }
                sArray[i] = vTemp.elementAt(location).toString();
            }
            ++i;
        }
        return sArray;
    }

    private int findLocationOfValueInStringArray(String value, String[] array) throws OdaException {
        int result = -1;
        try {
            int i = 0;
            while (i < array.length) {
                if (value.trim().equalsIgnoreCase(array[i].trim())) {
                    result = i;
                    break;
                }
                ++i;
            }
            return result;
        }
        catch (Exception exception) {
            throw new OdaException(Messages.getString("query_COLUMN_NAME_ERROR"));
        }
    }
}

