/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.deltaddl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.sybase.deltaddl.GenericDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public final class DeltaDdlGenServiceImpl {
    public static final DeltaDdlGenServiceImpl INSTANCE = new DeltaDdlGenServiceImpl();
    private Map _productsMap = new HashMap();
    private Map cache = new HashMap();

    public IDeltaDdlGenProvider getDeltaDdlGenProvider(String product, String version, EObject obj) {
        EClass metaclass = obj.eClass();
        IDeltaDdlGenProvider provider = this.getProvider(product, version, metaclass);
        if (provider == null) {
            provider = GenericDeltaDdlGenProvider.INSTANCE;
        }
        return provider;
    }

    private IDeltaDdlGenProvider getProvider(String product, String version, EClass metaclass) {
        ProductVersionClass pvc = ProductVersionClass.getInstance(product, version, metaclass);
        if (this.cache.containsKey(pvc)) {
            return (IDeltaDdlGenProvider)this.cache.get(pvc);
        }
        List sortedClasses = this.computeClassOrder(metaclass);
        IDeltaDdlGenProvider provider = this.getProvider(product, version, sortedClasses);
        if (provider != null) {
            this.cache.put(pvc, provider);
        }
        return provider;
    }

    private List computeClassOrder(EClass metaclass) {
        ArrayList<Object> result = new ArrayList<Object>(5);
        result.add(metaclass);
        int index = 0;
        for (index = 0; index < result.size(); ++index) {
            EClass clazz = (EClass)result.get(index);
            Iterator it = clazz.getESuperTypes().iterator();
            while (it.hasNext()) {
                result.add(it.next());
            }
        }
        return result;
    }

    private IDeltaDdlGenProvider getProvider(String product, String version, List classes) {
        int count = classes.size();
        for (int i = 0; i < count; ++i) {
            EClass clazz = (EClass)classes.get(i);
            String uri = clazz.getEPackage().getNsURI();
            String className = clazz.getName();
            String fullName = uri + className;
            Map versionMap = (Map)this._productsMap.get(product);
            Map classMap = (Map)versionMap.get(version);
            if (classMap != null && classMap.containsKey(fullName)) {
                return (IDeltaDdlGenProvider)classMap.get(fullName);
            }
            Iterator it = versionMap.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                if (key.equals(version) || (classMap = (Map)versionMap.get(key)) == null || !classMap.containsKey(fullName)) continue;
                return (IDeltaDdlGenProvider)classMap.get(fullName);
            }
        }
        return null;
    }

    private DeltaDdlGenServiceImpl() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.enablement.sybase", "deltaDdlGenProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            for (int j = 0; j < configElements.length; ++j) {
                if (!configElements[j].getName().equals("deltaDdlGenService")) continue;
                String packageURI = configElements[j].getAttribute("package");
                String className = configElements[j].getAttribute("class");
                String product = configElements[j].getAttribute("product");
                String version = configElements[j].getAttribute("version");
                IDeltaDdlGenProvider provider = null;
                try {
                    provider = (IDeltaDdlGenProvider)configElements[j].createExecutableExtension("provider");
                }
                catch (CoreException e) {
                    Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the delta ddl generation provider for " + className + " in " + packageURI, (Throwable)e);
                    RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                    continue;
                }
                this.initProductsMap(product, version, packageURI, className, provider);
            }
        }
    }

    private void initProductsMap(String product, String version, String packageURI, String className, IDeltaDdlGenProvider provider) {
        HashMap<String, IDeltaDdlGenProvider> classNames;
        TreeMap versionsMap = (TreeMap)this._productsMap.get(product);
        if (versionsMap == null) {
            versionsMap = new TreeMap(new Comparator(){

                public int compare(Object left, Object right) {
                    if (left == null && right == null) {
                        return 0;
                    }
                    if (left == null) {
                        return 1;
                    }
                    if (right == null) {
                        return -1;
                    }
                    String leftString = ((String)left).toLowerCase();
                    String rightString = ((String)right).toLowerCase();
                    int result = 0;
                    String[] ls = leftString.split("\\Q.\\E");
                    String[] rs = rightString.split("\\Q.\\E");
                    int length = Math.min(ls.length, rs.length);
                    for (int i = 0; i < length; ++i) {
                        int lxindex = ls[i].indexOf("x");
                        int rxindex = rs[i].indexOf("x");
                        if (lxindex >= 0 || rxindex >= 0) {
                            if (lxindex == rxindex) continue;
                            return lxindex - rxindex;
                        }
                        result = Integer.parseInt(rs[i]) - Integer.parseInt(ls[i]);
                        if (result != 0) break;
                    }
                    return result;
                }
            });
            this._productsMap.put(product, versionsMap);
        }
        if ((classNames = (HashMap<String, IDeltaDdlGenProvider>)versionsMap.get(version)) == null) {
            classNames = new HashMap<String, IDeltaDdlGenProvider>();
            versionsMap.put(version, classNames);
        }
        String fullName = packageURI + className;
        classNames.put(fullName, provider);
    }

    static class ProductVersionClass {
        String _productName;
        String _version;
        EClass _clazz;

        public static ProductVersionClass getInstance(String product, String version, EClass clazz) {
            return new ProductVersionClass(product, version, clazz);
        }

        ProductVersionClass(String product, String version, EClass clazz) {
            this._productName = product != null ? product : "";
            this._version = version != null ? version : "";
            this._clazz = clazz;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProductVersionClass) {
                ProductVersionClass pvc = (ProductVersionClass)obj;
                return pvc._productName.equals(this._productName) && pvc._version.equals(this._version) && pvc._clazz.equals(this._clazz);
            }
            return false;
        }

        public int hashCode() {
            return (this._productName + this._version + this._clazz.getEPackage().getNsURI() + this._clazz.getName()).hashCode();
        }
    }
}

