/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.parser;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.enablement.sybase.Activator;
import org.eclipse.datatools.enablement.sybase.parser.AbstractQuickSQLParser;
import org.eclipse.datatools.enablement.sybase.parser.JJTQuickSQLParserState;
import org.eclipse.datatools.enablement.sybase.parser.JavaCharStream;
import org.eclipse.datatools.enablement.sybase.parser.Node;
import org.eclipse.datatools.enablement.sybase.parser.ParseException;
import org.eclipse.datatools.enablement.sybase.parser.QuickSQLParserConstants;
import org.eclipse.datatools.enablement.sybase.parser.QuickSQLParserTokenManager;
import org.eclipse.datatools.enablement.sybase.parser.QuickSQLParserTreeConstants;
import org.eclipse.datatools.enablement.sybase.parser.SimpleNode;
import org.eclipse.datatools.enablement.sybase.parser.Token;

public class QuickSQLParser
extends AbstractQuickSQLParser
implements QuickSQLParserTreeConstants,
QuickSQLParserConstants {
    protected JJTQuickSQLParserState jjtree = new JJTQuickSQLParserState();
    private static QuickSQLParser _instance = new QuickSQLParser(new StringReader(""));
    private boolean _debug = false;
    private static String SEPARATOR = System.getProperty("line.separator");
    private static Pattern p = Pattern.compile("(.*" + SEPARATOR + ")");
    private String _input = "";
    private boolean canUseDelimiter = false;
    private static final int[] STMT_START = new int[]{15, 23, 25, 32, 33, 36, 39, 41, 45, 50, 51, 53, 56, 58, 60, 68, 67, 73, 81, 82, 87, 91, 100, 103, 104, 119, 121, 132, 134, 141, 142, 145, 146, 148, 149, 152, 154, 156, 160, 162, 163, 164, 166, 180, 184, 185, 191, 194, 197};
    public static final String[] STMT_START_STRING = new String[]{"ALTER", "BEGIN", "BREAK", "CHECKPOINT", "CLOSE", "COMMIT", "CONNECT", "CONTINUE", "CREATE", "DEALLOCATE", "DECLARE", "DELETE", "DISK", "DROP", "DUMP", "EXECUTE", "EXEC", "FETCH", "GOTO", "GRANT", "IF", "INSERT", "KILL", "LOAD", "LOCK", "ONLINE", "OPEN", "PREPARE", "PRINT", "QUIESCE", "RAISERROR", "READTEXT", "RECONFIGURE", "REMOVE", "REORG", "RETURN", "REVOKE", "ROLLBACK", "SAVE", "SELECT", "SET", "SETUSER", "SHUTDOWN", "TRUNCATE", "UPDATE", "USE", "WAITFOR", "WHILE", "WRITETEXT"};
    private static final int[] DEFINED_STMT_START = new int[]{15, 23, 45, 51, 53, 68, 67, 73, 87, 91, 134, 152, 162, 184, 185};
    private static final int[] TERMINATORS = new int[]{80, 223};
    private static final String[] TERMINATORS_STRING = new String[]{"GO", ";"};
    private static final String[] WATCOM_POST_PARAM = new String[]{"BEGIN", "RETURNS", "RESULT", "AT", "AS", "EXTERNAL", "ON", "DYNAMIC"};
    public QuickSQLParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[38];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private static int[] jj_la1_7;
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public String[] getStatementTerminators() {
        return TERMINATORS_STRING;
    }

    public static QuickSQLParser getInstance() {
        return _instance;
    }

    public QuickSQLParser() {
    }

    private final void logDebug(String message) {
        if (this._debug) {
            Activator.getDefault().debug(message);
        }
    }

    private final void logError(String message) {
        Activator.getDefault().log(message);
    }

    protected synchronized void initParser(String text) {
        this._input = text;
        StringReader sr = new StringReader(text);
        BufferedReader r = new BufferedReader(sr);
        this.ReInit(r);
    }

    public boolean match(String input, int pattern) {
        try {
            this.initParser(input);
            switch (pattern) {
                case 1: {
                    this.create_proc_header();
                    return true;
                }
                case 2: {
                    this.create_func_header();
                    return true;
                }
                case 3: {
                    this.create_trigger_header();
                    return true;
                }
                case 4: {
                    this.create_event_header();
                    return true;
                }
            }
        }
        catch (Throwable e) {
            this.logDebug(e.getMessage());
            return false;
        }
        return false;
    }

    public int[] find(String input, String[][] tokens) {
        this.initParser(input);
        boolean found = true;
        try {
            this.getNextToken();
            do {
                this.error_skiptobefore1(tokens[0], new String[0], false);
                for (int i = 1; i < tokens.length; ++i) {
                    boolean tokenMatch = false;
                    for (int j = 0; j < tokens[i].length; ++j) {
                        if (!tokens[i][j].equalsIgnoreCase(this.getToken((int)i).image)) continue;
                        tokenMatch = true;
                        break;
                    }
                    if (!tokenMatch) {
                        found = false;
                        this.getNextToken();
                        break;
                    }
                    found = true;
                }
                if (this.token.kind != 0) continue;
                found = false;
                break;
            } while (!found);
        }
        catch (Throwable e) {
            this.logDebug(e.getMessage());
            return new int[]{-1, -1};
        }
        if (!found) {
            return new int[]{-1, -1};
        }
        int[] index = new int[]{this.getStartIndex(this.getToken(0)), this.getEndIndex(this.getToken(tokens.length - 1))};
        return index;
    }

    private int getStartIndex(Token t) {
        Matcher m = p.matcher(this._input);
        int count = 0;
        for (int i = 1; m.find() && i < t.beginLine; ++i) {
            count = m.end(1);
        }
        return count + t.beginColumn - 1;
    }

    private int getEndIndex(Token t) {
        Matcher m = p.matcher(this._input);
        int count = 0;
        for (int i = 1; m.find() && i < t.endLine; ++i) {
            count = m.end(1);
        }
        return count + t.endColumn;
    }

    public String[][] getParameters(String input) {
        this.initParser(input);
        try {
            return this.routine_parameters();
        }
        catch (Throwable e) {
            this.logDebug(e.getMessage());
            return null;
        }
    }

    public String[] getDatatypeInfo(String input) {
        this.initParser(input);
        try {
            return this.datatype_info();
        }
        catch (Throwable e) {
            this.logDebug(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final Token string_literal() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(0);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            void var3_3;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 206: {
                    Token t = this.jj_consume_token(206);
                    break;
                }
                case 207: {
                    Token t = this.jj_consume_token(207);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            void var4_4 = var3_3;
            return var4_4;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void any_stmt_token() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(1);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            this.error_skiptobefore(new int[]{62, 223, 80}, STMT_START);
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Token id() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(2);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Token t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 211: 
                case 212: 
                case 217: {
                    t = this.idplus();
                    break;
                }
                case 214: 
                case 216: 
                case 240: {
                    t = this.variable();
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            Token token = t;
            return token;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void string() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(3);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 206: 
                case 207: {
                    this.string_literal();
                    return;
                }
                case 214: 
                case 216: 
                case 240: {
                    this.variable();
                    return;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (!(jjte000 instanceof ParseException)) throw (Error)jjte000;
            throw (ParseException)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final Token id_string() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(4);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Token t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 211: 
                case 212: 
                case 217: {
                    t = this.idplus();
                    break;
                }
                case 207: {
                    t = this.jj_consume_token(207);
                    break;
                }
                case 214: 
                case 216: 
                case 240: {
                    t = this.variable();
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            Token token = t;
            return token;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Token id_or_string() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(5);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            void var3_3;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 211: 
                case 212: 
                case 217: {
                    Token t = this.idplus();
                    break;
                }
                case 206: 
                case 207: {
                    Token t = this.string_literal();
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            void var4_4 = var3_3;
            return var4_4;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final String prefix() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(6);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Token t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 224: {
                    this.jj_consume_token(224);
                    break;
                }
                case 206: 
                case 207: 
                case 211: 
                case 212: 
                case 217: {
                    t = this.id_or_string();
                    this.jj_consume_token(224);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String string = t == null ? "." : t.image + ".";
            return string;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final String prefix_list() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(7);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String retval = "";
        String pre = "";
        try {
            do {
                pre = this.prefix();
                retval = retval + pre;
            } while (this.jj_2_1(Integer.MAX_VALUE));
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String string = retval;
            return string;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final String object() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(8);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String retval = "";
        try {
            if (this.jj_2_2(Integer.MAX_VALUE)) {
                retval = this.prefix_list();
            }
            Token t = this.id_or_string();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String string = retval + t.image;
            return string;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final Token idplus() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(9);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            void var3_3;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 211: {
                    Token t = this.jj_consume_token(211);
                    break;
                }
                case 217: {
                    Token t = this.jj_consume_token(217);
                    break;
                }
                case 212: {
                    Token t = this.jj_consume_token(212);
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            void var4_4 = var3_3;
            return var4_4;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Token variable() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(10);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            void var3_3;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 214: {
                    Token t = this.jj_consume_token(214);
                    break;
                }
                case 240: {
                    Token t = this.dyn_question_mark();
                    break;
                }
                case 216: {
                    Token t = this.jj_consume_token(216);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            void var4_4 = var3_3;
            return var4_4;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Token dyn_question_mark() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(11);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            Token t = this.jj_consume_token(240);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            Token token = t;
            return token;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int number() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(12);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        int retval = 0;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 239: {
                    this.jj_consume_token(239);
                    this.jj_consume_token(203);
                    try {
                        retval = Integer.parseInt("-" + this.getToken((int)0).image);
                    }
                    catch (Exception e) {}
                    break;
                }
                case 203: 
                case 238: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 238: {
                            this.jj_consume_token(238);
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(203);
                    try {
                        retval = Integer.parseInt(this.getToken((int)0).image);
                    }
                    catch (Exception e) {}
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            int n = retval;
            return n;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void constant() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(13);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 203: 
                case 204: 
                case 210: {
                    this.signed_const();
                    return;
                }
                case 112: 
                case 206: 
                case 207: 
                case 208: 
                case 214: 
                case 216: 
                case 240: {
                    this.unsigned_const();
                    return;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (!(jjte000 instanceof ParseException)) throw (Error)jjte000;
            throw (ParseException)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final Token signed_const() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(14);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            void var3_3;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 203: {
                    Token t = this.jj_consume_token(203);
                    break;
                }
                case 204: {
                    Token t = this.jj_consume_token(204);
                    break;
                }
                case 210: {
                    Token t = this.jj_consume_token(210);
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            void var4_4 = var3_3;
            return var4_4;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Token unsigned_const() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(15);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            void var3_3;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 208: {
                    Token t = this.jj_consume_token(208);
                    break;
                }
                case 206: 
                case 207: {
                    Token t = this.string_literal();
                    break;
                }
                case 112: {
                    Token t = this.null_stmt();
                    break;
                }
                case 214: 
                case 216: 
                case 240: {
                    Token t = this.variable();
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            void var4_4 = var3_3;
            return var4_4;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String literal() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(16);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        boolean negative = false;
        try {
            void var3_4;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 203: 
                case 204: 
                case 210: 
                case 238: 
                case 239: {
                    block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 238: 
                        case 239: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 238: {
                                    this.jj_consume_token(238);
                                    break block9;
                                }
                                case 239: {
                                    this.jj_consume_token(239);
                                    negative = true;
                                    break block9;
                                }
                            }
                            this.jj_la1[13] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                        }
                    }
                    Token t = this.signed_const();
                    break;
                }
                case 112: 
                case 206: 
                case 207: 
                case 208: 
                case 214: 
                case 216: 
                case 240: {
                    Token t = this.unsigned_const();
                    break;
                }
                case 211: 
                case 212: 
                case 217: {
                    Token t = this.idplus();
                    break;
                }
                case 133: {
                    Token t = this.jj_consume_token(133);
                    break;
                }
                case 76: {
                    Token t = this.jj_consume_token(76);
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String string = negative ? "-" + var3_4.image : var3_4.image;
            return string;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Token null_stmt() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(17);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            Token t = this.jj_consume_token(112);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            Token token = t;
            return token;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final String length_spec() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(18);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String retval = "";
        int n = 0;
        try {
            if (this.jj_2_3(2)) {
                this.jj_consume_token(234);
                n = this.number();
                retval = "(" + n;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 222: {
                        this.jj_consume_token(222);
                        n = this.number();
                        retval = retval + "," + n;
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                this.jj_consume_token(235);
                retval = retval + ")";
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String string = retval;
            return string;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final String datatype() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(19);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String retval = "";
        String l = "";
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 211: {
                    block13: while (true) {
                        Token t = this.jj_consume_token(211);
                        retval = retval.equals("") ? retval + t.image : retval + " " + t.image;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 211: {
                                continue block13;
                            }
                        }
                        break;
                    }
                    this.jj_la1[17] = this.jj_gen;
                    break;
                }
                case 212: {
                    Token t = this.jj_consume_token(212);
                    retval = retval + t.image;
                    break;
                }
                case 207: {
                    Token t = this.jj_consume_token(207);
                    retval = retval + t.image;
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            l = this.length_spec();
            retval = retval + l;
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String string = retval;
            return string;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final String[] datatype_info() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(20);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String name = null;
        String precision = null;
        String scale = null;
        int n = 0;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 211: {
                    block18: while (true) {
                        Token t = this.jj_consume_token(211);
                        name = name == null ? t.image : name + " " + t.image;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 211: {
                                continue block18;
                            }
                        }
                        break;
                    }
                    this.jj_la1[19] = this.jj_gen;
                    break;
                }
                case 212: {
                    Token t = this.jj_consume_token(212);
                    name = t.image;
                    break;
                }
                case 207: {
                    Token t = this.jj_consume_token(207);
                    name = t.image;
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (this.jj_2_4(2)) {
                this.jj_consume_token(234);
                n = this.number();
                precision = "" + n;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 222: {
                        this.jj_consume_token(222);
                        n = this.number();
                        scale = "" + n;
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                    }
                }
                this.jj_consume_token(235);
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            if (scale != null) {
                String[] stringArray = new String[]{name, precision, scale};
                return stringArray;
            }
            if (precision != null) {
                String[] stringArray = new String[]{name, precision};
                return stringArray;
            }
            String[] stringArray = new String[]{name};
            return stringArray;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final String[] parameter() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(21);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Token name = null;
        String defaultValue = null;
        String type = null;
        int direction = 0;
        try {
            try {
                block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 214: {
                        name = this.jj_consume_token(214);
                        type = this.datatype();
                        defaultValue = this.optional_param_default();
                        direction = this.param_options();
                        break;
                    }
                    case 88: 
                    case 90: 
                    case 125: 
                    case 207: 
                    case 211: 
                    case 212: 
                    case 216: 
                    case 217: 
                    case 240: {
                        direction = 0;
                        block9 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 88: 
                            case 90: 
                            case 125: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 88: {
                                        this.jj_consume_token(88);
                                        break block9;
                                    }
                                    case 125: {
                                        direction = 1;
                                        this.jj_consume_token(125);
                                        break block9;
                                    }
                                    case 90: {
                                        direction = 2;
                                        this.jj_consume_token(90);
                                        break block9;
                                    }
                                }
                                this.jj_la1[22] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[23] = this.jj_gen;
                            }
                        }
                        name = this.id_string();
                        type = this.datatype();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 52: {
                                this.jj_consume_token(52);
                                defaultValue = this.procparmdefault();
                                break block3;
                            }
                        }
                        this.jj_la1[24] = this.jj_gen;
                        break;
                    }
                    case 199: {
                        name = this.jj_consume_token(199);
                        break;
                    }
                    case 198: {
                        name = this.jj_consume_token(198);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (ParseException e) {
                this.error_skiptobefore(new int[0], new int[]{222, 235, 195, 18, 23});
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String[] param = new String[]{name.toString(), defaultValue};
            String[] stringArray = param;
            return stringArray;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final String optional_param_default() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(22);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String t = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 231: {
                    this.jj_consume_token(231);
                    t = this.literal();
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String string = t;
            return string;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final int param_options() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(23);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        int direction = 0;
        try {
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 88: 
                case 125: 
                case 126: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 88: {
                            this.jj_consume_token(88);
                            break block2;
                        }
                        case 125: 
                        case 126: {
                            this.out_option();
                            direction = 1;
                            break block2;
                        }
                    }
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            int n = direction;
            return n;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void out_option() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(24);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 125: {
                    this.jj_consume_token(125);
                    return;
                }
                case 126: {
                    this.jj_consume_token(126);
                    return;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void any_chars() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(25);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            this.token_source.SwitchTo(3);
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void create_proc_header() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(26);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.jj_consume_token(45);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 136: {
                    this.jj_consume_token(136);
                    break;
                }
                case 137: {
                    this.jj_consume_token(137);
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.any_chars();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void create_func_header() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(27);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.jj_consume_token(45);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 78: {
                    this.jj_consume_token(78);
                    break;
                }
                case 79: {
                    this.jj_consume_token(79);
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.any_chars();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void create_trigger_header() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(28);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.jj_consume_token(45);
            this.jj_consume_token(179);
            this.any_chars();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void create_event_header() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(29);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.jj_consume_token(45);
            this.jj_consume_token(72);
            this.any_chars();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final String[][] parameters() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(30);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        ArrayList<String[]> params = new ArrayList<String[]>();
        String[] param = new String[2];
        try {
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 88: 
                case 90: 
                case 125: 
                case 198: 
                case 199: 
                case 207: 
                case 211: 
                case 212: 
                case 214: 
                case 216: 
                case 217: 
                case 234: 
                case 240: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 234: {
                            this.jj_consume_token(234);
                            break;
                        }
                        default: {
                            this.jj_la1[32] = this.jj_gen;
                        }
                    }
                    param = this.parameter();
                    params.add(param);
                    block17: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 222: {
                                break;
                            }
                            default: {
                                this.jj_la1[33] = this.jj_gen;
                                break block17;
                            }
                        }
                        this.jj_consume_token(222);
                        param = this.parameter();
                        params.add(param);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 235: {
                            this.jj_consume_token(235);
                            break block2;
                        }
                    }
                    this.jj_la1[34] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String[][] stringArray = (String[][])params.toArray((T[])new String[params.size()][2]);
            return stringArray;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final String[][] routine_parameters() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(31);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String[][] params = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: {
                    this.jj_consume_token(45);
                    break;
                }
                case 15: {
                    this.jj_consume_token(15);
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 136: {
                    this.jj_consume_token(136);
                    break;
                }
                case 137: {
                    this.jj_consume_token(137);
                    break;
                }
                case 78: {
                    this.jj_consume_token(78);
                    break;
                }
                case 79: {
                    this.jj_consume_token(79);
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.object();
            params = this.parameters();
            this.any_chars();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            String[][] stringArray = params;
            return stringArray;
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String procparmdefault() throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(32);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            String string;
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            Token start = this.getToken(1);
            int startIndex = this.getStartIndex(start);
            boolean match = false;
            block4: do {
                this.error_skiptobefore(new int[0], new int[]{222, 235});
                Token end = this.getToken(1);
                Token next = this.getToken(2);
                if (end == null || next == null) {
                    match = true;
                    break;
                }
                if (end.kind == 0 || end.kind == 222) {
                    match = true;
                    break;
                }
                if (end.kind != 235) continue;
                for (int i = 0; i < WATCOM_POST_PARAM.length; ++i) {
                    if (!WATCOM_POST_PARAM[i].equalsIgnoreCase(next.image)) continue;
                    match = true;
                    continue block4;
                }
            } while (!match);
            int endIndex = this.getEndIndex(this.getToken(0));
            if (endIndex > startIndex) {
                string = this._input.substring(startIndex, endIndex);
                return string;
            }
            string = null;
            return string;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void error_skiptobefore(int[] tokinds, int[] beforekinds) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(33);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            boolean match = false;
            Token t1 = this.getToken(0);
            do {
                int i;
                boolean bl = match = this.token.kind == 0 || this.getToken((int)1).kind == 0;
                if (match) break;
                for (i = 0; i < tokinds.length; ++i) {
                    boolean bl2 = match = match || this.token.kind == tokinds[i];
                    if (match) break;
                }
                if (match) break;
                for (i = 0; i < beforekinds.length; ++i) {
                    boolean bl3 = match = match || this.getToken((int)1).kind == beforekinds[i];
                    if (match) break;
                }
                if (match) continue;
                this.logDebug("current token:" + this.token.image);
                this.getNextToken();
            } while (!match);
            Token t2 = this.getToken(0);
            if (t1 == t2) {
                this.logDebug("current token:" + this.token.image);
                this.getNextToken();
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void error_skiptobefore1(String[] tokinds, String[] beforekinds, boolean force) throws ParseException {
        SimpleNode jjtn000 = new SimpleNode(34);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            boolean match = false;
            Token t1 = this.getToken(0);
            do {
                int i;
                boolean bl = match = this.token.kind == 0 || this.getToken((int)1).kind == 0;
                if (match) break;
                for (i = 0; i < tokinds.length; ++i) {
                    boolean bl2 = match = match || tokinds[i].equalsIgnoreCase(this.token.image);
                    if (match) break;
                }
                if (match) break;
                for (i = 0; i < beforekinds.length; ++i) {
                    boolean bl3 = match = match || beforekinds[i].equalsIgnoreCase(this.getToken((int)1).image);
                    if (match) break;
                }
                if (match) continue;
                this.logDebug("current token:" + this.token.image);
                this.getNextToken();
            } while (!match);
            Token t2 = this.getToken(0);
            if (t1 == t2 && force) {
                this.logDebug("current token:" + this.token.image);
                this.getNextToken();
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    private final boolean jj_3R_11() {
        return this.jj_3R_13();
    }

    private final boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_11()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_12()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(206)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(207)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_6() {
        return this.jj_3R_8();
    }

    private final boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_6()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(224);
    }

    private final boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(238)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(203);
    }

    private final boolean jj_3R_9() {
        return this.jj_scan_token(239);
    }

    private final boolean jj_3R_5() {
        return this.jj_3R_8();
    }

    private final boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_5()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(224);
    }

    private final boolean jj_3R_12() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_9()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_10()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(211)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(217)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(212)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_scan_token(234)) {
            return true;
        }
        return this.jj_3R_7();
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(234)) {
            return true;
        }
        return this.jj_3R_7();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32768, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 0, 0, 0x5000000, 0x5000000, 0, 0x5000000, 0, 0x1000000, 0x1000000, 0, 0, 49152, 0, 0, 0, 0x5000000, 0, 49152};
    }

    private static void jj_la1_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 0, 65536, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 0x20000000, 0x20000000, 0, 0x20000000, 0, 0x60000000, 0x60000000, 0x60000000, 0, 0, 0, 0, 0, 0x20000000, 0, 0};
    }

    private static void jj_la1_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 768, 0, 0, 0, 0, 0, 0, 768};
    }

    private static void jj_la1_5() {
        jj_la1_5 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_6() {
        jj_la1_6 = new int[]{49152, 56098816, 21020672, 56131584, 35176448, 35176448, 35127296, 0x1400000, 0, 2048, 21354496, 268288, 21086208, 0, 0, 56481792, 0x40000000, 524288, 0x188000, 524288, 0x188000, 0x40000000, 0, 0, 0, 56131776, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 56131776, 0, 0};
    }

    private static void jj_la1_7() {
        jj_la1_7 = new int[]{0, 65536, 65536, 65536, 0, 1, 0, 65536, 16384, 49152, 65536, 0, 65536, 49152, 49152, 114688, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 128, 0, 0, 0, 0, 0, 1024, 0, 2048, 66560, 0, 0};
    }

    public QuickSQLParser(InputStream stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new QuickSQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public QuickSQLParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new QuickSQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public QuickSQLParser(QuickSQLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(QuickSQLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[244];
        for (i = 0; i < 244; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 38; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) != 0) {
                    la1tokens[160 + j] = true;
                }
                if ((jj_la1_6[i] & 1 << j) != 0) {
                    la1tokens[192 + j] = true;
                }
                if ((jj_la1_7[i] & 1 << j) == 0) continue;
                la1tokens[224 + j] = true;
            }
        }
        for (i = 0; i < 244; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        QuickSQLParser.jj_la1_0();
        QuickSQLParser.jj_la1_1();
        QuickSQLParser.jj_la1_2();
        QuickSQLParser.jj_la1_3();
        QuickSQLParser.jj_la1_4();
        QuickSQLParser.jj_la1_5();
        QuickSQLParser.jj_la1_6();
        QuickSQLParser.jj_la1_7();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

