/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.editor.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.reference.ITable;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;

public class SQLDBProposalsRequest {
    private String _prefix;
    private int _scope;
    private ParsingResult _result;
    private String _database;
    private String _schema;
    private String _defaultSchema;
    private String _table;
    private HashMap _refTables;

    public SQLDBProposalsRequest(String tokens, int scope, String defaultSchema, ParsingResult result) {
        this._prefix = tokens;
        this._scope = scope;
        this._result = result;
        this._defaultSchema = defaultSchema;
        this.init();
    }

    private void init() {
        Object objects = null;
        String[] tokens = SQLUtil.splitDotStr((String)this._prefix);
        int count = tokens.length;
        boolean i = false;
        switch (count) {
            case 4: {
                this._database = tokens[0];
                this._schema = tokens[1];
                this._table = tokens[2];
                break;
            }
            case 3: {
                if (tokens[1] == null) {
                    this._database = tokens[0];
                    this._table = tokens[2];
                    break;
                }
                if (this._scope == 32) {
                    this._schema = tokens[0];
                    this._table = tokens[1];
                    break;
                }
                if (this._scope != 8) break;
                this._database = tokens[0];
                this._schema = tokens[1];
                this._table = tokens[2];
                break;
            }
            case 2: {
                if (this._scope == 32) {
                    this._table = tokens[0];
                    break;
                }
                if (this._scope == 2) {
                    this._database = tokens[0];
                    this._schema = tokens[1];
                    break;
                }
                this._schema = tokens[0];
                break;
            }
        }
        this._scope = this.determineProposalType();
    }

    public String getDatabase() {
        return this._database;
    }

    public String getSchema() {
        if (this._schema == null) {
            return this._defaultSchema;
        }
        return this._schema;
    }

    public String getTable() {
        return this._table;
    }

    public String getRealTable() {
        if (this._table == null) {
            return null;
        }
        List ctx = this.getContextTables();
        Iterator iter = ctx.iterator();
        while (iter.hasNext()) {
            ITable table = (ITable)iter.next();
            if (!this._table.equals(table.getAliasName())) continue;
            return table.getName();
        }
        return this._table;
    }

    protected int determineProposalType() {
        int proposalType = this.getScope();
        if (this.getSchema() == null) {
            proposalType = 4;
        } else if (proposalType == 32) {
            proposalType = this.getTable() == null && this.getContextTables().isEmpty() ? 8 : (proposalType |= 8);
        }
        return proposalType;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public int getScope() {
        return this._scope;
    }

    public List getContextTables() {
        if (this._result != null) {
            return this._result.getCurrentTables();
        }
        return new ArrayList();
    }
}

