/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IDriverMgmtConstants;
import org.eclipse.datatools.connectivity.drivers.IDriverValuesProvider;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.XMLFileManager;
import org.eclipse.datatools.connectivity.drivers.models.OverrideTemplateDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class DriverManager {
    private static DriverManager sInstance;
    private static HashMap mDriverInstanceMap;
    private static boolean refreshDriverMap;
    private static String DRIVER_MARKER_FILE_NAME;
    private static boolean mDebug;

    static {
        refreshDriverMap = false;
        DRIVER_MARKER_FILE_NAME = "driverManagerPreferences.xml";
        mDebug = ConnectivityPlugin.getDefault().isDebugging();
    }

    public static synchronized DriverManager getInstance() {
        if (sInstance == null) {
            sInstance = new DriverManager();
        }
        return sInstance;
    }

    private synchronized void loadAllInstances() {
        this.loadAllInstances(true);
    }

    private synchronized void loadAllInstances(boolean migrate) {
        DriverManager.debug("loadAllInstances: migrate = " + migrate);
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            IPropertySet[] psets = XMLFileManager.loadPropertySets();
            if (psets.length > 0) {
                boolean changed = false;
                int i = 0;
                while (i < psets.length) {
                    IPropertySet pset = psets[i];
                    DriverInstance ndi = new DriverInstance(pset);
                    if (migrate) {
                        changed = ndi.migrate();
                    }
                    if (changed) {
                        IPropertySet migratedPset = ndi.getPropertySet();
                        DriverManager.debug("loadAllInstances: migrated di = " + migratedPset.getID());
                        psets[i] = migratedPset;
                        DriverInstance mndi = new DriverInstance(migratedPset);
                        mDriverInstanceMap.put(mndi.getId(), mndi);
                        this.saveChanges(psets);
                        refreshDriverMap = true;
                    } else {
                        mDriverInstanceMap.put(ndi.getId(), ndi);
                    }
                    ++i;
                }
                return;
            }
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
    }

    private void saveChanges(IPropertySet[] psets) {
        DriverManager.debug("saveChanges");
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            XMLFileManager.saveNamedPropertySet(psets);
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
    }

    private DriverManager() {
        this.resetDefaultInstances();
    }

    private DriverInstance getDriverInstanceFromMapByName(String name) {
        if (mDriverInstanceMap.containsKey(name)) {
            return (DriverInstance)mDriverInstanceMap.get(name);
        }
        return null;
    }

    private DriverInstance getDriverInstanceFromMapByID(String id) {
        Iterator iter = mDriverInstanceMap.values().iterator();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            if (!di.getId().equals(id)) continue;
            return di;
        }
        return null;
    }

    private DriverInstance[] getDriverInstancesFromMapByCategoryID(String categoryid) {
        Iterator iter = mDriverInstanceMap.values().iterator();
        ArrayList<DriverInstance> list = new ArrayList<DriverInstance>();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            if (!di.getTemplate().getParent().getId().equals(categoryid)) continue;
            list.add(di);
        }
        return list.toArray(new DriverInstance[list.size()]);
    }

    private DriverInstance[] getDriverInstancesFromMapForTemplateID(String templateid) {
        Iterator iter = mDriverInstanceMap.values().iterator();
        ArrayList<DriverInstance> list = new ArrayList<DriverInstance>();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            if (!di.getTemplate().getId().equals(templateid)) continue;
            list.add(di);
        }
        return list.toArray(new DriverInstance[list.size()]);
    }

    public DriverInstance getDriverInstanceByID(String id) {
        DriverInstance di = this.getDriverInstanceFromMapByID(id);
        if (di == null) {
            XMLFileManager.setFileName("driverStorage.xml");
            try {
                IPropertySet[] psets = XMLFileManager.loadPropertySets();
                if (psets.length > 0) {
                    int i = 0;
                    while (i < psets.length) {
                        IPropertySet pset = psets[i];
                        if (pset.getID().equals(id)) {
                            di = new DriverInstance(pset);
                            mDriverInstanceMap.put(di.getId(), di);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return di;
    }

    public DriverInstance[] getDriverInstancesByCategory(String categoryid) {
        return this.getDriverInstancesFromMapByCategoryID(categoryid);
    }

    public DriverInstance[] getDriverInstancesByTemplate(String templateid) {
        return this.getDriverInstancesFromMapForTemplateID(templateid);
    }

    public DriverInstance getDriverInstanceByName(String name) {
        DriverInstance di = this.getDriverInstanceFromMapByName(name);
        if (di == null) {
            XMLFileManager.setFileName("driverStorage.xml");
            try {
                IPropertySet[] psets = XMLFileManager.loadPropertySets();
                if (psets.length > 0) {
                    int i = 0;
                    while (i < psets.length) {
                        IPropertySet pset = psets[i];
                        if (pset.getName().equals(name)) {
                            di = new DriverInstance(pset);
                            mDriverInstanceMap.put(di.getId(), di);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return di;
    }

    public String getFullJarList() {
        Object[] drivers = mDriverInstanceMap.values().toArray();
        String fullList = "";
        int x = 0;
        while (x < drivers.length) {
            DriverInstance di = (DriverInstance)drivers[x];
            if (di.getJarList() != null) {
                String jarlist = di.getJarList().trim();
                if (fullList.trim().length() > 0) {
                    fullList = String.valueOf(fullList) + IDriverMgmtConstants.PATH_DELIMITER;
                }
                fullList = String.valueOf(fullList) + jarlist + IDriverMgmtConstants.PATH_DELIMITER;
            }
            if (fullList.substring(fullList.length() - 1, fullList.length()).equals(IDriverMgmtConstants.PATH_DELIMITER)) {
                fullList = fullList.substring(0, fullList.length() - 1);
            }
            ++x;
        }
        if (fullList.trim().length() > 0) {
            String[] paths = this.parseString(fullList, IDriverMgmtConstants.PATH_DELIMITER);
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < paths.length) {
                File testFile = new File(paths[i]);
                if (testFile.exists() && !list.contains(paths[i])) {
                    list.add(paths[i]);
                }
                ++i;
            }
            String newList = "";
            Iterator iter2 = list.iterator();
            while (iter2.hasNext()) {
                newList = String.valueOf(newList) + iter2.next() + IDriverMgmtConstants.PATH_DELIMITER;
            }
            if (newList.length() > 0 && newList.substring(newList.length() - 1, newList.length()).equals(IDriverMgmtConstants.PATH_DELIMITER)) {
                newList = newList.substring(0, newList.length() - 1);
            }
            return newList;
        }
        return null;
    }

    public String[] getFullJarListAsArray() {
        if (this.getFullJarList() != null) {
            if (this.getFullJarList().length() == 0) {
                return new String[0];
            }
            String[] paths = this.parseString(this.getFullJarList(), IDriverMgmtConstants.PATH_DELIMITER);
            return paths;
        }
        return null;
    }

    public DriverInstance[] getValidDriverInstances() {
        DriverInstance[] array = new DriverInstance[]{};
        Iterator iter = mDriverInstanceMap.values().iterator();
        ArrayList<DriverInstance> list = new ArrayList<DriverInstance>();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            DriverValidator validator = new DriverValidator(di);
            if (!validator.isValid()) continue;
            list.add(di);
        }
        array = new DriverInstance[list.size()];
        int i = 0;
        while (i < list.size()) {
            array[i] = (DriverInstance)list.get(i);
            ++i;
        }
        return array;
    }

    public DriverInstance[] getAllDriverInstances() {
        return mDriverInstanceMap.values().toArray(new DriverInstance[mDriverInstanceMap.values().size()]);
    }

    private IPropertySet[] getPropertySetsFromMap() {
        Iterator iter = mDriverInstanceMap.values().iterator();
        ArrayList<IPropertySet> list = new ArrayList<IPropertySet>();
        while (iter.hasNext()) {
            DriverInstance di = (DriverInstance)iter.next();
            list.add(di.getPropertySet());
        }
        return list.toArray(new IPropertySet[list.size()]);
    }

    public DriverInstance createNewDriverInstance(String templateID, String name, String jarList) {
        if (templateID == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        IPropertySet pset = this.createDefaultInstance(templateID);
        if (pset == null) {
            return null;
        }
        if (name != null) {
            pset.setName(name);
        }
        String prefix = DriverMgmtMessages.getString("NewDriverDialog.text.id_prefix");
        String id = String.valueOf(prefix) + templateID + "." + name;
        pset.setID(id);
        Properties props = pset.getBaseProperties();
        if (jarList != null) {
            props.setProperty("jarList", jarList);
        }
        this.addDriverInstance(pset);
        return this.getDriverInstanceByID(pset.getID());
    }

    public boolean removeDriverInstance(String id) {
        boolean rtnFlag = false;
        if (this.getDriverInstanceByID(id) != null) {
            XMLFileManager.setFileName("driverStorage.xml");
            try {
                IPropertySet[] psets = XMLFileManager.loadPropertySets();
                if (psets.length > 0) {
                    IPropertySet[] newPsets = new IPropertySet[psets.length - 1];
                    int counter = 0;
                    int i = 0;
                    while (i < psets.length) {
                        IPropertySet pset = psets[i];
                        if (pset.getID().equals(id)) {
                            rtnFlag = true;
                            DriverValidator.removeOldProblemMarkers(pset.getName());
                        } else {
                            newPsets[counter] = pset;
                            ++counter;
                        }
                        ++i;
                    }
                    if (rtnFlag) {
                        XMLFileManager.saveNamedPropertySet(newPsets);
                        mDriverInstanceMap = new HashMap();
                        this.loadAllInstances();
                    }
                }
            }
            catch (CoreException e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
        return rtnFlag;
    }

    public void addDriverInstance(DriverInstance di) {
        mDriverInstanceMap.put(di.getId(), di);
        IPropertySet[] psets = this.getPropertySetsFromMap();
        XMLFileManager.setFileName("driverStorage.xml");
        try {
            XMLFileManager.saveNamedPropertySet(psets);
            mDriverInstanceMap = new HashMap();
            this.loadAllInstances();
        }
        catch (CoreException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
    }

    public void addDriverInstance(IPropertySet pset) {
        DriverInstance di = new DriverInstance(pset);
        this.addDriverInstance(di);
    }

    private String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    /*
     * Exception decompiling
     */
    private boolean wereDefaultDriversCreated() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 114->117)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean createDefaultDriversMarker() {
        IPath metadataPath = ConnectivityPlugin.getDefault().getStateLocation();
        File file = (metadataPath = metadataPath.append(DRIVER_MARKER_FILE_NAME)).toFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private boolean wasDefaultCreatedBefore(TemplateDescriptor td) {
        return ConnectivityPlugin.getDefault().getPluginPreferences().getBoolean(td.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetDefaultInstances() {
        DriverManager.debug("resetDefaultInstances");
        psets_list = new ArrayList<IPropertySet>();
        types = TemplateDescriptor.getDriverTemplateDescriptors();
        XMLFileManager.setFileName("driverStorage.xml");
        if (DriverManager.mDriverInstanceMap == null || DriverManager.refreshDriverMap) {
            DriverManager.debug("resetDefaultInstances: loading hash map");
            DriverManager.mDriverInstanceMap = new HashMap<K, V>();
            this.loadAllInstances(true);
            if (DriverManager.refreshDriverMap) {
                DriverManager.refreshDriverMap = false;
            }
        }
        this.wereDefaultDriversCreated();
        DriverManager.debug("resetDefaultInstances: checking for drivers to create by default");
        psets = this.getPropertySetsFromMap();
        i = 0;
        while (true) {
            block23: {
                if (i >= types.length) {
                    markerCreated = this.createDefaultDriversMarker();
                    DriverManager.debug("Marker created: " + markerCreated);
                    return;
                }
                type = types[i];
                alreadyExists = false;
                if (psets.length > 0) {
                    j = 0;
                    while (j < psets.length) {
                        pset = psets[j];
                        if (pset.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType") != null && (category = pset.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType")).equalsIgnoreCase(type.getId())) {
                            alreadyExists = true;
                            psets_list.add(pset);
                        }
                        ++j;
                    }
                }
                defaultExists = this.wasDefaultCreatedBefore(type);
                createDefaultValue = false;
                if (type.getValuesProviderClass() != null && (value = type.getValuesProviderClass().createDefaultValue("createDefault")) != null) {
                    createDefaultValue = Boolean.valueOf(value);
                }
                overrideDriverValsProvider = null;
                otds = OverrideTemplateDescriptor.getByDriverTemplate(type.getId());
                if (otds != null && otds.length > 0 && (overrideDriverValsProvider = otds[0].getValuesProviderClass()) != null && (value = overrideDriverValsProvider.createDefaultValue("createDefault")) != null) {
                    createDefaultValue = Boolean.valueOf(value);
                }
                DriverManager.debug("Default already exists for " + type.getId() + ": " + defaultExists);
                if ((createDefaultValue || type.getCreateDefaultFlag()) && !defaultExists && !alreadyExists) {
                    newPset = this.createDefaultInstance(type);
                    if (newPset != null) {
                        this.addDriverInstance(newPset);
                    }
                    ConnectivityPlugin.getDefault().getPluginPreferences().setValue(type.getId(), true);
                    metadataPath = ConnectivityPlugin.getDefault().getStateLocation();
                    metadataPath = metadataPath.append(DriverManager.DRIVER_MARKER_FILE_NAME);
                    file = metadataPath.toFile();
                    if (!file.exists()) {
                        try {
                            file.createNewFile();
                        }
                        catch (IOException v0) {}
                    }
                    fos = null;
                    try {
                        try {
                            fos = new FileOutputStream(file);
                            ConnectivityPlugin.getDefault().getPluginPreferences().store((OutputStream)fos, "DriverManager.Preferences");
                        }
                        catch (FileNotFoundException e) {
                            ConnectivityPlugin.getDefault().log(e);
                        }
                        catch (IOException e) {
                            ConnectivityPlugin.getDefault().log(e);
                        }
                    }
                    catch (Throwable var17_21) {
                        var16_19 = null;
                        if (fos == null) throw var17_21;
                        try {
                            fos.close();
                            throw var17_21;
                        }
                        catch (IOException e) {
                            ConnectivityPlugin.getDefault().log(e);
                        }
                        throw var17_21;
                    }
                    {
                        var16_19 = null;
                        if (fos == null) break block23;
                    }
                    ** try [egrp 3[TRYBLOCK] [6 : 503->511)] { 
lbl81:
                    // 1 sources

                    fos.close();
                    break block23;
lbl83:
                    // 1 sources

                    catch (IOException e) {
                        ConnectivityPlugin.getDefault().log(e);
                    }
                }
            }
            ++i;
        }
    }

    public IPropertySet createDefaultInstance(String id) {
        TemplateDescriptor template = TemplateDescriptor.getDriverTemplateDescriptor(id);
        IPropertySet pset = this.createInstance(template);
        return pset;
    }

    private IPropertySet createInstance(TemplateDescriptor template) {
        return this.createDefaultInstance(template, true);
    }

    private IPropertySet createDefaultInstance(TemplateDescriptor template) {
        return this.createDefaultInstance(template, false);
    }

    private IPropertySet createDefaultInstance(TemplateDescriptor template, boolean override) {
        String overrideValsCreateDefault;
        String valsCreateDefault;
        IDriverValuesProvider driverValsProvider = null;
        IDriverValuesProvider overrideDriverValsProvider = null;
        OverrideTemplateDescriptor[] otds = null;
        if (template != null) {
            DriverManager.debug("Creating Default Instance of " + template.getId());
            otds = OverrideTemplateDescriptor.getByDriverTemplate(template.getId());
            if (otds != null && otds.length > 0 && (overrideDriverValsProvider = otds[0].getValuesProviderClass()) != null) {
                DriverManager.debug("Have a driver values provider from the override");
            }
            if ((driverValsProvider = template.getValuesProviderClass()) != null) {
                DriverManager.debug("Have a driver values provider from the template");
            }
        }
        boolean createDefault = template != null ? template.getCreateDefaultFlag() : false;
        DriverManager.debug("Create Default from the template is " + createDefault);
        if (driverValsProvider != null && (valsCreateDefault = driverValsProvider.createDefaultValue("createDefault")) != null) {
            createDefault = Boolean.valueOf(valsCreateDefault);
            DriverManager.debug("Create Default was reset to " + valsCreateDefault + " by the driver values provider");
        }
        if (overrideDriverValsProvider != null && (overrideValsCreateDefault = overrideDriverValsProvider.createDefaultValue("createDefault")) != null) {
            createDefault = Boolean.valueOf(overrideValsCreateDefault);
            DriverManager.debug("Create Default was reset to " + overrideValsCreateDefault + " by the override driver values provider");
        }
        if (template != null && (createDefault || override)) {
            String prefix = DriverMgmtMessages.getString("NewDriverDialog.text.id_prefix");
            String suffix = DriverMgmtMessages.getString("DriverMgmtPlugin.default_instance_suffix");
            String name = String.valueOf(template.getDefaultDefinitionName()) + " " + suffix;
            String id = String.valueOf(prefix) + template.getId() + "." + name;
            DriverManager.debug("Default driver name from the template is " + name);
            if (driverValsProvider != null) {
                String driverValsDefaultDefinitionName;
                String driverValsName = driverValsProvider.createDefaultValue("name");
                if (driverValsName != null) {
                    name = driverValsName;
                    DriverManager.debug("Driver name was reset to " + driverValsName + " by the driver values provider");
                }
                if ((driverValsDefaultDefinitionName = driverValsProvider.createDefaultValue("defaultDefinitionName")) != null) {
                    name = driverValsDefaultDefinitionName;
                    DriverManager.debug("Driver name was reset to " + driverValsDefaultDefinitionName + " (Default Definition Name) by the driver values provider");
                }
            }
            if (overrideDriverValsProvider != null) {
                String overrideDriverValsDefaultDefinitionName;
                String overrideDriverValsName = overrideDriverValsProvider.createDefaultValue("name");
                if (overrideDriverValsName != null) {
                    name = overrideDriverValsName;
                    DriverManager.debug("Driver name was reset to " + overrideDriverValsName + " by the override driver values provider");
                }
                if ((overrideDriverValsDefaultDefinitionName = overrideDriverValsProvider.createDefaultValue("defaultDefinitionName")) != null) {
                    name = overrideDriverValsDefaultDefinitionName;
                    DriverManager.debug("Driver name was reset to " + overrideDriverValsDefaultDefinitionName + " (Default Definition Name) by the override driver values provider");
                }
            }
            PropertySetImpl propset = new PropertySetImpl(id, template.getName());
            propset.setID(id);
            propset.setName(name);
            Properties props = new Properties();
            String jarList = "";
            String valsJarList = null;
            String overrideValsJarList = null;
            if (driverValsProvider != null && (valsJarList = driverValsProvider.createDefaultValue("jarList")) != null) {
                jarList = valsJarList;
                DriverManager.debug("Jar list was reset to " + valsJarList + " by the driver values provider");
            }
            if (overrideDriverValsProvider != null && (overrideValsJarList = overrideDriverValsProvider.createDefaultValue("jarList")) != null) {
                jarList = overrideValsJarList;
                DriverManager.debug("Jar list was reset to " + overrideValsJarList + " by the override driver values provider");
            }
            if (valsJarList == null && overrideValsJarList == null) {
                jarList = this.updatePluginJarList(template);
                DriverManager.debug("Default jar list from the template is " + jarList);
            }
            props.setProperty("jarList", jarList);
            props.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", template.getId());
            IConfigurationElement[] templateprops = template.getProperties();
            if (props != null && templateprops.length > 0) {
                int i = 0;
                while (i < templateprops.length) {
                    String overrideValsPropValue;
                    String valsPropValue;
                    IConfigurationElement prop = templateprops[i];
                    String propid = prop.getAttribute("id");
                    String propvalue = prop.getAttribute("value");
                    DriverManager.debug("Default Value of property " + propid + " from the template is " + propvalue);
                    boolean removeIt = false;
                    if (driverValsProvider != null && (valsPropValue = driverValsProvider.createDefaultValue(propid)) != null) {
                        propvalue = valsPropValue;
                        DriverManager.debug("Value of property " + propid + " was reset to " + valsPropValue + " by the driver values provider");
                    }
                    if (otds != null && otds.length > 0) {
                        String temp = otds[0].getPropertyValueFromId(propid);
                        if (temp != null && temp.length() > 0) {
                            propvalue = temp;
                            DriverManager.debug("Value of property " + propid + " was reset to " + temp + " by a driver override");
                        }
                        if (otds[0].getPropertyRemoveFlagFromID(propid)) {
                            removeIt = true;
                            DriverManager.debug("Property " + propid + " was removed by a driver override");
                        }
                    }
                    if (overrideDriverValsProvider != null && (overrideValsPropValue = overrideDriverValsProvider.createDefaultValue(propid)) != null) {
                        propvalue = overrideValsPropValue;
                        DriverManager.debug("Value of property " + propid + " was reset to " + overrideValsPropValue + " by the override driver values provider");
                    }
                    if (!removeIt) {
                        props.setProperty(propid, propvalue == null ? new String() : propvalue);
                    } else {
                        props.remove(propid);
                    }
                    ++i;
                }
            }
            propset.setBaseProperties(props);
            return propset;
        }
        return null;
    }

    public String updatePluginJarList(TemplateDescriptor template) {
        String jarList = template.getJarList();
        if (jarList.indexOf("[") > -1) {
            int index = jarList.indexOf(IDriverMgmtConstants.PATH_DELIMITER, 0);
            if (index <= 0) {
                index = jarList.indexOf(",", 0);
                if (index > 0) {
                    jarList = jarList.replace(',', IDriverMgmtConstants.PATH_DELIMITER_CHAR);
                } else {
                    index = jarList.indexOf(";", 0);
                    if (index > 0) {
                        jarList = jarList.replace(';', IDriverMgmtConstants.PATH_DELIMITER_CHAR);
                    }
                }
            }
            index = jarList.indexOf("[");
            while (index > -1) {
                String toReplace = jarList.substring(index, jarList.indexOf("]", index) + 1);
                String pluginId = null;
                pluginId = toReplace.toUpperCase().equals("[PLUGIN]") ? template.getElement().getContributor().getName() : toReplace.substring(1, toReplace.length() - 1);
                String restOfPath = null;
                restOfPath = jarList.indexOf(IDriverMgmtConstants.PATH_DELIMITER, index) > 0 ? jarList.substring(jarList.indexOf("]", index) + 1, jarList.indexOf(IDriverMgmtConstants.PATH_DELIMITER, index)) : (jarList.indexOf(",", index) > 0 ? jarList.substring(jarList.indexOf("]", index) + 1, jarList.indexOf(",", index)) : (jarList.indexOf(";", index) > 0 ? jarList.substring(jarList.indexOf("]", index) + 1, jarList.indexOf(";", index)) : jarList.substring(jarList.indexOf("]", index) + 1, jarList.length())));
                if (Platform.getBundle((String)pluginId) != null) {
                    Object[] strs;
                    String entry = String.valueOf(File.separator) + restOfPath + File.separator;
                    URL url = Platform.getBundle((String)pluginId).getEntry(entry);
                    if (url != null) {
                        try {
                            url = FileLocator.toFileURL((URL)url);
                            Path path = new Path(url.getFile());
                            int totalLength = toReplace.length() + restOfPath.length();
                            jarList = String.valueOf(jarList.substring(0, index)) + path.toOSString() + jarList.substring(index + totalLength, jarList.length());
                        }
                        catch (IOException iOException) {
                            strs = new String[]{String.valueOf(pluginId) + restOfPath};
                            System.err.println(DriverMgmtMessages.format("DriverMgmtPlugin.FileMissing", strs));
                            ConnectivityPlugin.getDefault().log(DriverMgmtMessages.format("DriverMgmtPlugin.FileMissing", strs));
                        }
                    } else {
                        strs = new String[]{String.valueOf(pluginId) + restOfPath};
                        String msg = DriverMgmtMessages.format("DriverMgmtPlugin.FileMissing", strs);
                        System.err.println(msg);
                        ConnectivityPlugin.getDefault().log(msg);
                    }
                } else {
                    Object[] strs = new String[]{pluginId};
                    System.err.println(DriverMgmtMessages.format("DriverMgmtPlugin.BundleMissing", strs));
                    ConnectivityPlugin.getDefault().log(DriverMgmtMessages.format("DriverMgmtPlugin.BundleMissing", strs));
                }
                index = jarList.indexOf(IDriverMgmtConstants.PATH_DELIMITER, index);
                if (index <= 0) continue;
                ++index;
            }
        } else {
            int index = jarList.indexOf(IDriverMgmtConstants.PATH_DELIMITER, 0);
            if (index > 0) {
                return jarList;
            }
            index = jarList.indexOf(",", 0);
            if (index > 0) {
                jarList = jarList.replace(',', IDriverMgmtConstants.PATH_DELIMITER_CHAR);
            } else {
                index = jarList.indexOf(";", 0);
                if (index > 0) {
                    jarList = jarList.replace(';', IDriverMgmtConstants.PATH_DELIMITER_CHAR);
                }
            }
        }
        return jarList;
    }

    public static void debug(String msg) {
        if (mDebug) {
            System.out.println("Debug: " + msg);
        }
    }
}

