/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.postgresql.profile.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.datatools.connectivity.db.generic.GenericDBPlugin;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.connectivity.internal.ui.DriverListCombo;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PostgreSQLProfileDetailsWizardPage
extends ConnectionProfileDetailsPage {
    private Text mDatabaseNameText;
    private Text mURLText;
    private Text mDBUIDText;
    private Text mDBPWDText;
    private Button mSaveDBPWDCheckbox;
    private DelimitedStringList mDBConnProps;
    final DriverListCombo combo = new DriverListCombo();
    private DriverInstance mDriverInstance;
    private String mDriverCategory;

    public PostgreSQLProfileDetailsWizardPage(String pageName) {
        super(pageName);
        this.setTitle(GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.title"));
        this.setDescription(GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.msg"));
        this.setDriverCategory("org.eclipse.datatools.connectivity.db.driverCategory");
    }

    public void createCustomControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        content.setLayout((Layout)layout);
        this.combo.setLabelText(GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.driverCombo.label"));
        this.combo.setCategory(this.getDriverCategory());
        this.combo.setNullDriverIsValid(false);
        this.combo.createContents(content);
        if (this.combo.getErrorMessage() != null) {
            this.setErrorMessage(this.combo.getErrorMessage());
        }
        this.mDatabaseNameText = (Text)this.createLabelTextPair(content, GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.databaseName.label"), (Control)this.mURLText, 2048, 768);
        this.mURLText = (Text)this.createLabelTextPair(content, GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.url.label"), (Control)this.mURLText, 2048, 768);
        this.mDBUIDText = (Text)this.createLabelTextPair(content, GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.userName.label"), (Control)this.mDBUIDText, 2048, 768);
        this.mDBPWDText = (Text)this.createLabelTextPair(content, GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.password.label"), (Control)this.mDBPWDText, 0x400800, 768);
        this.mSaveDBPWDCheckbox = new Button(content, 32);
        this.mSaveDBPWDCheckbox.setText(GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.persistpassword.label"));
        this.mSaveDBPWDCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        Composite spacer = new Composite(content, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        gdata.heightHint = 20;
        spacer.setLayoutData((Object)gdata);
        Label label = new Label(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        label.setLayoutData((Object)gdata);
        label.setText(GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.optionalProps.label"));
        this.mDBConnProps = new DelimitedStringList(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.mDBConnProps.setLayoutData((Object)gdata);
        if (this.mDriverInstance == null) {
            this.mDriverInstance = this.combo.getSelectedDriverInstance();
        }
        if (this.mDriverInstance != null) {
            this.mURLText.setText(this.getDriverURL());
        }
        this.mDBConnProps.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                PostgreSQLProfileDetailsWizardPage.this.setErrorMessage(null);
                if (PostgreSQLProfileDetailsWizardPage.this.mDBConnProps.getWarning() != null) {
                    PostgreSQLProfileDetailsWizardPage.this.setErrorMessage(PostgreSQLProfileDetailsWizardPage.this.mDBConnProps.getWarning());
                }
            }
        });
        this.combo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                PostgreSQLProfileDetailsWizardPage.this.mDriverInstance = PostgreSQLProfileDetailsWizardPage.this.combo.getSelectedDriverInstance();
                PostgreSQLProfileDetailsWizardPage.this.setErrorMessage(null);
                if (PostgreSQLProfileDetailsWizardPage.this.combo.getErrorMessage() != null) {
                    PostgreSQLProfileDetailsWizardPage.this.setErrorMessage(PostgreSQLProfileDetailsWizardPage.this.combo.getErrorMessage());
                }
                PostgreSQLProfileDetailsWizardPage.this.mDatabaseNameText.setText(PostgreSQLProfileDetailsWizardPage.this.getDriverDatabaseName());
                PostgreSQLProfileDetailsWizardPage.this.mURLText.setText(PostgreSQLProfileDetailsWizardPage.this.getDriverURL());
                String username = PostgreSQLProfileDetailsWizardPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.username");
                if (username == null || username.trim().length() == 0) {
                    username = new String();
                }
                PostgreSQLProfileDetailsWizardPage.this.mDBUIDText.setText(username);
                String password = PostgreSQLProfileDetailsWizardPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.password");
                if (password == null || password.trim().length() == 0) {
                    password = new String();
                }
                PostgreSQLProfileDetailsWizardPage.this.mDBPWDText.setText(password);
                PostgreSQLProfileDetailsWizardPage.this.setPageComplete(PostgreSQLProfileDetailsWizardPage.this.isValid());
            }
        });
    }

    private String getPropertyFromDriverInstance(String propertyID) {
        String returnStr = new String();
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty(propertyID) != null) {
            returnStr = this.mDriverInstance.getProperty(propertyID);
        }
        return returnStr;
    }

    public String getDriverURL() {
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.URL") != null) {
            return this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.URL");
        }
        return new String();
    }

    public String getDriverDatabaseName() {
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.databaseName") != null) {
            return this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
        }
        return new String();
    }

    public String getVendor() {
        String vendor = "";
        if (this.mDriverInstance != null) {
            vendor = this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.vendor");
        }
        return vendor;
    }

    public String getVersion() {
        String version = "";
        if (this.mDriverInstance != null) {
            version = this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.version");
        }
        return version;
    }

    public String getDriverClass() {
        String driverClass = "";
        if (this.mDriverInstance != null) {
            driverClass = this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
        }
        return driverClass;
    }

    public String getDBUID() {
        return this.mDBUIDText.getText();
    }

    public String getDBPWD() {
        return this.mDBPWDText.getText();
    }

    public boolean getSaveDBPWD() {
        return this.mSaveDBPWDCheckbox.getSelection();
    }

    public String getDBConnProps() {
        return this.mDBConnProps.getSelection();
    }

    public String getDatabaseName() {
        return this.mDatabaseNameText.getText();
    }

    public String getURL() {
        return this.mURLText.getText();
    }

    public String getDriverID() {
        return this.mDriverInstance.getId();
    }

    private Control createLabelTextPair(Composite parent, String labelText, Control ctl, int style, int gData) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(labelText);
        ctl = new Text(parent, style);
        ctl.setLayoutData((Object)new GridData(gData));
        return ctl;
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.summary.driverName.label"), this.mDriverInstance.getName()});
        data.add(new String[]{GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.summary.connProps.label"), this.getDBConnProps()});
        data.add(new String[]{GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.summary.userName.label"), this.getDBUID()});
        StringBuffer pwdMask = new StringBuffer();
        if (this.getDBPWD() != null && this.getDBPWD().length() > 0) {
            int count = this.getDBPWD().length();
            for (int i = 0; i < count; ++i) {
                pwdMask = pwdMask.append('*');
            }
        }
        data.add(new String[]{GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.summary.password.label"), pwdMask.toString()});
        data.add(new String[]{GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.summary.url.label"), this.getURL()});
        return data;
    }

    private boolean isValid() {
        if (this.getErrorMessage() != null) {
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.isValid();
    }

    public String getDriverCategory() {
        return this.mDriverCategory;
    }

    public void setDriverCategory(String driverCategory) {
        this.mDriverCategory = driverCategory;
        if (this.combo != null) {
            this.combo.setCategory(this.mDriverCategory);
        }
    }
}

