/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.util.ColumnInfo;
import org.eclipse.datatools.enablement.oda.xml.util.MappingPathElementTree;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;
import org.eclipse.datatools.enablement.oda.xml.util.TableInfo;

public class RelationInformation {
    private static final String EMPTY_STRING = "";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SINGLE_QUOTE = "'";
    private static final String FORWARD_SLASH = "/";
    private static final String COLON_MARK = ":";
    public static final String CONST_TABLE_DELIMITER = "#-#";
    public static final String CONST_TABLE_COLUMN_DELIMITER = "#:#";
    public static final String CONST_COLUMN_METAINFO_DELIMITER = ";";
    public static final String CONST_COLUMN_DELIMITER = ",";
    private HashMap tableInfos = new HashMap();
    private boolean useNamespace = false;
    private boolean containsNamespace = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.RelationInformation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public RelationInformation(String relationString) throws OdaException {
        this.useNamespace = false;
        this.initialize(relationString.trim());
    }

    public RelationInformation(String relationString, boolean useNamespace) throws OdaException {
        this.useNamespace = useNamespace;
        this.initialize(relationString.trim());
    }

    private void initialize(String relationString) throws OdaException {
        if (relationString == null || relationString.length() == 0) {
            throw new OdaException(Messages.getString("RelationInformation.InputStringCannotBeNull"));
        }
        String[] tables = relationString.split(CONST_TABLE_DELIMITER);
        int i = 0;
        while (i < tables.length) {
            ArrayList filterColumnInfos = new ArrayList();
            String[] temp = tables[i].trim().split(CONST_TABLE_COLUMN_DELIMITER);
            if (!$assertionsDisabled && temp.length < 3) {
                throw new AssertionError();
            }
            HashMap<String, String> prefixMap = new HashMap<String, String>();
            if (this.useNamespace && temp.length > 3) {
                this.containsNamespace = true;
                prefixMap = new HashMap();
                String nameSpaceInfo = temp[3].trim();
                String nameSpaces = nameSpaceInfo.substring(1, temp[3].length() - 1).trim();
                String[] names = nameSpaces.split(CONST_COLUMN_METAINFO_DELIMITER);
                int k = 0;
                while (k < names.length) {
                    String[] entry = names[k].split(CONST_COLUMN_DELIMITER);
                    if (entry.length == 2 && entry[0].trim().matches("\\Q\"\\E.*\\Q\"\\E") && entry[1].trim().matches("\\Q\"\\E.*\\Q\"\\E")) {
                        prefixMap.put(entry[0].trim().substring(1, entry[0].trim().length() - 1), entry[1].trim().substring(1, entry[1].trim().length() - 1));
                    }
                    ++k;
                }
            }
            String tableName = temp[0].trim();
            String tableRawRoot = temp[1].substring(1, temp[1].length() - 1).trim();
            if (this.useNamespace) {
                tableRawRoot = this.getValueWithNameSpace(tableRawRoot, prefixMap);
            }
            TableInfo tableInfo = new TableInfo(tableName, tableRawRoot);
            String[] columns = temp[2].trim().split(CONST_COLUMN_DELIMITER);
            int j = 0;
            while (j < columns.length) {
                String trimedColumn = columns[j].trim();
                String[] columnInfos = trimedColumn.substring(1, trimedColumn.length() - 1).split(CONST_COLUMN_METAINFO_DELIMITER);
                String columnXpath = EMPTY_STRING;
                int m = 0;
                while (m < columnInfos.length) {
                    columnInfos[m] = columnInfos[m].trim();
                    ++m;
                }
                if (columnInfos.length == 3) {
                    columnXpath = columnInfos[2];
                }
                HashMap map = null;
                if (columnXpath.matches(".*\\Q[@\\E.*\\Q=\\E.*")) {
                    map = RelationInformation.populateFilterInfo(filterColumnInfos, tableInfo, columns, columnXpath);
                }
                tableInfo.addColumn(new ColumnInfo(j + 1, columnInfos[0], columnInfos[1], columnXpath, map));
                ++j;
            }
            j = 0;
            while (j < filterColumnInfos.size()) {
                tableInfo.addColumn((ColumnInfo)filterColumnInfos.get(j));
                ++j;
            }
            if (tableRawRoot.matches(".*\\Q[@\\E.*\\Q=\\E.*")) {
                String tableRootWithFilter = SaxParserUtil.removeRedundantParentAxis(tableRawRoot);
                String value = RelationInformation.getFilterValue(tableRootWithFilter);
                String filterColumnXpath = tableRootWithFilter.replaceAll("\\Q=\\E.*", "]");
                int backRef = tableRootWithFilter.split(FORWARD_SLASH).length - filterColumnXpath.split(FORWARD_SLASH).length;
                String tableFilterPart = tableRawRoot.replaceAll(".*\\Q[\\E", EMPTY_STRING).replaceAll("\\Q=\\E.*", EMPTY_STRING);
                int n = 0;
                while (n < backRef) {
                    tableFilterPart = "../" + tableFilterPart;
                    ++n;
                }
                String tempColumnName = SaxParserUtil.createTableRootTempColumnNameForFilter();
                tableInfo.addFilter(tempColumnName, value);
                tableInfo.addColumn(new ColumnInfo(columns.length + filterColumnInfos.size() + 1, tempColumnName, "String", tableFilterPart, null));
            }
            tableInfo.bulidMappingPathTree();
            this.tableInfos.put(temp[0].trim(), tableInfo);
            ++i;
        }
    }

    public boolean containsNamespace() {
        return this.containsNamespace;
    }

    private String getValueWithNameSpace(String rawInfo, Map prefixMap) {
        String[] path = rawInfo.split(FORWARD_SLASH);
        int i = 0;
        while (i < path.length) {
            String[] colons = path[i].split(COLON_MARK);
            if (colons.length > 1 && prefixMap.get(colons[0]) != null) {
                path[i] = String.valueOf(prefixMap.get(colons[0]).toString()) + COLON_MARK + colons[1];
            }
            ++i;
        }
        StringBuffer rawInfoWithNamespace = new StringBuffer();
        int i2 = 0;
        while (i2 < path.length - 1) {
            rawInfoWithNamespace.append(String.valueOf(path[i2]) + FORWARD_SLASH);
            ++i2;
        }
        if (path.length > 0) {
            rawInfoWithNamespace.append(path[path.length - 1]);
        }
        return rawInfoWithNamespace.toString();
    }

    private static HashMap populateFilterInfo(List filterColumnInfos, TableInfo tableInfo, String[] columns, String columnXpath) throws OdaException {
        HashMap<String, String> map = null;
        String value = RelationInformation.getFilterValue(columnXpath);
        columnXpath = columnXpath.replaceAll("\\Q=\\E.*", EMPTY_STRING);
        int index = columnXpath.lastIndexOf("[@");
        String before = columnXpath.substring(0, index);
        String after = columnXpath.substring(index + 1);
        String relativePath = String.valueOf(before) + FORWARD_SLASH + after;
        String tempColumnName = SaxParserUtil.createTempColumnName(filterColumnInfos.size() + 1);
        map = new HashMap<String, String>();
        map.put(tempColumnName, value);
        filterColumnInfos.add(new ColumnInfo(columns.length + filterColumnInfos.size() + 1, tempColumnName, "String", relativePath, null));
        return map;
    }

    static String getFilterValue(String columnXpath) throws OdaException {
        String value = columnXpath.replaceAll(".*\\Q[@\\E.*\\Q=\\E", EMPTY_STRING).trim();
        if (!((value = value.replaceAll("\\Q]\\E.*", EMPTY_STRING).trim()).startsWith(SINGLE_QUOTE) && value.endsWith(SINGLE_QUOTE) || value.startsWith(DOUBLE_QUOTE) && value.endsWith(DOUBLE_QUOTE))) {
            throw new OdaException(Messages.getString("RelationInformation.InvalidFilterDefinition"));
        }
        value = value.substring(1, value.length() - 1);
        return value;
    }

    public String getTableOriginalColumnPath(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getOriginalPath(columnName == null ? EMPTY_STRING : columnName.trim());
        }
        return null;
    }

    public String getTableColumnType(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getType(columnName == null ? EMPTY_STRING : columnName.trim());
        }
        return null;
    }

    public String[] getTableColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getColumnNames();
        }
        return new String[0];
    }

    String[] getTableRealColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getRealColumnNames();
        }
        return new String[0];
    }

    public String[] getTableNestedXMLColumnNames(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getNestedXMLColumnNames();
        }
        return new String[0];
    }

    public MappingPathElementTree getTableMappingPathElementTree(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getMappingPathTree();
        }
        return null;
    }

    public String getTableRootPath(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getRootPath();
        }
        return null;
    }

    public String getTableOriginalRootPath(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getOriginalRootPath();
        }
        return null;
    }

    public HashMap getTableFilter(String tableName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getFilter();
        }
        return null;
    }

    public Iterator getTableNames() {
        return this.tableInfos.keySet().iterator();
    }

    public HashMap getTableColumnFilter(String tableName, String columnName) {
        Object tableInfo = this.tableInfos.get(tableName == null ? EMPTY_STRING : tableName.trim());
        if (tableInfo != null) {
            return ((TableInfo)tableInfo).getColumnFilters(columnName);
        }
        return null;
    }
}

