/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.XMLDataInputStream;
import org.eclipse.datatools.enablement.oda.xml.util.XPathHolder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxParser
extends DefaultHandler
implements Runnable {
    private static final String SAX_PARSER = "org.apache.xerces.parsers.SAXParser";
    private static final String EMPTY_STRING = "";
    private XMLDataInputStream inputStream;
    private XPathHolder pathHolder;
    private ISaxParserConsumer spConsumer;
    private HashMap currentElementRecoder;
    private boolean start;
    private boolean alive;
    private String currentCacheValue;
    private boolean stopCurrentThread;
    private boolean useNamespace;
    private Map cachedValues;
    private Map prefixMap;
    private List exceptions;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.SaxParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SaxParser(XMLDataInputStream stream, ISaxParserConsumer consumer, boolean useNamespace) {
        this.inputStream = stream;
        this.spConsumer = consumer;
        this.start = true;
        this.alive = true;
        this.useNamespace = useNamespace;
        this.currentCacheValue = EMPTY_STRING;
        this.currentElementRecoder = new HashMap();
        this.stopCurrentThread = false;
        this.cachedValues = new HashMap();
        this.exceptions = new ArrayList();
        this.prefixMap = new HashMap();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                Object xmlReader = this.createXMLReader();
                this.setContentHandler(xmlReader);
                this.setErrorHandler(xmlReader);
                this.inputStream.init();
                this.parse(xmlReader);
            }
            catch (Exception e) {
                this.exceptions.add(e);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.alive = false;
            this.spConsumer.wakeup();
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.alive = false;
            this.spConsumer.wakeup();
            return;
        }
    }

    public boolean exceptionOccurred() {
        return !this.exceptions.isEmpty();
    }

    private void parse(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = xmlReader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.xml.sax.InputSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method parse = this.getMethod("parse", clazz, classArray);
        InputSource source = new InputSource(this.inputStream);
        source.setEncoding(this.inputStream.getEncoding());
        parse.invoke(xmlReader, source);
    }

    private void setErrorHandler(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = xmlReader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.xml.sax.ErrorHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method setErrorHandler = this.getMethod("setErrorHandler", clazz, classArray);
        this.invokeMethod(setErrorHandler, xmlReader, new Object[]{this});
    }

    private void setContentHandler(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = xmlReader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.xml.sax.ContentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method setContentHandler = this.getMethod("setContentHandler", clazz, classArray);
        this.invokeMethod(setContentHandler, xmlReader, new Object[]{this});
    }

    private Object createXMLReader() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            Object xmlReader = Thread.currentThread().getContextClassLoader().loadClass(SAX_PARSER).newInstance();
            return xmlReader;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(SAX_PARSER).newInstance();
        }
    }

    private Method getMethod(String methodName, Class targetClass, Class[] argument) throws SecurityException, NoSuchMethodException {
        if (!$assertionsDisabled && methodName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && targetClass == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && argument == null) {
            throw new AssertionError();
        }
        return targetClass.getMethod(methodName, argument);
    }

    private void invokeMethod(Method method, Object targetObject, Object[] argument) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        method.invoke(targetObject, argument);
    }

    public void startDocument() {
        this.pathHolder = new XPathHolder();
    }

    public void endDocument() {
        this.alive = false;
        this.cleanUp();
        this.spConsumer.wakeup();
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        String parentPath;
        if (this.stopCurrentThread) {
            throw new ThreadStopException();
        }
        String elementName = qName;
        if (this.useNamespace && !qName.equals(name)) {
            elementName = String.valueOf(uri.replaceAll("/", "%")) + ":" + name;
        }
        if (this.currentElementRecoder.get(String.valueOf(parentPath = this.pathHolder.getPath()) + "/" + elementName) == null) {
            this.currentElementRecoder.put(String.valueOf(parentPath) + "/" + elementName, new Integer(1));
        } else {
            this.currentElementRecoder.put(String.valueOf(parentPath) + "/" + elementName, new Integer((Integer)this.currentElementRecoder.get(String.valueOf(parentPath) + "/" + elementName) + 1));
        }
        this.pathHolder.push(String.valueOf(elementName) + "[" + (Integer)this.currentElementRecoder.get(String.valueOf(parentPath) + "/" + elementName) + "]");
        this.spConsumer.detectNewRow(this.pathHolder.getPath(), true);
        int i = 0;
        while (i < atts.getLength()) {
            this.spConsumer.manipulateData(this.getAttributePath(atts, i), atts.getValue(i));
            ++i;
        }
    }

    private String getAttributePath(Attributes atts, int i) {
        return String.valueOf(this.pathHolder.getPath()) + "/@" + atts.getQName(i);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.spConsumer.manipulateData(this.pathHolder.getPath(), (String)this.cachedValues.get(this.pathHolder.getPath()));
        this.cachedValues.remove(this.pathHolder.getPath());
        this.spConsumer.detectNewRow(this.pathHolder.getPath(), false);
        String path = this.pathHolder.getPath();
        Object[] keys = this.currentElementRecoder.keySet().toArray();
        if (!path.equals(EMPTY_STRING)) {
            int i = 0;
            while (i < keys.length) {
                if (keys[i].toString().startsWith(path) && !keys[i].toString().equals(path)) {
                    this.currentElementRecoder.remove(keys[i]);
                }
                ++i;
            }
        }
        this.pathHolder.pop();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentCacheValue = new String(ch, start, length);
        if (!this.currentCacheValue.trim().equals(EMPTY_STRING)) {
            if (this.cachedValues.containsKey(this.pathHolder.getPath())) {
                this.currentCacheValue = String.valueOf((String)this.cachedValues.get(this.pathHolder.getPath())) + this.currentCacheValue;
            }
            this.cachedValues.put(this.pathHolder.getPath(), this.currentCacheValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStart(boolean start) {
        this.start = start;
        if (start) {
            SaxParser saxParser = this;
            synchronized (saxParser) {
                this.notify();
            }
        }
        SaxParser saxParser = this;
        synchronized (saxParser) {
            try {
                this.spConsumer.wakeup();
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.prefixMap.put(prefix, uri.replaceAll("/", "%"));
    }

    public Map getPrefixMapping() {
        return this.prefixMap;
    }

    public void stopParsing() {
        this.cleanUp();
        this.stopCurrentThread = true;
    }

    public boolean isSuspended() {
        return !this.start;
    }

    public boolean isAlive() {
        return this.alive;
    }

    private void cleanUp() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private class ThreadStopException
    extends RuntimeException {
        private static final long serialVersionUID = 7871277314833138093L;

        ThreadStopException() {
        }
    }
}

