/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.IInputXMLDataSource;
import org.eclipse.datatools.enablement.oda.xml.util.InputStreamST;
import org.eclipse.datatools.enablement.oda.xml.util.MemoryCacheDataSource;
import org.eclipse.datatools.enablement.oda.xml.util.URLInputStream;
import org.eclipse.datatools.enablement.oda.xml.util.XMLCreatorContent;
import org.eclipse.datatools.enablement.oda.xml.util.XMLDataInputStream;

public class XMLDataInputStreamCreator {
    private static final String TEMPFILENAME = "tempXMLData";
    private static final String EMPTY_STRING = "";
    private static Map inputStreamCache = Collections.synchronizedMap(new HashMap());
    private IInputXMLDataSource inputData = null;
    private String encoding = null;
    private File tempFile = null;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = EMPTY_STRING.equals(encoding) ? null : encoding;
    }

    public static XMLDataInputStreamCreator getCreator(String key, String encoding) throws OdaException {
        XMLDataInputStreamCreator creator = XMLDataInputStreamCreator.getCreator(key);
        creator.setEncoding(encoding);
        return creator;
    }

    public static synchronized XMLDataInputStreamCreator getCreator(XMLCreatorContent content) throws OdaException {
        Object key = content.getKey();
        XMLDataInputStreamCreator creator = null;
        if (key != null) {
            if (key instanceof String) {
                creator = XMLDataInputStreamCreator.getCreator((String)key, content.getEncoding());
            } else if (key instanceof InputStream) {
                creator = XMLDataInputStreamCreator.getCreator((InputStream)key, content);
            }
        }
        return creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLDataInputStreamCreator getCreator(InputStream key, XMLCreatorContent content) throws OdaException {
        Map map = inputStreamCache;
        synchronized (map) {
            if (inputStreamCache.get(key) == null) {
                MemoryCacheDataSource cache = new MemoryCacheDataSource(key, content.getMemorySize());
                XMLDataInputStreamCreator creator = cache.canUseMemoryCache() ? new XMLDataInputStreamCreator(cache) : new XMLDataInputStreamCreator(key, true, cache);
                inputStreamCache.put(key, creator);
                return creator;
            }
            return (XMLDataInputStreamCreator)inputStreamCache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLDataInputStreamCreator getCreator(String key) throws OdaException {
        Map map = inputStreamCache;
        synchronized (map) {
            if (inputStreamCache.get(key) == null) {
                XMLDataInputStreamCreator creator = new XMLDataInputStreamCreator(key);
                inputStreamCache.put(key, creator);
                return creator;
            }
            return (XMLDataInputStreamCreator)inputStreamCache.get(key);
        }
    }

    private File createTemporaryFile(InputStream is, IInputXMLDataSource dataSource) throws OdaException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            int abyte;
            File file = this.createFileWithUniqueName();
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
            if (dataSource != null) {
                while ((abyte = dataSource.read()) != -1) {
                    ((OutputStream)fos).write(abyte);
                }
            }
            while ((abyte = bis.read()) != -1) {
                ((OutputStream)fos).write(abyte);
            }
            ((OutputStream)fos).close();
            bis.close();
            this.inputData = new URLInputStream(file.toURL());
            return file;
        }
        catch (IOException e) {
            throw new OdaException(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Object key) {
        if (key != null) {
            Map map = inputStreamCache;
            synchronized (map) {
                XMLDataInputStreamCreator creator = (XMLDataInputStreamCreator)inputStreamCache.get(key);
                if (creator != null) {
                    creator.close();
                    inputStreamCache.remove(key);
                    Object var2_2 = null;
                }
            }
        }
    }

    private void close() {
        if (this.tempFile != null && !this.tempFile.delete()) {
            this.tempFile.deleteOnExit();
        }
    }

    private File createFileWithUniqueName() throws IOException {
        File file = File.createTempFile(TEMPFILENAME, null);
        file.deleteOnExit();
        return file;
    }

    protected XMLDataInputStreamCreator(String xmlFile) throws OdaException {
        URL url = null;
        try {
            File f = new File(xmlFile);
            if (f.exists()) {
                url = f.toURI().toURL();
            }
            this.inputData = new URLInputStream(url);
        }
        catch (IOException iOException) {}
        try {
            if (url == null) {
                url = new URL(xmlFile);
                this.tempFile = this.createTemporaryFile(url.openStream(), null);
            }
        }
        catch (MalformedURLException e) {
            throw new OdaException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new OdaException(e.getLocalizedMessage());
        }
    }

    protected XMLDataInputStreamCreator(IInputXMLDataSource stream) {
        this.inputData = stream;
    }

    protected XMLDataInputStreamCreator(InputStream stream, boolean isNestedQuery, IInputXMLDataSource inputSource) {
        if (isNestedQuery) {
            try {
                this.tempFile = this.createTemporaryFile(stream, inputSource);
            }
            catch (OdaException odaException) {}
        } else {
            this.inputData = new InputStreamST(stream);
        }
    }

    public XMLDataInputStream createXMLDataInputStream() throws OdaException {
        return new XMLDataInputStream(this.inputData, this.encoding);
    }
}

