/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IDatabaseSetting;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;

public abstract class AbstractDatabaseSetting
implements IDatabaseSetting {
    private DatabaseIdentifier _databaseIdentifier = null;
    protected HashMap _cache = new HashMap();

    public AbstractDatabaseSetting(DatabaseIdentifier databaseIdentifier) {
        this._databaseIdentifier = databaseIdentifier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getProperty(String propName) throws IDatabaseSetting.NotSupportedSettingException {
        Object object;
        if (this._cache.get(propName) != null) {
            return this._cache.get(propName);
        }
        Connection connection = null;
        Statement stmt = null;
        try {
            try {
                connection = ProfileUtil.getReusableConnection(this._databaseIdentifier);
                stmt = this.prepareStatement(connection, propName);
                object = this.handleStatement(stmt, propName);
                Object var5_7 = null;
                if (stmt == null) return object;
            }
            catch (IDatabaseSetting.NotSupportedSettingException e) {
                throw e;
            }
            catch (SQLException ex) {
                EditorCorePlugin.getDefault().log(ex);
                Object object2 = this.getDefaultValue(stmt, propName);
                Object var5_8 = null;
                if (stmt == null) return object2;
                try {
                    stmt.close();
                    return object2;
                }
                catch (Exception exception) {}
                return object2;
            }
            catch (Exception e) {
                EditorCorePlugin.getDefault().log(e);
                Object object3 = this.getDefaultValue(stmt, propName);
                Object var5_9 = null;
                if (stmt == null) return object3;
                try {}
                catch (Exception exception) {}
                stmt.close();
                return object3;
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            if (stmt == null) throw throwable;
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            stmt.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        stmt.close();
        return object;
    }

    protected abstract Statement prepareStatement(Connection var1, String var2) throws SQLException, IDatabaseSetting.NotSupportedSettingException;

    protected abstract Object handleStatement(Statement var1, String var2) throws SQLException, IDatabaseSetting.NotSupportedSettingException;

    protected Object getDefaultValue(Statement stmt, String propName) {
        return null;
    }
}

