/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.profile;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.IProfileListener1;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.ServerIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ConnectProfile;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.profile.SQLToolsProfileListenersManager;
import org.eclipse.datatools.sqltools.editor.core.connection.SQLToolsConnectListenersManager;

public class SQLToolsProfileProxyListener
implements IProfileListener1,
IManagedConnectionListener {
    private ArrayList _profiles = new ArrayList();
    SQLToolsProfileListenersManager _dmpProfileManager;
    SQLToolsConnectListenersManager _dmpConnectManager;
    private static SQLToolsProfileProxyListener INSTANCE = null;
    private ConnectionRegistryListener _connRegistryListener = new ConnectionRegistryListener();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private SQLToolsProfileProxyListener() {
        this._dmpProfileManager = SQLToolsProfileListenersManager.getInstance();
        this._dmpConnectManager = SQLToolsConnectListenersManager.getInstance();
    }

    public static synchronized SQLToolsProfileProxyListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SQLToolsProfileProxyListener();
        }
        return INSTANCE;
    }

    public void init(IConnectionProfile[] profiles) {
        int i = 0;
        while (i < profiles.length) {
            IManagedConnection mc;
            this._profiles.add(new ConnectProfile(profiles[i]));
            IConnectionProfile iConnectionProfile = profiles[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((mc = iConnectionProfile.getManagedConnection(clazz.getName())) != null) {
                mc.addConnectionListener((IManagedConnectionListener)this);
                if (mc.isConnected() && mc.getConnection() != null) {
                    this.opened(new ConnectEvent(profiles[i], mc, (Object)this));
                }
            }
            IConnectionProfile iConnectionProfile2 = profiles[i];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("java.sql.Connection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((mc = iConnectionProfile2.getManagedConnection(clazz2.getName())) != null) {
                mc.addConnectionListener((IManagedConnectionListener)this._connRegistryListener);
                if (mc.isConnected() && mc.getConnection() != null) {
                    this._connRegistryListener.opened(new ConnectEvent(profiles[i], mc, (Object)this));
                }
            }
            ++i;
        }
    }

    public void profileAdded(IConnectionProfile profile) {
        Class<?> clazz;
        IManagedConnection mc;
        if (!ProfileUtil.isSupportedProfile(profile)) {
            return;
        }
        this._profiles.add(new ConnectProfile(profile));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((mc = profile.getManagedConnection(clazz2.getName())) != null) {
            mc.addConnectionListener((IManagedConnectionListener)this);
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.sql.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((mc = profile.getManagedConnection(clazz.getName())) != null) {
            mc.addConnectionListener((IManagedConnectionListener)this._connRegistryListener);
        }
        this._dmpProfileManager.fireProfileAdded(profile);
    }

    public void profileDeleted(IConnectionProfile profile) {
        IManagedConnection mc;
        if (!ProfileUtil.isSupportedProfile(profile)) {
            return;
        }
        IControlConnection[] controlConnections = EditorCorePlugin.getControlConnectionManager().getControlConnections(profile.getName());
        if (controlConnections != null) {
            int i = 0;
            while (i < controlConnections.length) {
                controlConnections[i].disconnect(true);
                ++i;
            }
        }
        this._profiles.remove(new ConnectProfile(profile));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((mc = profile.getManagedConnection(clazz.getName())) != null) {
            mc.removeConnectionListener((IManagedConnectionListener)this);
        }
        this._dmpProfileManager.fireProfileDeleted(profile);
    }

    public void profileChanged(IConnectionProfile profile) {
    }

    public void profileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect) {
        if (!ProfileUtil.isSupportedProfile(profile)) {
            return;
        }
        ConnectProfile oldProfile = this.findOldProfile(profile);
        if (oldProfile == null) {
            return;
        }
        ConnectProfile dmpConnectProfile = new ConnectProfile(profile);
        boolean onlyNameChanged = oldProfile.isOnlyNameChanged(dmpConnectProfile);
        oldName = oldProfile.getName();
        IControlConnection[] controlCons = EditorCorePlugin.getControlConnectionManager().getControlConnections(oldName);
        if (controlCons != null) {
            int n = 0;
            while (n < controlCons.length) {
                if (onlyNameChanged) {
                    controlCons[n].profileRenamed(profile.getName());
                } else {
                    controlCons[n].disconnect(true);
                }
                ++n;
            }
        }
        this._dmpProfileManager.fireProfileChanged(profile, oldName, oldDesc, oldAutoConnect, onlyNameChanged, oldProfile);
    }

    private ConnectProfile findOldProfile(IConnectionProfile profile) {
        ProfileManager pManager = ProfileManager.getInstance();
        IConnectionProfile[] profiles = pManager.getProfiles();
        Iterator pIter = this._profiles.iterator();
        ConnectProfile oldProfile = null;
        while (pIter.hasNext()) {
            ConnectProfile p = (ConnectProfile)pIter.next();
            boolean isFound = false;
            int i = 0;
            while (i < profiles.length) {
                if (p.equals(new ConnectProfile(profiles[i]))) {
                    isFound = true;
                    break;
                }
                ++i;
            }
            if (isFound) continue;
            oldProfile = p;
            break;
        }
        if (oldProfile == null) {
            return null;
        }
        this._profiles.remove(oldProfile);
        this._profiles.add(new ConnectProfile(profile));
        return oldProfile;
    }

    public boolean okToClose(ConnectEvent event) {
        boolean okToClose = this._dmpConnectManager.fireOkToClose(event);
        return okToClose;
    }

    public void opened(ConnectEvent event) {
        IConnectionProfile profile = event.getConnectionProfile();
        String dbName = ProfileUtil.getProfileDatabaseName(profile.getName());
        DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(profile.getName(), dbName);
        try {
            if (databaseIdentifier.getDBname() != null && !databaseIdentifier.getDBname().trim().equals("")) {
                EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier);
            }
            this.registerSkippedConnection(event);
            try {
                this._dmpConnectManager.fireProfileConnected(event);
            }
            catch (Exception exception) {}
        }
        catch (Exception ce) {
            EditorCorePlugin.getDefault().log(ce);
        }
    }

    public void closed(ConnectEvent event) {
        try {
            this._dmpConnectManager.fireCloseConnection(event);
        }
        catch (Exception e) {
            if (EditorCorePlugin.getDefault() == null) {
                return;
            }
            EditorCorePlugin.getDefault().log(e);
        }
        IConnectionProfile profile = event.getConnectionProfile();
        if (EditorCorePlugin.getDefault() == null) {
            return;
        }
        EditorCorePlugin.getControlConnectionManager().fireDispose(profile.getName());
        IControlConnection[] cs = EditorCorePlugin.getControlConnectionManager().getControlConnections(profile.getName());
        if (cs != null && cs.length > 0) {
            int i = 0;
            while (i < cs.length) {
                cs[i].disconnect(true);
                ++i;
            }
        }
    }

    public void aboutToClose(ConnectEvent event) {
        try {
            this._dmpConnectManager.fireAboutToClose(event);
        }
        catch (Exception exception) {}
    }

    public void modified(ConnectEvent event) {
    }

    private int getConnectionId(ConnectEvent event, DatabaseIdentifier databaseIdentifier) {
        IManagedConnection mc;
        IConnection conn;
        if (event != null && event.getConnection() != null && event.getConnection().getConnection() != null && (conn = (mc = event.getConnection()).getConnection()) != null) {
            Object obj = conn.getRawConnection();
            if (obj instanceof Connection) {
                Connection connection = (Connection)obj;
                int connectionId = SQLToolsFacade.getConnectionId(databaseIdentifier, connection);
                return connectionId;
            }
            if (obj instanceof ConnectionInfo) {
                Connection connection = ((ConnectionInfo)obj).getSharedConnection();
                int connectionId = SQLToolsFacade.getConnectionId(databaseIdentifier, connection);
                return connectionId;
            }
        }
        return -1;
    }

    private void registerSkippedConnection(ConnectEvent event) {
        IConnectionProfile profile = event.getConnectionProfile();
        String dbName = ProfileUtil.getProfileDatabaseName(profile.getName());
        DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(profile.getName(), dbName);
        int connectionId = this.getConnectionId(event, databaseIdentifier);
        if (connectionId > -1) {
            ServerIdentifier si = ProfileUtil.getServerIdentifier(databaseIdentifier);
            EditorCorePlugin.getControlConnectionManager().registerSkippedConnection(si, connectionId);
        }
    }

    class ConnectionRegistryListener
    implements IManagedConnectionListener {
        ConnectionRegistryListener() {
        }

        public void aboutToClose(ConnectEvent event) {
        }

        public void closed(ConnectEvent event) {
        }

        public void modified(ConnectEvent event) {
        }

        public boolean okToClose(ConnectEvent event) {
            return true;
        }

        public void opened(ConnectEvent event) {
            SQLToolsProfileProxyListener.this.registerSkippedConnection(event);
        }
    }
}

