/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.editor.template;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.datatools.sqltools.editor.template.GenericSQLContextType;
import org.eclipse.datatools.sqltools.editor.template.SQLTemplateFormatter;
import org.eclipse.datatools.sqltools.internal.FormatterUtil;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;

public class GenericSQLContext
extends DocumentTemplateContext {
    protected ParsingResult _parsingResult = null;

    public GenericSQLContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ParsingResult result) {
        super(type, document, completionOffset, completionLength);
        this._parsingResult = result;
    }

    public String[] getCursorNames() {
        return this._parsingResult.getCursorNames(this.getDocument(), this.getStart()).toArray(new String[0]);
    }

    private int getIndentation() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            String lineContent = document.get(region.getOffset(), region.getLength());
            IEclipsePreferences prefs = new InstanceScope().getNode("org.eclipse.ui.editors");
            int tab = prefs.getInt("tabWidth", 4);
            return FormatterUtil.computeIndent(lineContent, tab);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private String getIndentationString() {
        int level = this.getIndentation();
        StringBuffer buffer = new StringBuffer("");
        int i = 0;
        while (i < level) {
            buffer.append("\t");
            ++i;
        }
        return buffer.toString();
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        TemplateBuffer buffer = super.evaluate(template);
        SQLTemplateFormatter formatter = new SQLTemplateFormatter();
        formatter.format(buffer, this.getIndentationString());
        return buffer;
    }

    public boolean canEvaluate(Template template) {
        if (this.getContextType() instanceof GenericSQLContextType) {
            String key = this.getKey();
            String[] types = ((GenericSQLContextType)this.getContextType()).getIds();
            int i = 0;
            while (i < types.length) {
                if (template.matches(key, types[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return super.canEvaluate(template);
    }
}

