/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaObject;
import org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider;
import org.eclipse.datatools.connectivity.oda.consumer.services.impl.ProviderUtil;

class ConnectionPropertyHandler
extends OdaObject {
    private String m_consumerApplId;
    private Object m_connPropContext;
    private IPropertyProvider m_propertyProvider;

    ConnectionPropertyHandler(Object context) {
        this.processConsumerAppContext(context);
    }

    protected String getConsumerApplicationId() {
        return this.m_consumerApplId;
    }

    protected Object getConnectionPropertyContext() {
        return this.m_connPropContext;
    }

    private void processConsumerAppContext(Object context) {
        this.logMethodCalled("ConnectionPropertyHandler.processConsumerAppContext");
        if (context == null || !(context instanceof Map)) {
            this.logMethodExit("ConnectionPropertyHandler.processConsumerAppContext");
            return;
        }
        Map contextMap = (Map)context;
        Object value = contextMap.get("OdaConsumerId");
        if (value == null || !(value instanceof String)) {
            this.logMethodExit("ConnectionPropertyHandler.processConsumerAppContext");
            return;
        }
        this.m_consumerApplId = (String)value;
        this.log("ConnectionPropertyHandler.processConsumerAppContext", "Consumer Application ID: " + this.m_consumerApplId);
        this.m_connPropContext = contextMap.get("OdaConnPropertyContext");
        this.log("ConnectionPropertyHandler.processConsumerAppContext", "Externalized property context: " + this.m_connPropContext);
        this.logMethodExit("ConnectionPropertyHandler.processConsumerAppContext");
    }

    protected Properties getEffectiveProperties(Properties candidateProperties) throws OdaException {
        String methodName = "ConnectionPropertyHandler.getEffectiveProperties( " + candidateProperties + " )\t";
        this.logMethodCalled(methodName);
        IPropertyProvider propProvider = this.getExtensionPropertyProvider();
        if (propProvider == null) {
            this.logMethodExit(methodName);
            return candidateProperties;
        }
        Properties effectiveProps = propProvider.getDataSourceProperties(candidateProperties, this.getConnectionPropertyContext());
        this.log(methodName, "Effective properties: " + effectiveProps);
        this.logMethodExit(methodName);
        return effectiveProps;
    }

    private IPropertyProvider getExtensionPropertyProvider() throws OdaException {
        if (this.m_propertyProvider == null) {
            String applicationId = this.getConsumerApplicationId();
            this.m_propertyProvider = ProviderUtil.createPropertyProvider(applicationId);
        }
        return this.m_propertyProvider;
    }
}

