/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.services;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.editor.template.GenericSQLContextType;
import org.eclipse.datatools.sqltools.internal.core.Messages;
import org.eclipse.datatools.sqltools.sql.DefaultSQLSyntax;
import org.eclipse.datatools.sqltools.sql.ISQLSyntax;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParserProposalAdvisor;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLDelimiter;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLStatementElement;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sql.updater.ProceduralObjectSourceUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;

public class SQLService {
    public ISQLSyntax getSQLSyntax() {
        return new DefaultSQLSyntax();
    }

    public GenericSQLContextType getSQLContextType() {
        return new GenericSQLContextType();
    }

    public SQLParser getSQLParser() {
        return null;
    }

    public String[] splitSQL(String sql, boolean splitByDefault) {
        SQLParser parser = this.getSQLParser();
        if (parser == null) {
            return new String[]{sql};
        }
        ArrayList<String> groups = new ArrayList<String>();
        try {
            Document doc = new Document(sql);
            ParserParameters parserParameters = new ParserParameters(true);
            parserParameters.setProperty((Object)"__consume_exception", (Object)Boolean.FALSE);
            ParsingResult result = parser.parse(sql, parserParameters);
            if (result.getExceptions() != null && !result.getExceptions().isEmpty()) {
                if (splitByDefault) {
                    return this.splitSQLByTerminatorLine(sql, parser.getStatementTerminators());
                }
                return new String[]{sql};
            }
            IASTStart root = result.getRootNode();
            root.setDocument((IDocument)doc);
            String group = "";
            if (root.jjtGetNumChildren() > 0) {
                int i = 0;
                while (i < root.jjtGetNumChildren()) {
                    Node node = root.jjtGetChild(i);
                    if (node instanceof IASTSQLDelimiter) {
                        if (!group.trim().equals("")) {
                            groups.add(group);
                            group = "";
                        }
                    } else {
                        group = node instanceof IASTSQLStatementElement ? String.valueOf(group) + node.getSQLText() + " " : String.valueOf(group) + node.getSQLText() + System.getProperty("line.separator");
                    }
                    ++i;
                }
            } else {
                group = sql;
            }
            if (!group.trim().equals("")) {
                groups.add(group);
            }
        }
        catch (Exception e1) {
            EditorCorePlugin.getDefault().log(NLS.bind((String)Messages.DefaultSQLSyntax_exception_splitSQL, (Object)sql), e1);
        }
        return groups.toArray(new String[groups.size()]);
    }

    public String[] splitSQL(String sql) {
        return this.splitSQL(sql, true);
    }

    public String[] splitSQLByTerminatorLine(String sql, String[] terminators) {
        Document doc = new Document(sql);
        ArrayList<String> groups = new ArrayList<String>();
        int index = 0;
        int numberOfLines = doc.getNumberOfLines();
        try {
            String string;
            int i = 0;
            while (i < numberOfLines) {
                boolean grouped = false;
                IRegion r = doc.getLineInformation(i);
                String line = doc.get(r.getOffset(), r.getLength());
                int j = 0;
                while (j < terminators.length) {
                    if (line.trim().equalsIgnoreCase(terminators[j])) {
                        String string2 = doc.get(index, r.getOffset() - index);
                        if (string2.trim().length() > 0) {
                            groups.add(string2.trim());
                        }
                        index = r.getOffset() + doc.getLineLength(i);
                        break;
                    }
                    int offset = r.getOffset();
                    while (line.indexOf(";") >= 0) {
                        if (line.indexOf(";") >= 0 && !this.isQuoted((IDocument)doc, offset + line.indexOf(";") + 1)) {
                            String string3 = doc.get(index, offset + line.indexOf(";") - index);
                            if (string3.trim().length() > 0) {
                                groups.add(string3.trim());
                            }
                            index = offset + line.indexOf(";") + 1;
                            grouped = true;
                            break;
                        }
                        offset += line.indexOf(";") + 1;
                        line = line.substring(line.indexOf(";") + 1);
                    }
                    if (grouped) {
                        grouped = false;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            if (index < doc.getLength() - 1 && (string = doc.get(index, doc.getLength() - index)).trim().length() > 0) {
                groups.add(string);
            }
        }
        catch (Exception exception) {
            return new String[]{sql};
        }
        return groups.toArray(new String[groups.size()]);
    }

    private boolean isQuoted(IDocument doc, int offset) {
        Pattern pSingle = Pattern.compile("'[^']*('')*[^']*;+[^']*('')*[^']*'");
        Pattern pDouble = Pattern.compile("\"[^\"]*(\"\")*[^\"]*;+[^\"]*(\"\")*[^\"]*\"");
        Matcher mSingle = pSingle.matcher(doc.get());
        while (mSingle.find()) {
            if (mSingle.start() > offset || mSingle.end() < offset) continue;
            return true;
        }
        Matcher mDouble = pDouble.matcher(doc.get());
        while (mDouble.find()) {
            if (mDouble.start() > offset || mDouble.end() < offset) continue;
            return true;
        }
        return false;
    }

    public ParserProposalAdvisor getParserProposalAdvisor() {
        return new ParserProposalAdvisor();
    }

    public IIdentifierValidator getIdentifierValidator() {
        return null;
    }

    public ProceduralObjectSourceUpdater getProceduralObjectSourceUpdater(SQLObject object, DatabaseDefinition dbDefinition) {
        return null;
    }
}

