/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.IControlConnectionListener;
import org.eclipse.datatools.sqltools.core.IControlConnectionManager;
import org.eclipse.datatools.sqltools.core.IResourceDisposeListener;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.ServerIdentifier;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.internal.core.AbstractControlConnection;
import org.eclipse.datatools.sqltools.internal.core.Messages;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.osgi.util.NLS;

public class ControlConnectionManager
implements IControlConnectionManager,
ICatalogObjectListener {
    ListenerList _listeners = new ListenerList();
    public Map _controlConnectionMap = new HashMap();
    Map _serverControlConnectionMap = new Hashtable();
    Map _skippedConnections = new Hashtable();
    Map _resourceDisposeListeners = new Hashtable();

    public IControlConnection getOrCreateControlConnection(DatabaseIdentifier databaseIdentifier) throws SQLException, NoSuchProfileException {
        if (databaseIdentifier == null) {
            throw new NoSuchProfileException(databaseIdentifier.toString());
        }
        IControlConnection con = null;
        con = (IControlConnection)this._controlConnectionMap.get(databaseIdentifier);
        if (con == null) {
            SQLDevToolsConfiguration conf = SQLToolsFacade.getConfiguration(databaseIdentifier, null);
            con = conf.getConnectionService().createControlConnection(databaseIdentifier);
            if (con == null) {
                throw new SQLException(NLS.bind((String)Messages.ControlConnectionManager_unknownServerType, (Object[])new Object[]{databaseIdentifier.getProfileName()}));
            }
            this._controlConnectionMap.put(databaseIdentifier, con);
            ServerIdentifier serverId = ProfileUtil.getServerIdentifier(databaseIdentifier);
            if (serverId == null) {
                return null;
            }
            if (serverId.getHost().length() != 0 && serverId.getPort().length() != 0) {
                HashSet controlConnections = (HashSet)this._serverControlConnectionMap.get(serverId);
                if (controlConnections != null) {
                    if (!controlConnections.contains(con)) {
                        controlConnections.add(con);
                    }
                } else {
                    HashSet<IControlConnection> newServerConnections = new HashSet<IControlConnection>();
                    newServerConnections.add(con);
                    this._serverControlConnectionMap.put(serverId, newServerConnections);
                }
            }
            this.fireAdded(con);
        }
        this.fireRefreshed(con);
        return con;
    }

    public IControlConnection[] getControlConnection(String profileName) {
        return this.getControlConnections(profileName);
    }

    public synchronized IControlConnection[] getControlConnections() {
        return this._controlConnectionMap.values().toArray(new IControlConnection[this._controlConnectionMap.size()]);
    }

    public boolean hasControlConnection() {
        return !this._controlConnectionMap.isEmpty();
    }

    public void addControlConnectionListener(IControlConnectionListener listener) {
        this._listeners.add((Object)listener);
    }

    public void removeControlConnectionListener(IControlConnectionListener listener) {
        this._listeners.remove((Object)listener);
    }

    public void fireAdded(IControlConnection con) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IControlConnectionListener l = (IControlConnectionListener)listeners[i];
            l.controlConnectionAdded(con);
            ++i;
        }
    }

    public void fireDetached(IControlConnection con) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IControlConnectionListener l = (IControlConnectionListener)listeners[i];
            l.controlConnectionDetached(con);
            ++i;
        }
    }

    public void fireRefreshed(IControlConnection con) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IControlConnectionListener l = (IControlConnectionListener)listeners[i];
            l.controlConnectionRefreshed(con);
            ++i;
        }
    }

    public void fireRefreshed(IControlConnection con, ProcIdentifier proc) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IControlConnectionListener l = (IControlConnectionListener)listeners[i];
            l.controlConnectionRefreshed(con, proc);
            ++i;
        }
    }

    protected void remove(AbstractControlConnection connection) {
        this._controlConnectionMap.remove(connection.getDatabaseIdentifier());
        this.cleanUpServerRelatedMap(connection);
        this.fireDetached(connection);
    }

    private synchronized void cleanUpServerRelatedMap(AbstractControlConnection connection) {
        Set servers = this._serverControlConnectionMap.keySet();
        Iterator serverIter = servers.iterator();
        ArrayList<ServerIdentifier> shouldRemoveServers = new ArrayList<ServerIdentifier>();
        while (serverIter.hasNext()) {
            ServerIdentifier serverIdentifier = (ServerIdentifier)serverIter.next();
            HashSet conns = (HashSet)this._serverControlConnectionMap.get(serverIdentifier);
            if (conns.contains(connection) && conns.size() == 1) {
                shouldRemoveServers.add(serverIdentifier);
                continue;
            }
            conns.remove(connection);
        }
        Iterator iter = shouldRemoveServers.iterator();
        while (iter.hasNext()) {
            ServerIdentifier serverIdentifier = (ServerIdentifier)iter.next();
            this._serverControlConnectionMap.remove(serverIdentifier);
            this._skippedConnections.remove(serverIdentifier);
        }
    }

    public void shutdown() {
        this._serverControlConnectionMap.clear();
        this._skippedConnections.clear();
        ArrayList list = new ArrayList(this._controlConnectionMap.values());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IControlConnection con = (IControlConnection)iter.next();
            con.disconnect(true);
        }
    }

    public IControlConnection[] getControlConnections(String profileName) {
        ArrayList controlConnections = new ArrayList();
        Set databaseIdentifierSet = this._controlConnectionMap.keySet();
        Iterator iterator = databaseIdentifierSet.iterator();
        ArrayList databaseIdentifiers = new ArrayList();
        while (iterator.hasNext()) {
            databaseIdentifiers.add(iterator.next());
        }
        if (databaseIdentifiers.size() < 1) {
            return new IControlConnection[0];
        }
        int i = 0;
        while (i < databaseIdentifiers.size()) {
            DatabaseIdentifier databaseIdentifier = (DatabaseIdentifier)databaseIdentifiers.get(i);
            if (databaseIdentifier.getProfileName().equals(profileName)) {
                controlConnections.add(this._controlConnectionMap.get(databaseIdentifier));
            }
            ++i;
        }
        return controlConnections.toArray(new IControlConnection[controlConnections.size()]);
    }

    public IControlConnection getControlConnection(DatabaseIdentifier databaseIdentifier) {
        IControlConnection[] cc;
        IControlConnection controlConnection = (IControlConnection)this._controlConnectionMap.get(databaseIdentifier);
        if (controlConnection == null && (cc = this.getControlConnection(databaseIdentifier.getProfileName())) != null && cc.length > 0) {
            controlConnection = cc[0];
        }
        return controlConnection;
    }

    public HashSet getSkippedConnections(ServerIdentifier serverIdentifier) {
        if (serverIdentifier == null) {
            return null;
        }
        return (HashSet)this._skippedConnections.get(serverIdentifier);
    }

    public void registerSkippedConnection(ServerIdentifier serverIdentifier, int connid) {
        if (serverIdentifier == null) {
            return;
        }
        HashSet<Integer> skippedConnections = (HashSet<Integer>)this._skippedConnections.get(serverIdentifier);
        if (skippedConnections == null) {
            skippedConnections = new HashSet<Integer>();
            skippedConnections.add(new Integer(connid));
            this._skippedConnections.put(serverIdentifier, skippedConnections);
        } else {
            skippedConnections.add(new Integer(connid));
        }
    }

    public void unregisterSkippedConnection(ServerIdentifier serverIdentifier, int connid) {
        if (serverIdentifier == null) {
            return;
        }
        HashSet skippedConnections = (HashSet)this._skippedConnections.get(serverIdentifier);
        if (skippedConnections != null) {
            skippedConnections.remove(new Integer(connid));
        }
    }

    public HashSet getControlConnections(ServerIdentifier serverIdentifier) {
        return (HashSet)this._serverControlConnectionMap.get(serverIdentifier);
    }

    public Map getServerConnectionMap() {
        return this._serverControlConnectionMap;
    }

    public void addResourceDisposeListener(String profileName, IResourceDisposeListener resourceDisposeListener) {
        if (resourceDisposeListener == null || profileName == null || profileName.trim().length() == 0) {
            return;
        }
        if (this._resourceDisposeListeners.get(profileName) == null) {
            this._resourceDisposeListeners.put(profileName, resourceDisposeListener);
        }
    }

    public void removeResourceDisposeListener(String profileName) {
        if (profileName == null || profileName.trim().length() == 0) {
            return;
        }
        this._resourceDisposeListeners.remove(profileName);
    }

    public void fireDispose(String profileName) {
        if (profileName == null || profileName.trim().length() == 0) {
            return;
        }
        IResourceDisposeListener listener = (IResourceDisposeListener)this._resourceDisposeListeners.get(profileName);
        if (listener != null) {
            listener.dispose();
        }
    }

    public void notifyChanged(ICatalogObject dmElement, int eventType) {
        IConnectionProfile connectionProfile;
        DatabaseIdentifier dbid;
        ServerIdentifier serverId;
        HashSet cons;
        if (!(dmElement instanceof Routine || dmElement instanceof Trigger || dmElement instanceof Event)) {
            return;
        }
        Database catalogDatabase = dmElement.getCatalogDatabase();
        ConnectionInfo connInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(catalogDatabase);
        if (connInfo instanceof ConnectionInfoImpl && (cons = this.getControlConnections(serverId = ProfileUtil.getServerIdentifier(dbid = new DatabaseIdentifier((connectionProfile = ((ConnectionInfoImpl)connInfo).getConnectionProfile()).getName(), catalogDatabase.getName())))) != null && cons.size() > 0) {
            ProcIdentifier procId = SQLDevToolsUtil.getProcIdentifier((SQLObject)dmElement);
            Iterator it = cons.iterator();
            while (it.hasNext()) {
                IControlConnection con = (IControlConnection)it.next();
                if (con == null) continue;
                con.refresh(procId);
            }
        }
    }
}

