/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.ase.internal.ui.connection.drivers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.JDBCASEProfileMessages;
import org.eclipse.datatools.enablement.sybase.ase.internal.ui.connection.drivers.AdditionalControlManager;
import org.eclipse.datatools.enablement.sybase.ase.internal.ui.connection.drivers.IAdditionalControl;
import org.eclipse.datatools.enablement.sybase.ui.JDBCProfileMessages;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ASEDriverUIContributor
implements IDriverUIContributor,
Listener,
ModifyListener {
    protected static final String EMPTY_STRING = "";
    private ScrolledComposite scrolledComposite = null;
    private Text mHostText;
    private Text mPortText;
    private Text mDatabaseText;
    private Text mDBUIDText;
    private Text mDBPWDText;
    private Button mSaveDBPWDCheckbox;
    private DelimitedStringList mDBConnProps;
    private IDriverUIContributorInformation contributorInformation;
    private Properties properties;
    private DialogPage parentPage;
    private boolean isReadOnly = false;

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        boolean isPortValid = true;
        try {
            Integer.valueOf(this.mPortText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            isPortValid = false;
        }
        if (this.mDBUIDText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(JDBCASEProfileMessages.getString((String)"JDBCProfileTabs.errors.requiredUID"));
            isComplete = false;
        } else if (this.mHostText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(JDBCASEProfileMessages.getString((String)"JDBCASEProfileTabs.errors.requiredHost"));
            isComplete = false;
        } else if (this.mPortText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(JDBCASEProfileMessages.getString((String)"JDBCASEProfileTabs.errors.requiredPort"));
            isComplete = false;
        } else if (!isPortValid) {
            this.parentPage.setErrorMessage(JDBCASEProfileMessages.getString((String)"JDBCASEProfileTabs.errors.requiredPortValidNumber"));
            isComplete = false;
        } else if (this.mDBConnProps.getWarning() != null) {
            this.parentPage.setErrorMessage(this.mDBConnProps.getWarning());
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.scrolledComposite == null || this.scrolledComposite.isDisposed() || this.isReadOnly != isReadOnly) {
            this.isReadOnly = isReadOnly;
            int additionalStyles = 0;
            if (isReadOnly) {
                additionalStyles = 8;
            }
            this.scrolledComposite = new ScrolledComposite(parent, 768);
            this.scrolledComposite.setExpandHorizontal(true);
            this.scrolledComposite.setExpandVertical(true);
            this.scrolledComposite.setLayout((Layout)new GridLayout());
            TabFolder tabFolder = new TabFolder((Composite)this.scrolledComposite, 128);
            TabItem generalTab = new TabItem(tabFolder, 0);
            generalTab.setText(JDBCProfileMessages.getString((String)"JDBCProfileTabs.tabs.label.connection"));
            TabItem optionalTab = new TabItem(tabFolder, 0);
            optionalTab.setText(JDBCProfileMessages.getString((String)"JDBCProfileTabs.tabs.label.other"));
            Composite generalComposite = new Composite((Composite)tabFolder, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            generalComposite.setLayout((Layout)layout);
            generalTab.setControl((Control)generalComposite);
            Composite optionalComposite = new Composite((Composite)tabFolder, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            optionalComposite.setLayout((Layout)layout);
            optionalTab.setControl((Control)optionalComposite);
            layout = new GridLayout(2, false);
            generalComposite.setLayout((Layout)layout);
            IAdditionalControl additionalControl = AdditionalControlManager.getInstance().getAdditionalControl();
            if (additionalControl != null) {
                additionalControl.setAgentPluginID(AdditionalControlManager.getInstance().getId());
                additionalControl.createControllerContents(generalComposite);
            }
            this.mHostText = (Text)this.createLabelTextPair(generalComposite, JDBCASEProfileMessages.getString((String)"JDBCASEPropertyWizardPage.hostName.label"), (Control)this.mHostText, 0x800 | additionalStyles, 768);
            this.mPortText = (Text)this.createLabelTextPair(generalComposite, JDBCASEProfileMessages.getString((String)"JDBCASEPropertyWizardPage.portNumber.label"), (Control)this.mPortText, 0x800 | additionalStyles, 768);
            if (additionalControl != null) {
                additionalControl.assignServerText(this.mHostText, this.mPortText);
            }
            this.mDatabaseText = (Text)this.createLabelTextPair(generalComposite, JDBCASEProfileMessages.getString((String)"JDBCASEPropertyWizardPage.databaseName.label"), (Control)this.mPortText, 0x800 | additionalStyles, 768);
            this.mDBUIDText = (Text)this.createLabelTextPair(generalComposite, JDBCASEProfileMessages.getString((String)"JDBCPropertyWizardPage.userName.label"), (Control)this.mDBUIDText, 0x800 | additionalStyles, 768);
            this.mDBPWDText = (Text)this.createLabelTextPair(generalComposite, JDBCASEProfileMessages.getString((String)"JDBCPropertyWizardPage.password.label"), (Control)this.mDBPWDText, 0x800 | additionalStyles, 768);
            this.mDBPWDText.setEchoChar('*');
            this.mSaveDBPWDCheckbox = new Button(generalComposite, 32);
            this.mSaveDBPWDCheckbox.setText(JDBCASEProfileMessages.getString((String)"JDBCPropertyWizardPage.persistpassword.label"));
            this.mSaveDBPWDCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
            layout = new GridLayout(2, false);
            optionalComposite.setLayout((Layout)layout);
            this.mDBConnProps = new DelimitedStringList(optionalComposite, 0, isReadOnly);
            GridData gdata = new GridData(768);
            gdata.horizontalSpan = 2;
            this.mDBConnProps.setLayoutData((Object)gdata);
            this.scrolledComposite.setContent((Control)tabFolder);
            this.scrolledComposite.setMinSize(tabFolder.computeSize(-1, -1));
            this.initialize();
        }
        return this.scrolledComposite;
    }

    private void addListeners() {
        this.mDatabaseText.addListener(24, (Listener)this);
        this.mDBPWDText.addListener(24, (Listener)this);
        this.mDBUIDText.addListener(24, (Listener)this);
        this.mHostText.addListener(24, (Listener)this);
        this.mPortText.addListener(24, (Listener)this);
        this.mSaveDBPWDCheckbox.addListener(13, (Listener)this);
        this.mDBConnProps.addModifyListener((ModifyListener)this);
    }

    private void removeListeners() {
        this.mDatabaseText.removeListener(24, (Listener)this);
        this.mDBPWDText.removeListener(24, (Listener)this);
        this.mDBUIDText.removeListener(24, (Listener)this);
        this.mHostText.removeListener(24, (Listener)this);
        this.mPortText.removeListener(24, (Listener)this);
        this.mSaveDBPWDCheckbox.removeListener(13, (Listener)this);
        this.mDBConnProps.removeModifyListener((ModifyListener)this);
    }

    private void initialize() {
        this.addListeners();
    }

    public void modifyText(ModifyEvent e) {
        this.handleEvent(new Event());
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.mSaveDBPWDCheckbox) {
                this.mSaveDBPWDCheckbox.setSelection(!this.mSaveDBPWDCheckbox.getSelection());
            }
        } else {
            this.setConnectionInformation();
        }
    }

    public void setConnectionInformation() {
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.mDatabaseText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.mDBPWDText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.mDBUIDText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.mSaveDBPWDCheckbox.getSelection()));
        this.properties.setProperty("org.eclipse.datatools.enablement.sybase.host", this.mHostText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.enablement.sybase.port", this.mPortText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", this.mDBConnProps.getSelection());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.getURL());
        this.contributorInformation.setProperties(this.properties);
    }

    protected Control createLabelTextPair(Composite parent, String labelText, Control ctl, int style, int gData) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0, false, false));
        label.setText(labelText);
        ctl = new Text(parent, style);
        ctl.setLayoutData((Object)new GridData(4, 0, true, false));
        return ctl;
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        summaryData.add(new String[]{JDBCASEProfileMessages.getString((String)"JDBCASEPropertyWizardPage.summary.connProps.label"), this.mDBConnProps.getSelection()});
        summaryData.add(new String[]{JDBCASEProfileMessages.getString((String)"JDBCASEPropertyWizardPage.summary.host.label"), this.mHostText.getText().trim()});
        summaryData.add(new String[]{JDBCASEProfileMessages.getString((String)"JDBCASEPropertyWizardPage.summary.port.label"), this.mPortText.getText().trim()});
        summaryData.add(new String[]{JDBCASEProfileMessages.getString((String)"JDBCASEPropertyWizardPage.summary.userName.label"), this.mDBUIDText.getText().trim()});
        String pwdMask = EMPTY_STRING;
        String dbPwd = this.mDBPWDText.getText().trim();
        int i = 0;
        while (i < dbPwd.length()) {
            pwdMask = String.valueOf(pwdMask) + "*";
            ++i;
        }
        summaryData.add(new String[]{JDBCASEProfileMessages.getString((String)"JDBCASEPropertyWizardPage.summary.password.label"), pwdMask});
        return summaryData;
    }

    public void loadProperties() {
        String connectionProperties;
        String savePassword;
        String password;
        String username;
        String portNo;
        String hostName;
        this.removeListeners();
        String databaseName = this.properties.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
        if (databaseName != null) {
            this.mDatabaseText.setText(databaseName);
        }
        if ((hostName = this.properties.getProperty("org.eclipse.datatools.enablement.sybase.host")) != null) {
            this.mHostText.setText(hostName);
        }
        if ((portNo = this.properties.getProperty("org.eclipse.datatools.enablement.sybase.port")) != null) {
            this.mPortText.setText(portNo);
        }
        if ((username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username")) != null) {
            this.mDBUIDText.setText(username);
        }
        if ((password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.mDBPWDText.setText(password);
        }
        if ((savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD")) != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
            this.mSaveDBPWDCheckbox.setSelection(true);
        }
        if ((connectionProperties = this.properties.getProperty("org.eclipse.datatools.connectivity.db.connectionProperties")) != null) {
            this.mDBConnProps.setSelection(connectionProperties);
        }
        this.addListeners();
        this.setConnectionInformation();
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
    }

    public String getURL() {
        String host = EMPTY_STRING;
        String port = EMPTY_STRING;
        String dbName = EMPTY_STRING;
        if (this.mPortText.getText() != null) {
            port = this.mPortText.getText();
        }
        if (this.mHostText.getText() != null) {
            host = this.mHostText.getText();
        }
        if (this.mDatabaseText.getText() != null) {
            dbName = this.mDatabaseText.getText();
        }
        String driverURL = JDBCASEPlugin.makeDriverURL((String)host, (String)port, (String)dbName);
        return driverURL;
    }
}

