/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.sqltools.sql.parser.Token;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTDeployable;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParamDefList;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLStatement;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sql.parser.ast.SimpleNode;
import org.eclipse.datatools.sqltools.sql.reference.internal.Table;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.jface.text.IDocument;

public abstract class ParsingResult {
    protected IASTStart _rootNode;
    protected ArrayList _exceptions;
    protected int fScope;
    protected List _expectedUnreservedKeywords = new ArrayList();
    private List _currentTableNames = new ArrayList();
    private HashMap fEntries = new HashMap();

    public ParsingResult() {
    }

    public ParsingResult(Node rootNode, ArrayList exceptions) {
        this._rootNode = (IASTStart)rootNode;
        this._exceptions = exceptions;
    }

    public ArrayList getExceptions() {
        return this._exceptions;
    }

    public IASTStart getRootNode() {
        return this._rootNode;
    }

    public void setExceptions(ArrayList exceptions) {
        this._exceptions = exceptions;
    }

    public void setRootNode(Node rootNode) {
        this._rootNode = (IASTStart)rootNode;
    }

    public List getExpectedUnreservedKeywords() {
        return Collections.unmodifiableList(this._expectedUnreservedKeywords);
    }

    public void addExpectedUnreservedKeywords(String unReservedKeyword) {
        if (this._expectedUnreservedKeywords == null) {
            this._expectedUnreservedKeywords = new ArrayList();
        }
        if (!this._expectedUnreservedKeywords.contains(unReservedKeyword)) {
            this._expectedUnreservedKeywords.add(unReservedKeyword);
        }
    }

    public ArrayList getCursorNames(IDocument document, int offset) {
        ArrayList cursors = new ArrayList();
        SimpleNode context = (SimpleNode)this.findContainingDeployable(document, offset, this._rootNode);
        if (context != null) {
            cursors = this.findCursorNames(document, offset, context);
        }
        return cursors;
    }

    public HashMap getVariables(IDocument document, int offset) {
        HashMap map = new HashMap();
        SimpleNode context = (SimpleNode)this.findContainingDeployable(document, offset, this._rootNode);
        if (context != null) {
            map = this.findVariables(document, offset, context);
        }
        return map;
    }

    public HashMap getParameters(IDocument document, int offset) {
        HashMap map = new HashMap();
        SimpleNode context = (SimpleNode)this.findContainingDeployable(document, offset, this._rootNode);
        if (context != null && context instanceof IASTDeployable) {
            map = this.findParameters(document, offset, (IASTDeployable)((Object)context));
        }
        return map;
    }

    public Node findParentCompound(IDocument document, int offset, Node rootNode) {
        SimpleNode node = (SimpleNode)ParsingResult.findNode(document, offset, rootNode, true);
        if (node == null) {
            return null;
        }
        while (!(node instanceof IASTStart || node instanceof IASTDeployable || node instanceof IASTSQLStatement && "BEGIN".equalsIgnoreCase(node.getFirstToken().image))) {
            node = (SimpleNode)node.jjtGetParent();
        }
        return node;
    }

    public static Node findNode(IDocument document, int offset, Node rootNode, boolean inclusive) {
        if (!ParsingResult.contains(document, offset, rootNode, inclusive)) {
            return null;
        }
        SimpleNode root = (SimpleNode)rootNode;
        for (int i = root.jjtGetNumChildren() - 1; i >= 0; --i) {
            SimpleNode node = (SimpleNode)root.jjtGetChild(i);
            if (!ParsingResult.contains(document, offset, node, inclusive)) continue;
            return ParsingResult.findNode(document, offset, node, inclusive);
        }
        return root;
    }

    private static boolean contains(IDocument document, int offset, Node node, boolean inclusive) {
        boolean in;
        SimpleNode simpleNode = (SimpleNode)node;
        if (offset > document.getLength()) {
            return false;
        }
        boolean bl = in = simpleNode.getStartOffset(document) < offset;
        in = inclusive ? in && simpleNode.getGreatestEndOffset(document) >= offset : in && simpleNode.getEndOffset(document) >= offset;
        return in;
    }

    public Node findContainingDeployable(IDocument document, int offset, IASTStart start) {
        SimpleNode root = (SimpleNode)((Object)start);
        if (root.jjtGetNumChildren() <= 0 || root.getStartOffset(document) >= offset) {
            return null;
        }
        IASTDeployable deployable = null;
        for (int i = root.jjtGetNumChildren() - 1; i >= 0; --i) {
            SimpleNode node = (SimpleNode)root.jjtGetChild(i);
            if (root.jjtGetChild(i) instanceof IASTDeployable) {
                if (node.getStartOffset(document) >= offset) continue;
                deployable = (IASTDeployable)((Object)node);
                break;
            }
            if (node.getStartOffset(document) <= offset) break;
        }
        if (deployable == null) {
            if (!(root.jjtGetChild(0) instanceof IASTDeployable)) {
                return root;
            }
        } else {
            return deployable;
        }
        return null;
    }

    protected abstract ArrayList findCursorNames(IDocument var1, int var2, SimpleNode var3);

    protected abstract HashMap findVariables(IDocument var1, int var2, SimpleNode var3);

    protected HashMap findParameters(IDocument document, int offset, IASTDeployable node) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        if (node.jjtGetNumChildren() > 0) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                SimpleNode child = (SimpleNode)node.jjtGetChild(i);
                if (!(child instanceof IASTSQLParamDefList)) continue;
                for (int j = 0; j < child.jjtGetNumChildren(); ++j) {
                    Node param = child.jjtGetChild(j);
                    if (!(param instanceof IASTSQLParam)) continue;
                    map.put(((IASTSQLParam)((Object)param)).getName(), param);
                }
                break;
            }
        }
        return map;
    }

    protected abstract HashMap findCursors(IDocument var1, int var2, SimpleNode var3);

    public HashMap getCursors(IDocument document, int offset) {
        HashMap map = new HashMap();
        SimpleNode context = (SimpleNode)this.findContainingDeployable(document, offset, this._rootNode);
        if (context != null && context instanceof IASTDeployable) {
            map = this.findCursors(document, offset, context);
        }
        return map;
    }

    public int getScope() {
        return this.fScope;
    }

    public void setScope(int scope) {
        this.fScope = scope;
    }

    public List getCurrentTables() {
        return this._currentTableNames;
    }

    public void addCurrentTables(Node simpleNode, Token token, boolean isContentAssist) {
        if (!isContentAssist) {
            return;
        }
        if (simpleNode instanceof SimpleNode) {
            String tableName = ((SimpleNode)simpleNode).getText();
            String aliasName = null;
            if (token != null && token.image != null) {
                aliasName = token.image;
            }
            this.addCurrentTables(tableName, aliasName, isContentAssist);
        }
    }

    public void addCurrentTables(String tableName, String aliasName, boolean isContentAssist) {
        if (!isContentAssist) {
            return;
        }
        String[] objects = SQLUtil.splitDotStr(tableName);
        int length = objects.length;
        String owner = null;
        String name = null;
        switch (length) {
            case 1: {
                name = objects[0].trim();
                break;
            }
            case 2: {
                owner = objects[0].trim();
                name = objects[1].trim();
                break;
            }
        }
        if (this._currentTableNames != null) {
            for (int i = 0; i < this._currentTableNames.size(); ++i) {
                Table table1 = (Table)this._currentTableNames.get(i);
                if (owner != null && owner.equals(table1.getOwner())) {
                    if (name == null || !name.equals(table1.getName())) continue;
                    table1.setAliasName(aliasName);
                    return;
                }
                if (owner != null || name == null || !name.equals(table1.getName())) continue;
                table1.setAliasName(aliasName);
                return;
            }
        }
        Table table = new Table();
        if (name != null) {
            table.setName(name);
        }
        if (owner != null) {
            table.setOwner(owner);
        }
        table.setAliasName(aliasName);
        if (!this._currentTableNames.contains(table)) {
            this._currentTableNames.add(table);
        }
    }

    public void clearCurrentTableNames(boolean isContentAssist) {
        if (!isContentAssist) {
            return;
        }
        if (this._currentTableNames != null && !this._currentTableNames.isEmpty()) {
            this._currentTableNames.clear();
        }
    }

    public abstract boolean isValidObjectsFormats(ArrayList var1);

    public abstract boolean isVarOrPara(ArrayList var1);

    public abstract ArrayList getPrefix(ArrayList var1, Node var2);

    public abstract ArrayList getUnSharableTempTables(IDocument var1, int var2);

    protected void findReferencedTables(SimpleNode node, ArrayList refTables) {
        if (node instanceof IASTSQLStatement) {
            int nodeType = ((IASTSQLStatement)((Object)node)).getType();
            switch (nodeType) {
                case 56: {
                    Token token = node.getFirstToken();
                    if (!"create".equalsIgnoreCase(token.image)) break;
                    token = token.next;
                    if (!"table".equalsIgnoreCase(token.image)) break;
                    token = token.next;
                    String tableName = token.image;
                    while (token.next.image == "." || token.image == ".") {
                        token = token.next;
                        tableName = tableName + token.image;
                    }
                    if (refTables.contains(tableName)) break;
                    refTables.add(tableName);
                    break;
                }
                case 50: {
                    Token token = node.getFirstToken();
                    if (!"truncate".equalsIgnoreCase(token.image)) break;
                    token = token.next;
                    if (!"table".equalsIgnoreCase(token.image)) break;
                    token = token.next;
                    String tableName = token.image;
                    while (token.next.image == "." || token.image == ".") {
                        token = token.next;
                        tableName = tableName + token.image;
                    }
                    if (refTables.contains(tableName)) break;
                    refTables.add(tableName);
                    break;
                }
                default: {
                    Collection params = ((IASTSQLStatement)((Object)node)).getObjectIdentifiers();
                    if (params == null || params.size() <= 0) break;
                    Iterator iter = params.iterator();
                    while (iter.hasNext()) {
                        String name = (String)iter.next();
                        if (refTables.contains(name)) continue;
                        refTables.add(name);
                    }
                    break block0;
                }
            }
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            this.findReferencedTables((SimpleNode)node.jjtGetChild(i), refTables);
        }
    }

    public ArrayList getReferencedTables() {
        ArrayList tables = new ArrayList();
        SimpleNode context = (SimpleNode)((Object)this._rootNode);
        if (context != null) {
            this.findReferencedTables(context, tables);
        }
        return tables;
    }

    public void addEntry(Object t, String type) {
        ArrayList<Object> objects = (ArrayList<Object>)this.fEntries.get(type);
        if (objects == null) {
            objects = new ArrayList<Object>();
        }
        if (!objects.contains(t)) {
            objects.add(t);
        }
        this.fEntries.put(type, objects);
    }

    public String[] getEntries(String type) {
        return new String[0];
    }
}

