/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.parser;

import org.eclipse.datatools.sqltools.sql.internal.SQLActivator;
import org.eclipse.datatools.sqltools.sql.parser.Messages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.Assert;

public class Token {
    public int kind;
    public int beginLine;
    public int beginColumn;
    public int endLine;
    public int endColumn;
    public String image;
    public Token next;
    public Token specialToken;

    public String toString() {
        return this.image;
    }

    public int getLength() {
        return this.image.length();
    }

    public static final Token newToken(int ofKind) {
        switch (ofKind) {
            default: 
        }
        return new Token();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Token)) {
            return false;
        }
        Token other = (Token)obj;
        boolean equals = other.kind == this.kind && this.image.equals(other.image) && this.beginLine == other.beginLine && this.beginColumn == other.beginColumn && this.endLine == other.endLine && this.endColumn == other.endColumn;
        return equals;
    }

    public int getStartOffset(IDocument document) {
        Assert.isNotNull((Object)document);
        int offset = 0;
        try {
            offset = document.getLineOffset(this.beginLine - 1) + this.beginColumn - 1;
        }
        catch (BadLocationException e1) {
            SQLActivator.getDefault().log(Messages.SimpleNode_1, e1);
        }
        return offset;
    }

    public int getEndOffset(IDocument document) {
        Assert.isNotNull((Object)document);
        int offset = 0;
        try {
            offset = document.getLineOffset(this.endLine - 1) + this.endColumn;
        }
        catch (BadLocationException e1) {
            SQLActivator.getDefault().log(Messages.SimpleNode_1, e1);
        }
        return offset;
    }
}

