/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableCorrelation;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DatabaseHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLStringHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.VendorHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.provider.rdbschema.AvailableTablesTreeProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddTableDialog
extends Dialog {
    public static Object REPLACE_TABLE = "org.eclipse.datatools.sqltools.sqlbuilder.dialogs.AddTableDialog.ReplaceTable";
    public static Object ADD_TABLE = "org.eclipse.datatools.sqltools.sqlbuilder.dialogs.AddTableDialog.AddTable";
    public static Object TABLE_ALREADY_ADDED = "org.eclipse.datatools.sqltools.sqlbuilder.dialogs.AddTableDialog.TableAlreadyAdded";
    public static Object ADDING_PARENT_VIEW = "org.eclipse.datatools.sqltools.sqlbuilder.dialogs.AddTableDialog.AddingParentView";
    SQLObject tableValue;
    List tablesList;
    Tree availableTablesTree;
    TreeViewer availableTablesTreeViewer;
    Text aliasTextField;
    Label tableAliasLabel;
    Label errorLabel;
    String tableAlias;
    SQLDomainModel domainModel;
    Vector tableNames;
    Object object;
    Object action;
    StatementHelper createStmtHelper;
    String replaceTitleText;

    public AddTableDialog(Shell parentShell, SQLDomainModel domainModel, Object obj, Vector tables) {
        super(parentShell);
        this.domainModel = domainModel;
        this.object = obj;
        this.tableNames = tables;
        this.setShellStyle(133232);
        this.setBlockOnOpen(true);
        this.createStmtHelper = new StatementHelper(domainModel.getDatabase());
    }

    public int open() {
        VendorHelper vendorHelper = new VendorHelper(this.domainModel.getDatabase());
        QueryStatement stmt = this.domainModel.getSQLStatement();
        if (stmt instanceof QueryInsertStatement || stmt instanceof QueryDeleteStatement && (vendorHelper.isCloudscape() || vendorHelper.isSybase())) {
            this.aliasTextField.setEnabled(false);
        }
        return super.open();
    }

    public void setFocusAliasTextField() {
        this.aliasTextField.forceFocus();
    }

    public void setAction(Object action) {
        this.action = action;
    }

    public void setReplaceTitle(String tableName) {
        this.replaceTitleText = String.valueOf(Messages._UI_DIALOG_REPLACE_TABLE_TITLE) + " " + tableName;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.action == REPLACE_TABLE) {
            shell.setText(this.replaceTitleText);
        } else if (this.action == TABLE_ALREADY_ADDED) {
            shell.setText(Messages._UI_DIALOG_TABLE_ALREADY_ADDED);
        } else if (this.action == ADDING_PARENT_VIEW) {
            shell.setText(Messages._UI_DIALOG_ADD_VIEW_TO_SELF);
        } else {
            shell.setText(Messages._UI_DIALOG_ADD_TABLE_TITLE);
        }
    }

    protected void buttonPressed(int buttonId) {
        TreeItem[] items = this.availableTablesTreeViewer.getTree().getSelection();
        boolean aliasIsUnique = true;
        this.tableValue = null;
        this.tablesList = new ArrayList();
        this.tableAlias = this.aliasTextField.getText().trim();
        if (buttonId == 0 && items != null && items.length > 0) {
            if (!(this.object instanceof QueryInsertStatement)) {
                if (items.length > 1) {
                    boolean currentTableExists = false;
                    int i = 0;
                    while (i < items.length) {
                        TreeItem treeItem = items[i];
                        Object treeItemData = treeItem.getData();
                        if (treeItemData instanceof Table) {
                            this.tableValue = (Table)treeItemData;
                        } else if (treeItemData instanceof WithTableSpecification) {
                            this.tableValue = (WithTableSpecification)treeItemData;
                        }
                        if (this.tableValue != null) {
                            Vector refTables = new Vector();
                            SQLQueryObject stmt = (SQLQueryObject)this.object;
                            List refTableList = StatementHelper.getTablesForStatement((SQLQueryObject)stmt);
                            if (refTableList.size() > 0) {
                                refTables.addAll(refTableList);
                                currentTableExists = this.checkForTable(refTables, this.tableValue);
                            }
                            if (!currentTableExists) {
                                this.tablesList.add(this.tableValue);
                            } else {
                                this.errorLabel.setText(Messages._ERROR_TABLE_USED);
                                this.availableTablesTree.forceFocus();
                                return;
                            }
                        }
                        ++i;
                    }
                } else {
                    if (!SQLStringHelper.isAlphanumericOrUnderscore(this.tableAlias)) {
                        this.errorLabel.setText(Messages._ERROR_ALIAS_NOT_ALPHANUMERIC);
                        return;
                    }
                    boolean tableExists = false;
                    if (aliasIsUnique) {
                        TreeItem treeItem = items[0];
                        Object treeItemData = treeItem.getData();
                        if (treeItemData instanceof Table) {
                            this.tableValue = (Table)treeItemData;
                        } else if (treeItemData instanceof WithTableSpecification) {
                            this.tableValue = (WithTableSpecification)treeItemData;
                        }
                        if (this.tableValue == null) {
                            return;
                        }
                        Vector refTables = new Vector();
                        SQLQueryObject stmt = (SQLQueryObject)this.object;
                        List refTableList = StatementHelper.getTablesForStatement((SQLQueryObject)stmt);
                        if (refTableList.size() > 0) {
                            refTables.addAll(refTableList);
                            tableExists = this.checkForTable(refTables, this.tableValue);
                            aliasIsUnique = this.checkforAlias(refTables, this.aliasTextField.getText().trim());
                        }
                        if (tableExists && this.tableAlias.length() < 1) {
                            this.errorLabel.setText(Messages._ERROR_TABLE_USED);
                            this.availableTablesTree.forceFocus();
                            return;
                        }
                    }
                    if (!aliasIsUnique) {
                        this.errorLabel.setText(Messages._ERROR_ALIAS_USED);
                        this.aliasTextField.selectAll();
                        this.aliasTextField.forceFocus();
                        return;
                    }
                    this.setReturnCode(0);
                    if (this.tableValue != null) {
                        this.tablesList.add(this.tableValue);
                    }
                }
            } else if (this.object instanceof QueryInsertStatement) {
                TreeItem treeItem = items[0];
                Object treeItemData = treeItem.getData();
                if (treeItemData instanceof Table) {
                    this.tableValue = (Table)treeItemData;
                }
                if (this.tableValue == null) {
                    return;
                }
                this.tablesList.add(this.tableValue);
            }
        } else if (buttonId == 1) {
            this.setReturnCode(1);
        }
        this.close();
    }

    public boolean checkForTable(Vector tableVector, SQLObject checkTable) {
        Iterator iterator = tableVector.iterator();
        while (iterator.hasNext()) {
            TableExpression sqlTable = (TableExpression)iterator.next();
            if (!TableHelper.getExposedTableName((TableExpression)sqlTable).equalsIgnoreCase(checkTable.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean checkforAlias(Vector tableVector, String aliasName) {
        Iterator iterator = tableVector.iterator();
        while (iterator.hasNext()) {
            TableExpression sqlTable = (TableExpression)iterator.next();
            if (!TableHelper.getExposedTableName((TableExpression)sqlTable).equalsIgnoreCase(aliasName)) continue;
            return false;
        }
        return true;
    }

    public Control createDialogArea(Composite parent) {
        Composite panel = ViewUtility.createComposite(parent, 1, true, true);
        WorkbenchHelp.setHelp((Control)panel, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqlb1100");
        this.createInputPanel(panel);
        return panel;
    }

    Composite createInputPanel(Composite parent) {
        Composite panel = ViewUtility.createComposite(parent, 2, true, true);
        ViewUtility.createLabel(panel, Messages._UI_LABEL_TABLE_NAME);
        QueryStatement stmt = this.domainModel.getSQLStatement();
        if (stmt instanceof QuerySelectStatement || stmt instanceof QuerySelect) {
            this.availableTablesTree = new Tree(panel, 2818);
            this.availableTablesTree.addSelectionListener((SelectionListener)new TableSelectionListener());
        } else {
            this.availableTablesTree = new Tree(panel, 2820);
        }
        GridData treeGridData = new GridData(1808);
        treeGridData.widthHint = 50;
        treeGridData.heightHint = 100;
        this.availableTablesTree.setLayoutData((Object)treeGridData);
        this.availableTablesTreeViewer = new TreeViewer(this.availableTablesTree){

            public boolean isExpandable(Object node) {
                boolean isExpandable = false;
                if (node instanceof Schema) {
                    isExpandable = true;
                } else if (node instanceof TableCorrelation) {
                    isExpandable = true;
                }
                return isExpandable;
            }
        };
        ArrayList schemaList = new ArrayList();
        Database database = this.domainModel.getDatabase();
        if (database != null) {
            schemaList.addAll(DatabaseHelper.getSchemaList(database));
        }
        AvailableTablesTreeProvider provider = new AvailableTablesTreeProvider(schemaList, this.domainModel);
        this.availableTablesTreeViewer.setContentProvider((IContentProvider)provider);
        this.availableTablesTreeViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.availableTablesTreeViewer.setInput((Object)provider);
        this.tableAliasLabel = ViewUtility.createLabel(panel, Messages._UI_LABEL_TABLE_ALIAS);
        this.aliasTextField = ViewUtility.createTextField(panel, 240);
        this.errorLabel = ViewUtility.createLabel(panel, "");
        GridData gd = (GridData)this.errorLabel.getLayoutData();
        gd.horizontalSpan = 2;
        return panel;
    }

    public SQLObject getTableValue() {
        return this.tableValue;
    }

    public List getTablesList() {
        return this.tablesList;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    class TableSelectionListener
    implements SelectionListener {
        TableSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TreeItem[] items = AddTableDialog.this.availableTablesTreeViewer.getTree().getSelection();
            if (items.length > 1) {
                AddTableDialog.this.aliasTextField.setEnabled(false);
            } else {
                AddTableDialog.this.aliasTextField.setEnabled(true);
            }
        }
    }
}

