/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.datatypes.ApproximateNumericDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.FixedPrecisionDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.NumericalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.PredicateComparisonOperator;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionDefaultValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNullValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionScalarSelect;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple;
import org.eclipse.datatools.modelbase.sql.query.helper.DataTypeHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.ValueExpressionHelper;
import org.eclipse.datatools.modelbase.sql.query.impl.SQLQueryModelFactoryImpl;
import org.eclipse.datatools.modelbase.sql.tables.Column;

public class ExpressionHelper {
    private static SQLQueryModelFactory factory;
    private String QuotesContext = "";

    public ExpressionHelper() {
        factory = SQLQueryModelFactoryImpl.eINSTANCE;
    }

    public boolean containsParameterName(String source) {
        boolean containsParam = false;
        String paramName = this.findParameterName(source);
        if (paramName.length() > 0) {
            containsParam = true;
        }
        return containsParam;
    }

    public boolean firstParameterChar(String source) {
        boolean firstParamChar = false;
        if (source.length() > 0 && " :@|&*/-+><(),\r\n\t".indexOf(source.trim().charAt(0)) >= 0) {
            firstParamChar = true;
        }
        return firstParamChar;
    }

    public static ValueExpressionColumn createValueExpressionColumn(String name, TableExpression tblExpr) {
        ValueExpressionColumn colExpr = null;
        colExpr = factory.createValueExpressionColumn();
        colExpr.setName(name);
        colExpr.setTableExpr(tblExpr);
        return colExpr;
    }

    public static ValueExpressionColumn createValueExpressionColumn(ValueExpressionColumn oldValExpr) {
        ValueExpressionColumn colExpr = null;
        colExpr = factory.createValueExpressionColumn();
        if (oldValExpr != null) {
            colExpr.setName(oldValExpr.getName());
            if (oldValExpr.getParentTableExpr() != null) {
                colExpr.setTableExpr(oldValExpr.getParentTableExpr());
            } else if (oldValExpr.getTableExpr() != null) {
                colExpr.setTableExpr(oldValExpr.getTableExpr());
            }
            colExpr.setDataType(ValueExpressionHelper.copyDataType((DataType)oldValExpr.getDataType()));
        }
        return colExpr;
    }

    public static QueryValueExpression createValueExpressionNullValue() {
        ValueExpressionNullValue expr = factory.createValueExpressionNullValue();
        return expr;
    }

    public static QueryValueExpression createValueExpressionDefaultValue() {
        ValueExpressionDefaultValue expr = factory.createValueExpressionDefaultValue();
        return expr;
    }

    public static QueryValueExpression createExpression() {
        ValueExpressionSimple expr = factory.createValueExpressionSimple();
        return expr;
    }

    public static QueryValueExpression createExpression(Object item) {
        QueryValueExpression expr = null;
        if (item instanceof String) {
            String source = (String)item;
            ValueExpressionSimple simpleExpr = factory.createValueExpressionSimple();
            simpleExpr.setValue(source);
            expr = simpleExpr;
        } else if (item instanceof QueryValueExpression) {
            expr = (QueryValueExpression)item;
        }
        return expr;
    }

    public static ValueExpressionColumn createColumnExpression(TableExpression table, Column col) {
        ValueExpressionColumn colExpr = factory.createValueExpressionColumn();
        colExpr.setName(col.getName());
        colExpr.setTableExpr(table);
        colExpr.setDataType(ValueExpressionHelper.copyDataType((DataType)col.getDataType()));
        return colExpr;
    }

    public PredicateBasic createPredicate(Object left, Object right, String comparisonKind) {
        PredicateBasic sqlPredicate = factory.createPredicateBasic();
        sqlPredicate.setLeftValueExpr(ExpressionHelper.createExpression(left));
        sqlPredicate.setRightValueExpr(ExpressionHelper.createExpression(right));
        sqlPredicate.setComparisonOperator(PredicateComparisonOperator.get((String)comparisonKind));
        return sqlPredicate;
    }

    public static ValueExpressionFunction createFunction(String functionName) {
        ValueExpressionFunction function = factory.createValueExpressionFunction();
        function.setName(functionName);
        return function;
    }

    public static ValueExpressionFunction createFunction(String functionName, List parmList) {
        ValueExpressionFunction function = ExpressionHelper.createFunction(functionName);
        if (parmList != null && parmList.size() > 0) {
            function.getParameterList().addAll((Collection)parmList);
        }
        return function;
    }

    public ValueExpressionScalarSelect createScalarSelect(QueryStatement stmt) {
        ValueExpressionScalarSelect newSubQuery = factory.createValueExpressionScalarSelect();
        if (stmt instanceof QuerySelectStatement) {
            QueryExpressionRoot queryExpr = ((QuerySelectStatement)stmt).getQueryExpr();
            newSubQuery.setQueryExpr(queryExpr);
        }
        return newSubQuery;
    }

    public ValueExpressionCast createCast(QueryValueExpression expr, String dataType) {
        ValueExpressionCast sqlCast = factory.createValueExpressionCast();
        sqlCast.setValueExpr(expr);
        sqlCast.setDataType((DataType)DataTypeHelper.getPredefinedDataTypeForNamedType((String)dataType));
        return sqlCast;
    }

    protected String findParameterName(String source) {
        String paramName = "";
        int scanState = 0;
        int paramStartIndex = -1;
        int paramEndIndex = -1;
        String delims = " :@|&*/-+><(),\r\n\t";
        StringCharacterIterator iter = new StringCharacterIterator(source);
        char c = iter.first();
        int scanIndex = 0;
        while (c != '\uffff' && paramName.length() == 0) {
            boolean needNext = true;
            switch (scanState) {
                case 0: {
                    if (c == '\'') {
                        scanState = 1;
                        break;
                    }
                    if (c == '\"') {
                        scanState = 2;
                        break;
                    }
                    if (c != ':' && c != '@' && c != '?') break;
                    scanState = 3;
                    paramStartIndex = scanIndex;
                    break;
                }
                case 1: {
                    if (c != '\'') break;
                    c = iter.next();
                    ++scanIndex;
                    if (c == '\'') break;
                    scanState = 0;
                    needNext = false;
                    break;
                }
                case 2: {
                    if (c != '\"') break;
                    c = iter.next();
                    ++scanIndex;
                    if (c == '\"') break;
                    scanState = 0;
                    needNext = false;
                    break;
                }
                case 3: {
                    if (delims.indexOf(c) < 0) break;
                    paramEndIndex = scanIndex;
                    paramName = source.substring(paramStartIndex, paramEndIndex);
                    scanState = 0;
                }
            }
            if (!needNext) continue;
            c = iter.next();
            ++scanIndex;
        }
        if (scanState == 3) {
            paramEndIndex = source.length();
            paramName = source.substring(paramStartIndex, paramEndIndex);
        }
        return paramName;
    }

    public String getQuotesContext() {
        return this.QuotesContext;
    }

    public void setQuotesContext(String quotesContext) {
        this.QuotesContext = quotesContext;
    }

    public String appendQuotes(DataType columnType, String value) {
        if (columnType instanceof PredefinedDataType) {
            int dataTypeInt = ((PredefinedDataType)columnType).getPrimitiveType().getValue();
            value = this.appendQuotes(dataTypeInt, value);
        }
        return value;
    }

    public String appendQuotes(String columnType, String value) {
        int dataTypeInt = PrimitiveType.get((String)columnType).getValue();
        value = this.appendQuotes(dataTypeInt, value);
        return value;
    }

    public String appendQuotes(int columnType, String value) {
        if (value.indexOf(40) >= 0 || value.indexOf(41) >= 0 || value.indexOf(124) >= 0) {
            return value;
        }
        if ((this.getQuotesContext().equalsIgnoreCase("insert") || this.getQuotesContext().equalsIgnoreCase("update")) && (value.equalsIgnoreCase("NULL") || value.equalsIgnoreCase("DEFAULT"))) {
            return value;
        }
        switch (columnType) {
            case 0: 
            case 1: 
            case 2: 
            case 18: {
                if (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"") || this.containsParameterName(value)) break;
                value = "'" + value + "'";
                break;
            }
            case 19: 
            case 20: {
                if (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"") || this.firstParameterChar(value)) break;
                value = "'" + value + "'";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if ((value.startsWith("G'") || value.startsWith("g'") || value.startsWith("N'") || value.startsWith("n'")) && value.endsWith("'")) break;
                value = value.startsWith("'") && value.endsWith("'") ? "N" + value : "N'" + value + "'";
                String percent = "\uff05";
                String gPercent = "N'" + percent;
                String percentEnd = String.valueOf(percent) + "'";
                if (value.startsWith("N'%")) {
                    value = new StringBuffer(value).replace(0, 3, gPercent).toString();
                }
                if (!value.endsWith("%'")) break;
                value = new StringBuffer(value).replace(value.length() - 2, value.length(), percentEnd).toString();
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if ((value.startsWith("X'") || value.startsWith("x'")) && value.endsWith("'")) break;
                if (value.startsWith("'") && value.endsWith("'")) {
                    value = "X" + value;
                    break;
                }
                value = "X'" + value + "'";
                break;
            }
            default: {
                if (!value.startsWith("'") || !value.endsWith("'") || value.length() < 2) break;
                value = value.substring(1, value.length() - 1);
            }
        }
        return value;
    }

    public void resolveColumnReferencesInTemporaryStatement(QuerySelect select, List tableExprList) {
        if (select != null && select.getFromClause() != null) {
            List fromTableList = TableHelper.getTableExpressionsInTableReferenceList((List)select.getFromClause());
            Iterator fromTableIt = fromTableList.iterator();
            while (fromTableIt.hasNext()) {
                String tableName;
                TableExpression fromTable = (TableExpression)fromTableIt.next();
                String schemaName = TableHelper.getSchemaNameForTableExpression((TableExpression)fromTable);
                TableExpression matchingTable = TableHelper.findTableExpressionInTableExpressionList((String)schemaName, (String)(tableName = fromTable.getName()), (List)tableExprList);
                if (matchingTable == null) continue;
                matchingTable.getValueExprColumns().addAll((Collection)fromTable.getValueExprColumns());
                fromTable.getValueExprColumns().clear();
            }
        }
    }

    public static ValueExpressionNested createNestedExpression(QueryValueExpression expr) {
        ValueExpressionNested nestingExpr = factory.createValueExpressionNested();
        nestingExpr.setNestedValueExpr(expr);
        return nestingExpr;
    }

    public static boolean isComplete(QueryValueExpression expr) {
        boolean isComplete = true;
        if (expr instanceof ValueExpressionCombined) {
            ValueExpressionCombined parent = (ValueExpressionCombined)expr;
            QueryValueExpression leftChild = parent.getLeftValueExpr();
            QueryValueExpression rightChild = parent.getRightValueExpr();
            if (leftChild != null && rightChild == null) {
                isComplete = false;
            }
        }
        return isComplete;
    }

    public static void replaceExpression(QueryValueExpression oldExpr, QueryValueExpression newExpr) {
        if (oldExpr != null) {
            ValueExpressionCombined parent = oldExpr.getValueExprCombinedLeft();
            if (parent != null) {
                parent.setLeftValueExpr(newExpr);
                newExpr.setValueExprCombinedLeft(parent);
            } else {
                parent = oldExpr.getValueExprCombinedRight();
                if (parent != null) {
                    parent.setRightValueExpr(newExpr);
                    newExpr.setValueExprCombinedRight(parent);
                }
            }
        }
    }

    public static void replaceOperator(QueryValueExpression expression, ValueExpressionCombinedOperator newOperator) {
        if (expression != null) {
            ValueExpressionCombined parent = expression.getValueExprCombinedLeft();
            if (parent != null) {
                parent.setCombinedOperator(newOperator);
            } else {
                ValueExpressionCombined gParent;
                parent = expression.getValueExprCombinedRight();
                if (parent != null && (gParent = parent.getValueExprCombinedLeft()) != null) {
                    gParent.setCombinedOperator(newOperator);
                }
            }
        }
    }

    public static void addExpression(QueryValueExpression prevExpr, QueryValueExpression newExpr, ValueExpressionCombinedOperator operator) {
        if (prevExpr != null) {
            ValueExpressionCombined parent = prevExpr.getValueExprCombinedLeft();
            if (parent != null) {
                if (parent.getRightValueExpr() == null) {
                    parent.setRightValueExpr(newExpr);
                    if (newExpr != null) {
                        newExpr.setValueExprCombinedRight(parent);
                    }
                }
            } else {
                parent = prevExpr.getValueExprCombinedRight();
                ValueExpressionCombined newParent = factory.createValueExpressionCombined();
                if (parent != null) {
                    newParent.setLeftValueExpr((QueryValueExpression)parent);
                    parent.setValueExprCombinedLeft(newParent);
                } else {
                    newParent.setLeftValueExpr(prevExpr);
                    prevExpr.setValueExprCombinedLeft(newParent);
                }
                newParent.setRightValueExpr(newExpr);
                if (newExpr != null) {
                    newExpr.setValueExprCombinedRight(newParent);
                }
                newParent.setCombinedOperator(operator);
            }
        }
    }

    public static void removeExpression(QueryValueExpression expr) {
        if (expr != null) {
            ValueExpressionCombined parent = expr.getValueExprCombinedLeft();
            if (parent != null) {
                QueryValueExpression rightChild = parent.getRightValueExpr();
                if (rightChild != null) {
                    ValueExpressionCombined gParent = parent.getValueExprCombinedLeft();
                    if (gParent != null) {
                        gParent.setLeftValueExpr(rightChild);
                        rightChild.setValueExprCombinedLeft(gParent);
                    } else {
                        parent.setLeftValueExpr(rightChild);
                        parent.setRightValueExpr(null);
                        rightChild.setValueExprCombinedLeft(parent);
                        rightChild.setValueExprCombinedRight(null);
                    }
                } else {
                    parent.setLeftValueExpr(null);
                }
            } else {
                parent = expr.getValueExprCombinedRight();
                if (parent != null) {
                    QueryValueExpression leftChild = parent.getLeftValueExpr();
                    ValueExpressionCombined gParent = parent.getValueExprCombinedLeft();
                    if (gParent != null) {
                        gParent.setLeftValueExpr(leftChild);
                        if (leftChild != null) {
                            leftChild.setValueExprCombinedLeft(gParent);
                        }
                    } else {
                        leftChild.setValueExprCombinedLeft(null);
                    }
                }
            }
        }
    }

    public static String getDisplayString(String opString) {
        String displayStr = "";
        if (opString.equals("ADD")) {
            displayStr = "+";
        } else if (opString.equals("SUBTRACT")) {
            displayStr = "-";
        } else if (opString.equals("MULTIPLY")) {
            displayStr = "*";
        } else if (opString.equals("DIVIDE")) {
            displayStr = "/";
        } else if (opString.equals("CONCATENATE")) {
            displayStr = "CONCAT";
        }
        return displayStr;
    }

    public static ValueExpressionCombinedOperator createCombinedOperator(String opType) {
        String operator = null;
        if (opType.equals("+")) {
            operator = "ADD";
        } else if (opType.equals("-")) {
            operator = "SUBTRACT";
        } else if (opType.equals("*")) {
            operator = "MULTIPLY";
        } else if (opType.equals("/")) {
            operator = "DIVIDE";
        } else if (opType.equals("CONCAT")) {
            operator = "CONCATENATE";
        }
        ValueExpressionCombinedOperator combOpr = ValueExpressionCombinedOperator.get((String)operator);
        return combOpr;
    }

    public static QueryValueExpression getRoot(QueryValueExpression node) {
        ValueExpressionCombined temp;
        QueryValueExpression root = node;
        if (node != null && (temp = node.getValueExprCombinedLeft()) != null) {
            root = ExpressionHelper.getRoot((QueryValueExpression)temp);
        }
        return root;
    }

    public static QueryValueExpression getLowestLeftChild(QueryValueExpression expr) {
        QueryValueExpression leftChild;
        QueryValueExpression lowestLeftChild = expr;
        if (expr instanceof ValueExpressionCombined && (leftChild = ((ValueExpressionCombined)expr).getLeftValueExpr()) != null) {
            lowestLeftChild = ExpressionHelper.getLowestLeftChild(leftChild);
        }
        return lowestLeftChild;
    }

    public static TableExpression getTableExprForValueExpressionColumn(ValueExpressionColumn colValExp) {
        TableExpression retTableExpr = null;
        retTableExpr = colValExp.getParentTableExpr();
        if (retTableExpr == null) {
            retTableExpr = colValExp.getTableExpr();
        }
        return retTableExpr;
    }

    public static String getDefaultValueForColumn(Column aColumn) {
        String defaultValue = "''";
        if (aColumn != null) {
            DataType datatype = aColumn.getDataType();
            if (datatype instanceof NumericalDataType) {
                defaultValue = datatype instanceof ApproximateNumericDataType ? "0.0" : (datatype instanceof FixedPrecisionDataType ? "0.0" : "0");
            } else if (datatype instanceof DateDataType) {
                defaultValue = "'2000-01-01'";
            } else if (datatype instanceof TimeDataType) {
                TimeDataType timetype = (TimeDataType)datatype;
                PrimitiveType primitiveType = timetype.getPrimitiveType();
                if (primitiveType.getValue() == 19) {
                    defaultValue = "'00.00.00'";
                } else if (primitiveType.getValue() == 20) {
                    defaultValue = "'2000-01-01-00.00.00'";
                }
            }
        }
        return defaultValue;
    }
}

