/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.actions;

import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorImages;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.Messages;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.RoutineAction;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.LaunchingJob;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DebugAction
extends RoutineAction {
    private SQLEditor _sqlEditor;

    public DebugAction() {
        this.init();
    }

    public DebugAction(Object selectedResource) {
        this.init();
        this.initSQLObject((IAction)this, selectedResource);
        this.initConnectionProfile();
        this.update();
    }

    public DebugAction(SQLEditor targetEditor) {
        this.init();
        this.setActiveEditor(targetEditor);
        this.update();
    }

    protected void init() {
        this.setId("org.eclipse.datatools.sqltools.sqleditor.debugAction");
        this.setText(Messages.DebugAction_label);
        this.setToolTipText(Messages.DebugAction_tooltip);
        this.setImageDescriptor(RoutineEditorImages.getImageDescriptor("debug_exc"));
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.debugAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.datatools.sqltools.sqleditor.debug_action");
    }

    public void setActiveEditor(SQLEditor targetEditor) {
        this._sqlEditor = targetEditor;
    }

    public void run() {
        ProcIdentifier proc = null;
        if (this._sqlEditor == null || this._sqlEditor.getEditorInput() == null) {
            try {
                proc = SQLDevToolsUtil.getProcIdentifier((DatabaseIdentifier)new DatabaseIdentifier(this._connectionProfile.getName(), this.getDatabaseName()), (SQLObject)this._sqlObject);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                this.openEditor(proc, page);
            }
            catch (Exception e) {
                RoutineEditorActivator.getDefault().log(e);
            }
        } else {
            ProcEditorInput procEditorInput = (ProcEditorInput)this._sqlEditor.getEditorInput();
            proc = procEditorInput.getProcIdentifier();
        }
        if (proc != null) {
            LaunchingJob launchingJob = new LaunchingJob(proc, "debug");
            launchingJob.schedule();
        }
    }

    protected IEditorPart openEditor(ProcIdentifier proc, IWorkbenchPage page) throws PartInitException {
        return page.openEditor((IEditorInput)new ProcEditorInput(proc), "org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditor");
    }

    public void update() {
        boolean enabled = false;
        String profileName = null;
        if (this._sqlEditor != null && this._sqlEditor.getConnectionInfo().getSharedConnection() != null && this._sqlEditor.getEditorInput() instanceof ProcEditorInput) {
            profileName = this._sqlEditor.getConnectionInfo().getConnectionProfileName();
            enabled = true;
        } else if (this._sqlObject != null && this._connectionProfile != null) {
            enabled = true;
            profileName = this._connectionProfile.getName();
        }
        if (enabled) {
            try {
                DatabaseIdentifier di = new DatabaseIdentifier(profileName);
                enabled = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(di).supportsDebugging();
            }
            catch (Exception e) {
                RoutineEditorActivator.getDefault().log(Messages.common_error, e);
                enabled = false;
            }
        }
        this.setEnabled(enabled);
    }

    public void run(IAction action) {
        this.run(null);
    }
}

