/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.actions;

import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.RoutineEditor;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorImages;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.Messages;
import org.eclipse.datatools.sqltools.routineeditor.ui.actions.RoutineAction;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.LaunchingJob;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RunAction
extends RoutineAction
implements IActionDelegate {
    private RoutineEditor _sqlEditor;

    public RunAction() {
        this.init();
    }

    public RunAction(Object selectedResource) {
        this.init();
        this.initSQLObject((IAction)this, selectedResource);
        this.initConnectionProfile();
        this.update();
    }

    public RunAction(RoutineEditor targetEditor) {
        this.init();
        this.setActiveEditor(targetEditor);
        this.update();
    }

    protected void init() {
        this.setId("org.eclipse.datatools.sqltools.sqleditor.runAction");
        this.setText(Messages.RunAction_label);
        this.setToolTipText(Messages.RunAction_tooltip);
        this.setImageDescriptor(RoutineEditorImages.getImageDescriptor("execute"));
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.runAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.datatools.sqltools.sqleditor.run_action");
    }

    public void setActiveEditor(RoutineEditor targetEditor) {
        this._sqlEditor = targetEditor;
    }

    public void run() {
        this.run(null);
    }

    public void update() {
        boolean enabled = this._sqlEditor != null && this._sqlEditor.getConnectionInfo().getSharedConnection() != null && this._sqlEditor.getEditorInput() instanceof ProcEditorInput;
        enabled = enabled || this._sqlObject != null && this._connectionProfile != null;
        this.setEnabled(enabled);
    }

    public void run(IAction action) {
        ProcIdentifier proc = null;
        IEditorPart parent = null;
        if (this._sqlEditor == null || this._sqlEditor.getEditorInput() == null) {
            try {
                proc = SQLDevToolsUtil.getProcIdentifier((DatabaseIdentifier)new DatabaseIdentifier(this._connectionProfile.getName(), this.getDatabaseName()), (SQLObject)this._sqlObject);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                parent = this.openEditor(proc, page);
            }
            catch (Exception e) {
                RoutineEditorActivator.getDefault().log(e);
            }
        } else {
            ProcEditorInput procEditorInput = (ProcEditorInput)this._sqlEditor.getEditorInput();
            proc = procEditorInput.getProcIdentifier();
            parent = this._sqlEditor.getParentEditor();
        }
        if (proc != null) {
            LaunchingJob launchingJob = new LaunchingJob(proc, "run");
            launchingJob.schedule();
        }
    }

    protected IEditorPart openEditor(ProcIdentifier proc, IWorkbenchPage page) throws PartInitException {
        return page.openEditor((IEditorInput)new ProcEditorInput(proc), "org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditor");
    }
}

