/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataTypeStringParser {
    private static final Pattern datatypePattern = Pattern.compile("\\s*(\\w+)\\s*(\\(\\s*(\\d+)\\s*(\\,\\s*(\\d+))*\\s*\\))?\\s*");

    private boolean isValid(String datatype) {
        Matcher m = datatypePattern.matcher(datatype);
        if (m.matches()) {
            m = null;
            return true;
        }
        return false;
    }

    public String[] parseDatatype(String dataType) {
        if (!this.isValid(dataType)) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        Matcher m = datatypePattern.matcher(dataType);
        if (m.matches()) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                if (m.group(i) == null || i % 2 != 1) continue;
                result.add(m.group(i).toString().trim());
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

