/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.dbitem;

import java.util.Vector;
import org.eclipse.datatools.sqltools.common.core.tableviewer.AbstractTableData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.Messages;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterWrapper;

public class ParametersData
extends AbstractTableData {
    private static final String[] COLUMN_NAMES = new String[]{Messages.ParameterTableViewer_name, Messages.ParameterTableViewer_type, Messages.ParameterTableViewer_null, Messages.ParameterTableViewer_value, Messages.ParameterTableViewer_inout};
    public static final int[] COLUMN_LENGTH = new int[]{90, 80, 45, 142, 65};
    public static final int NAME_COLUMN = 0;
    public static final int TYPE_COLUMN = 1;
    public static final int NULL_COLUMN = 2;
    public static final int VALUE_COLUMN = 3;
    public static final int INOUT_COLUMN = 4;
    private ParameterWrapper[] _wrappers;

    public ParametersData(ParameterWrapper[] wrappers) {
        this._wrappers = wrappers;
    }

    public boolean isReadonly() {
        return false;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    public int getColumnType(int col) {
        if (col == 2) {
            return 16;
        }
        return 1;
    }

    public String getColumnHeader(int col) {
        return COLUMN_NAMES[col];
    }

    public Vector getRows() {
        Vector<ParameterWrapper> rows = new Vector<ParameterWrapper>();
        for (int i = 0; i < this._wrappers.length; ++i) {
            Object[] rowData = new Object[this.getColumnCount()];
            ParameterDescriptor pd = this._wrappers[i].getParameterDescriptor();
            rowData[0] = pd != null ? pd.getName() : "";
            String typeName = "";
            if (pd != null) {
                typeName = pd.getSqlTypeNameFromParser() != null ? pd.getSqlTypeNameFromParser() : pd.getTypeName();
            }
            rowData[1] = typeName;
            rowData[2] = this._wrappers[i].isNull() ? "true" : "false";
            rowData[3] = this._wrappers[i].getValue();
            rowData[4] = pd != null ? pd.getParamTypeAsString() : "";
            this._wrappers[i].setData(rowData);
            this._wrappers[i].setTableData((ITableData)this);
            rows.add(this._wrappers[i]);
        }
        return rows;
    }

    public boolean save() throws Exception {
        return false;
    }

    public void dispose() {
    }

    public boolean isNewRowDataAllowed() {
        return false;
    }
}

