/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.profile.provider;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;

public class ProfilePropertyProviderImpl
implements IPropertyProvider {
    private static final String sm_className = ProfilePropertyProviderImpl.class.getName();
    private static Logger sm_logger;

    public Properties getDataSourceProperties(Properties candidateProperties, Object appContext) throws OdaException {
        String methodName = "getDataSourceProperties";
        IConnectionProfile connProfile = this.getConnectionProfile(candidateProperties, appContext);
        if (connProfile == null) {
            return candidateProperties;
        }
        Properties mergedProps = new Properties();
        mergedProps.putAll((Map<?, ?>)candidateProperties);
        mergedProps.remove("OdaConnProfileName");
        mergedProps.remove("OdaConnProfileStorePath");
        Properties profileProps = connProfile.getBaseProperties();
        if (profileProps != null) {
            mergedProps.putAll((Map<?, ?>)profileProps);
        }
        if (ProfilePropertyProviderImpl.getLogger().isLoggable(Level.FINER)) {
            String logMsg = sm_className + "." + "getDataSourceProperties" + ": ";
            logMsg = logMsg + "Number of Candidate Properties = " + candidateProperties.size();
            logMsg = logMsg + "; Number of Properties in profile = " + profileProps.size();
            logMsg = logMsg + "; Number of Merged Effective Properties = " + mergedProps.size();
            ProfilePropertyProviderImpl.getLogger().finer(logMsg);
        }
        return mergedProps;
    }

    protected IConnectionProfile getConnectionProfile(Properties candidateProperties, Object connPropContext) {
        if (candidateProperties == null || candidateProperties.isEmpty()) {
            return null;
        }
        String profileName = this.getProfileName(candidateProperties);
        if (profileName == null) {
            return null;
        }
        File profileStore = this.getProfileStoreFile(connPropContext);
        if (profileStore == null) {
            profileStore = this.getProfileStoreFile(candidateProperties);
        }
        IConnectionProfile profile = null;
        try {
            profile = OdaProfileExplorer.getInstance().getProfileByName(profileName, profileStore);
        }
        catch (OdaException ex) {
            ProfilePropertyProviderImpl.getLogger().warning(ProfilePropertyProviderImpl.getStackTraceStrings(ex));
        }
        if (profile == null) {
            ProfilePropertyProviderImpl.getLogger().warning("No connection profile is found by its specified name: " + profileName);
        }
        return profile;
    }

    protected String getProfileName(Properties candidateProperties) {
        String profileName = candidateProperties.getProperty("OdaConnProfileName");
        if (profileName == null || profileName.length() == 0) {
            return null;
        }
        return profileName;
    }

    protected File getProfileStoreFile(Object connPropContext) {
        if (connPropContext == null || !(connPropContext instanceof Map)) {
            return null;
        }
        Object propValue = ((Map)connPropContext).get("OdaConnProfileStore");
        if (propValue == null) {
            return null;
        }
        if (propValue instanceof File && ((File)propValue).exists()) {
            return (File)propValue;
        }
        ProfilePropertyProviderImpl.getLogger().warning("getProfileStoreFile( Object ): Ignoring the PROFILE_STORE_FILE_PROP_KEY object in Connection Property Context.  The specified object must be an existing File.");
        return null;
    }

    protected File getProfileStoreFile(Properties candidateProperties) {
        String profileStoreFilePath = candidateProperties.getProperty("OdaConnProfileStorePath");
        if (profileStoreFilePath == null || profileStoreFilePath.length() == 0) {
            return null;
        }
        File profileStoreFile = this.getProfileStoreFile(profileStoreFilePath);
        if (profileStoreFile != null) {
            return profileStoreFile;
        }
        ProfilePropertyProviderImpl.getLogger().warning("getProfileStoreFile( Properties ): Ignoring the PROFILE_STORE_FILE_PATH_PROP_KEY value in connection properties. The specified path does not exist in file system.");
        return null;
    }

    protected File getProfileStoreFile(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        try {
            URL url = new URL(filePath);
            return new File(FileLocator.toFileURL((URL)url).getPath());
        }
        catch (MalformedURLException ex) {
            ProfilePropertyProviderImpl.getLogger().warning("getProfileStoreFile( String ): " + ex.toString());
        }
        catch (IOException ex) {
            ProfilePropertyProviderImpl.getLogger().warning("getProfileStoreFile( String ): " + ex.toString());
        }
        return null;
    }

    private static Logger getLogger() {
        if (sm_logger == null) {
            sm_logger = Logger.getLogger(sm_className);
        }
        return sm_logger;
    }

    private static String getStackTraceStrings(Throwable ex) {
        String logMsg = ex.toString() + "\n";
        Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
        StackTraceElement[] stacks = cause.getStackTrace();
        for (int i = 0; i < stacks.length; ++i) {
            logMsg = logMsg + stacks[i].toString() + "\n";
        }
        return logMsg;
    }
}

