/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.model.ResultItem;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;

public abstract class ResultSection {
    protected IResultInstance _resultInstance;
    protected IPreferenceStore _store;
    protected boolean _displayRowNumber;
    protected boolean _showRowCountMsg;
    protected boolean _showHeadings;
    protected String _nullValue;
    protected Composite _parent;
    protected ResultsView _view;
    protected List _displayedItems;

    public ResultSection(IResultInstance instance, ResultsView view) {
        this._view = view;
        this._resultInstance = instance;
        this._store = ResultsViewPlugin.getDefault().getPreferenceStore();
        this._displayRowNumber = this._store.getBoolean("org.eclipse.datatools.sqltools.result.preferences.display.showrownumber");
        this._nullValue = this._store.getString("org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr");
        this._showRowCountMsg = this._store.getBoolean("org.eclipse.datatools.sqltools.result.preferences.display.showrowcountmsg");
        this._showHeadings = this._store.getBoolean("org.eclipse.datatools.sqltools.result.preferences.display.showheadings");
        this._displayedItems = new ArrayList();
    }

    public abstract Composite getControl();

    public void showDetail(IResultInstance instance) {
        if (instance == this._resultInstance) {
            return;
        }
        int count = instance.getItemCount();
        for (int i = 0; i < count; ++i) {
            this._displayedItems.add(instance.getItem(i));
        }
    }

    public abstract void onNewItemAppended(ResultItem var1, int var2);

    public abstract void onParametersShown(List var1);

    public abstract void onInstanceFinished();

    public abstract void onInstanceReseted();

    public void showTab(int tabType) {
    }

    public void showResultSet(IResultSetObject result) {
    }

    public void showTab(int tabType, int tabNumber) {
    }

    public int getRowCount() {
        return -1;
    }
}

