/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.Parameter;
import org.eclipse.datatools.sqltools.result.ResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.model.ResultItem;
import org.eclipse.datatools.sqltools.result.internal.model.XMLResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.ExportAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.ExportResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.PrintResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.SaveAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.SaveResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsView;
import org.eclipse.datatools.sqltools.result.internal.ui.view.SingleWindowModeSection;
import org.eclipse.datatools.sqltools.result.internal.ui.viewer.ResultSetViewer;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.StatusTextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SingleWindowGridSection
extends SingleWindowModeSection {
    private ScrolledComposite _scrolledComp;
    private Composite _comp;
    private Text _preText;
    private ResultItem _preItem;
    private Table _paramTable;

    public SingleWindowGridSection(Composite composite, ResultsView view) {
        super(composite, view);
        this._parent = composite;
    }

    public SingleWindowGridSection(Composite composite, IResultInstance instance, ResultsView view) {
        super(composite, instance, view);
        this._parent = composite;
    }

    public void createInitialControl(Composite composite) {
        super.createInitialControl(composite);
        this._scrolledComp = new ScrolledComposite(this._composite, 768);
        this._scrolledComp.setLayout((Layout)new FillLayout());
        this._scrolledComp.setExpandHorizontal(true);
        this._scrolledComp.setExpandVertical(true);
        GridData gd = new GridData(1808);
        this._scrolledComp.setLayoutData((Object)gd);
        this._comp = new Composite((Composite)this._scrolledComp, 0);
        this._scrolledComp.setContent((Control)this._comp);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this._comp.setLayout((Layout)layout);
        composite.layout(true);
    }

    protected void createViewerForResultInstance(IResultInstance instance) {
        int count = instance.getItemCount();
        for (int i = 0; i < count; ++i) {
            ResultItem item = instance.getItem(i);
            this.createWidgetForItem(this._comp, item);
        }
        this.onInstanceFinished();
        this._comp.layout(true);
        this._scrolledComp.setMinSize(this._comp.computeSize(-1, -1));
    }

    public void onNewItemAppended(ResultItem item, int index) {
        if (this._resultInstance == null || this._displayedItems.contains(item)) {
            return;
        }
        this._displayedItems.add(item);
        this.createWidgetForItem(this._comp, item);
        this._scrolledComp.setMinSize(this._comp.computeSize(-1, -1));
        this._comp.layout(true);
    }

    private void createWidgetForItem(Composite composite, ResultItem item) {
        if (this._preItem != null && this._preItem.getResultType() != 3 && item.getResultType() != 3 && this._preText != null) {
            if (item.getResultType() == 2 || item.getResultType() == 4) {
                this._preText.append((String)item.getResultObject());
            } else if (item.getResultType() == 1) {
                this._preText.append(StatusTextProvider.getUpdateCountText((Integer)item.getResultObject()));
            }
            this._preItem = item;
            return;
        }
        this._preItem = item;
        switch (item.getResultType()) {
            case 2: 
            case 4: {
                Text messageText;
                this._preText = messageText = new Text(composite, 2);
                GridData gd = new GridData(768);
                messageText.setLayoutData((Object)gd);
                messageText.setText((String)item.getResultObject());
                messageText.setEditable(false);
                break;
            }
            case 1: {
                Text updateCountText;
                if (!this._showRowCountMsg) break;
                this._preText = updateCountText = new Text(composite, 2);
                GridData gd = new GridData(768);
                updateCountText.setLayoutData((Object)gd);
                updateCountText.setText(StatusTextProvider.getUpdateCountText((Integer)item.getResultObject()));
                updateCountText.setEditable(false);
                break;
            }
            case 3: {
                IResultSetObject result = (IResultSetObject)item.getResultObject();
                if (!result.isAllResultLoaded()) {
                    this._isResultHid = true;
                }
                if (result instanceof XMLResultSetObject) {
                    this.createTextforResultSet(composite, result);
                }
                if (!(result instanceof ResultSetObject)) break;
                this.createTableViewerForResultSet(composite, result);
                break;
            }
        }
    }

    public Composite getControl() {
        return this._composite;
    }

    private void createTableViewerForResultSet(Composite composite, IResultSetObject result) {
        ResultSetViewer viewer = new ResultSetViewer(composite, 65540, this._resultInstance, result, this._displayRowNumber);
        GridData gd = new GridData(768);
        int height = viewer.getTable().getHeaderHeight();
        int itemHeight = viewer.getTable().getItemHeight();
        int itemCount = viewer.getTable().getItemCount() == 1 ? 2 : viewer.getTable().getItemCount();
        gd.heightHint = height += (itemCount - 1) * itemHeight;
        viewer.getTable().setLayoutData((Object)gd);
    }

    private void createTextforResultSet(Composite composite, IResultSetObject result) {
        Text txt = new Text(composite, 10);
        txt.setLayoutData((Object)new GridData(768));
        StringBuffer buf = new StringBuffer();
        Iterator iter = result.getDisplayRecords();
        while (iter != null && iter.hasNext()) {
            IResultSetRow row = (IResultSetRow)iter.next();
            for (int i = 0; row.getData() != null && i < row.getData().length; ++i) {
                buf.append(row.getData(i));
            }
        }
        String s = buf.toString();
        txt.setText(s);
        MenuManager mgr = new MenuManager();
        MenuManager saveMgr = new MenuManager(Messages.Save_name);
        saveMgr.add((IAction)new SaveResultSetAction(txt.getShell(), result));
        saveMgr.add((IAction)new SaveAllResultSetsAction(txt.getShell(), this._resultInstance));
        MenuManager exportMgr = new MenuManager(Messages.Export_name);
        exportMgr.add((IAction)new ExportResultSetAction(txt.getShell(), result));
        exportMgr.add((IAction)new ExportAllResultSetsAction(txt.getShell(), this._resultInstance));
        MenuManager printMgr = new MenuManager(Messages.Print_name);
        printMgr.add((IAction)new PrintResultSetAction(result, this._parent));
        printMgr.add((IAction)new PrintResultSetAction(this._resultInstance, this._parent));
        mgr.add((IContributionItem)saveMgr);
        mgr.add((IContributionItem)exportMgr);
        mgr.add((IContributionItem)printMgr);
        Menu menu = mgr.createContextMenu((Control)txt);
        txt.setMenu(menu);
    }

    public void onInstanceFinished() {
        super.onInstanceFinished();
        if (this._resultInstance.getParameters() == null) {
            return;
        }
        Text inout = new Text(this._comp, 10);
        inout.setLayoutData((Object)new GridData(768));
        inout.setText(Messages.SingleWindowGridSection_inout_params);
        List params = this.getValidParamList(this._resultInstance.getParameters());
        this.createTableForParameters(this._comp);
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Parameter param = (Parameter)iter.next();
            TableItem item = new TableItem(this._paramTable, 0);
            item.setText(0, param.getParamName());
            item.setText(1, param.getParamType());
            item.setText(2, param.getParamDataType());
            item.setText(3, param.getParamValue());
            item.setText(4, param.getParamOutValue());
        }
        this._comp.layout(true);
        this._scrolledComp.setMinSize(this._comp.computeSize(-1, -1));
    }

    private void createTableForParameters(Composite comp) {
        TableViewer paramViewer = new TableViewer(comp, 66048);
        this._paramTable = paramViewer.getTable();
        this._paramTable.setLinesVisible(true);
        this._paramTable.setHeaderVisible(true);
        this._paramTable.setLayoutData((Object)new GridData(768));
        TableColumn nameColumn = new TableColumn(this._paramTable, 0);
        nameColumn.setText(Messages.MultipleTabsGridSection_parameter_name);
        TableColumn typeColumn = new TableColumn(this._paramTable, 0);
        typeColumn.setText(Messages.MultipleTabsGridSection_parameter_type);
        TableColumn dataTypeColumn = new TableColumn(this._paramTable, 0);
        dataTypeColumn.setText(Messages.MultipleTabsGridSection_parameter_datatype);
        TableColumn valueColumn = new TableColumn(this._paramTable, 0);
        valueColumn.setText(Messages.MultipleTabsGridSection_value);
        TableColumn outValueColumn = new TableColumn(this._paramTable, 0);
        outValueColumn.setText(Messages.MultipleTabsGridSection_value_out);
        int defaultWidth = 0;
        int columnCount = this._paramTable.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this._paramTable.getColumn(i);
            column.pack();
            defaultWidth = defaultWidth + column.getWidth() + this._paramTable.getGridLineWidth();
        }
        int moreWidth = comp.getParent().getBounds().width - 2 - defaultWidth;
        if (moreWidth > 0) {
            for (int i = 0; i < columnCount; ++i) {
                TableColumn col = this._paramTable.getColumn(i);
                col.setWidth(col.getWidth() + moreWidth / columnCount);
            }
        }
        this._paramTable.pack();
    }

    public void onInstanceReseted() {
        Control[] controls = this._comp.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].dispose();
        }
    }
}

