/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.util;

import java.io.IOException;
import java.io.InputStream;

class CompositeInputStream
extends InputStream {
    private byte[] buf;
    private int pos;
    private InputStream stream;

    public CompositeInputStream(byte[] buffer, InputStream stream) {
        this.buf = buffer;
        this.stream = stream;
        this.pos = 0;
    }

    public synchronized int read() throws IOException {
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        ++this.pos;
        return this.stream.read();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.pos + len <= this.buf.length) {
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }
        if (this.pos < this.buf.length) {
            int readLen = this.buf.length - this.pos;
            System.arraycopy(this.buf, this.pos, b, off, readLen);
            int sReadLen = this.stream.read(b, off + readLen, len - readLen);
            if (sReadLen != -1) {
                readLen += sReadLen;
            }
            this.pos += readLen;
            return readLen;
        }
        int readLen = this.stream.read(b, off, len);
        if (readLen != -1) {
            this.pos += readLen;
        }
        return readLen;
    }

    public synchronized long skip(long n) throws IOException {
        if ((long)this.pos + n <= (long)this.buf.length) {
            this.pos = (int)((long)this.pos + n);
            return n;
        }
        if (this.pos < this.buf.length) {
            this.pos = (int)((long)this.pos + n);
            return this.stream.skip(this.pos - this.buf.length);
        }
        return this.stream.skip(n);
    }

    public synchronized int available() throws IOException {
        return this.stream.available() + this.buf.length - this.pos;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) {
    }

    public synchronized void reset() {
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

